/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sensor.gyro;

import java.io.File;
import java.text.DecimalFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.tizen.ecp.legacy.InjectorMessage;
import org.tizen.ecp.sensor.accelerometer.AccConstants;
import org.tizen.ecp.sensor.accelerometer.AccelerometerDisplay;
import org.tizen.ecp.sensor.gyro.GyroFileFinished;
import org.tizen.ecp.sensor.gyro.GyroFileOperation;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.FormUtil;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.utils.SwtUtil;
import org.tizen.ecp.widgets.ECPButton;
import org.tizen.ecp.widgets.ECPSlider;

public class GyroDisplay
implements GyroFileFinished {
    private AccelerometerDisplay display;
    private Logger logger = LogUtil.getECPLogger(GyroDisplay.class).getLogger();
    private ECPSlider xSlider;
    private ECPSlider ySlider;
    private ECPSlider zSlider;
    private Text xText;
    private Text yText;
    private Text zText;
    double xValue;
    double yValue;
    double zValue;
    DecimalFormat df = new DecimalFormat("0.##");
    private Text filenameText;
    private Text repeatText;
    private ECPButton startButton;
    private ECPButton stopButton;
    private ECPButton deleteButton;
    private ECPButton addButton;
    private Table table;
    private int repeatCount = 1;
    private int fileCnt = 0;
    private SelectionAdapter sliderSelection = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (selectionEvent.widget == GyroDisplay.this.xSlider) {
                int n = GyroDisplay.this.xSlider.getSelection() - 1000;
                GyroDisplay.this.xValue = (double)n * 0.01;
                GyroDisplay.this.xText.setText(GyroDisplay.this.df.format(GyroDisplay.this.xValue));
                GyroDisplay.this.sendMessage();
            } else if (selectionEvent.widget == GyroDisplay.this.ySlider) {
                int n = GyroDisplay.this.ySlider.getSelection() - 1000;
                GyroDisplay.this.yValue = (double)n * 0.01;
                GyroDisplay.this.yText.setText(GyroDisplay.this.df.format(GyroDisplay.this.yValue));
                GyroDisplay.this.sendMessage();
            } else if (selectionEvent.widget == GyroDisplay.this.zSlider) {
                int n = GyroDisplay.this.zSlider.getSelection() - 1000;
                GyroDisplay.this.zValue = (double)n * 0.01;
                GyroDisplay.this.zText.setText(GyroDisplay.this.df.format(GyroDisplay.this.zValue));
                GyroDisplay.this.sendMessage();
            }
        }
    };
    private KeyAdapter textSelection = new KeyAdapter(){

        public void keyReleased(KeyEvent keyEvent) {
            String string = null;
            if (keyEvent.widget == GyroDisplay.this.xText) {
                string = GyroDisplay.this.xText.getText().trim();
            } else if (keyEvent.widget == GyroDisplay.this.yText) {
                string = GyroDisplay.this.yText.getText().trim();
            } else if (keyEvent.widget == GyroDisplay.this.zText) {
                string = GyroDisplay.this.zText.getText().trim();
            }
            if (string == null || string.length() == 0 || "-".equals(string) || string.endsWith(".")) {
                return;
            }
            try {
                if (!FormUtil.isNumeric((String)string) || Double.parseDouble(string) < -10.0 || Double.parseDouble(string) > 10.0) {
                    throw null;
                }
            }
            catch (NumberFormatException numberFormatException) {
                Shell shell = GyroDisplay.this.display.getComposite().getShell();
                SwtUtil.openInfoDialog((Shell)shell, (String)"Emulator Control Panel", (String)"Please enter the correct value.\nThe value can be entered in the range of -10  to 10.");
                if (keyEvent.widget == GyroDisplay.this.xText) {
                    GyroDisplay.this.xText.setText(GyroDisplay.this.df.format(GyroDisplay.this.xValue));
                } else if (keyEvent.widget == GyroDisplay.this.yText) {
                    GyroDisplay.this.yText.setText(GyroDisplay.this.df.format(GyroDisplay.this.yValue));
                } else if (keyEvent.widget == GyroDisplay.this.zText) {
                    GyroDisplay.this.zText.setText(GyroDisplay.this.df.format(GyroDisplay.this.zValue));
                }
                return;
            }
            catch (Exception exception) {
                Shell shell = GyroDisplay.this.display.getComposite().getShell();
                SwtUtil.openInfoDialog((Shell)shell, (String)"Emulator Control Panel", (String)"Please enter the correct value.\nThe value can be entered in the range of -10  to 10.");
                if (keyEvent.widget == GyroDisplay.this.xText) {
                    GyroDisplay.this.xText.setText(GyroDisplay.this.df.format(GyroDisplay.this.xValue));
                } else if (keyEvent.widget == GyroDisplay.this.yText) {
                    GyroDisplay.this.yText.setText(GyroDisplay.this.df.format(GyroDisplay.this.yValue));
                } else if (keyEvent.widget == GyroDisplay.this.zText) {
                    GyroDisplay.this.zText.setText(GyroDisplay.this.df.format(GyroDisplay.this.zValue));
                }
                return;
            }
            if (keyEvent.widget == GyroDisplay.this.xText) {
                GyroDisplay.this.xValue = Double.parseDouble(string);
                int n = (int)(Double.parseDouble(string) * 100.0 + 1000.0);
                GyroDisplay.this.xSlider.setSelection(n, false);
            } else if (keyEvent.widget == GyroDisplay.this.yText) {
                GyroDisplay.this.yValue = Double.parseDouble(string);
                int n = (int)(Double.parseDouble(string) * 100.0 + 1000.0);
                GyroDisplay.this.ySlider.setSelection(n, false);
            } else if (keyEvent.widget == GyroDisplay.this.zText) {
                GyroDisplay.this.zValue = Double.parseDouble(string);
                int n = (int)(Double.parseDouble(string) * 100.0 + 1000.0);
                GyroDisplay.this.zSlider.setSelection(n, false);
            }
            GyroDisplay.this.sendMessage();
        }
    };
    private static final double GYRO_ADJUST = 57.142857142857146;

    public GyroDisplay(AccelerometerDisplay accelerometerDisplay) {
        this.display = accelerometerDisplay;
        GyroFileOperation.getInstance().registerFileOperation(this);
    }

    public void createDisplay(Composite composite) {
        this.createUserGyro(composite);
        this.createFileInput(composite);
    }

    private void setDefaultValue(ECPSlider eCPSlider) {
        eCPSlider.setValues(1000, 0, 2000, 1, 1, 50);
    }

    private ECPSlider createSlider(Composite composite) {
        ECPSlider eCPSlider = FormUtil.createECPSlider((Composite)composite);
        this.setDefaultValue(eCPSlider);
        eCPSlider.setLayoutData((Object)FormUtil.createGD((int)290, (int)22, (int)0, (int)4));
        eCPSlider.addSelectionListener((SelectionListener)this.sliderSelection);
        return eCPSlider;
    }

    private Text createText(Composite composite, String string) {
        Text text = FormUtil.createText((Composite)composite, (String)string);
        text.setLayoutData((Object)FormUtil.createGD((int)40, (int)22));
        text.setTextLimit(5);
        text.addKeyListener((KeyListener)this.textSelection);
        return text;
    }

    private void createUserGyro(Composite composite) {
        FormUtil.createLabel((Composite)composite, (String)"Gyro");
        Composite composite2 = FormUtil.createComposite((Composite)composite, (int)4);
        GridData gridData = FormUtil.createHGD();
        gridData.widthHint = 491;
        composite2.setLayoutData((Object)FormUtil.createHGD());
        FormUtil.createLabel((Composite)composite2, (String)"X : ");
        this.xSlider = this.createSlider(composite2);
        this.xValue = 0.0;
        this.xText = this.createText(composite2, this.df.format(this.xValue));
        FormUtil.createLabel((Composite)composite2, (String)"[radians/sec]", (Font)AccConstants.UNIT_FONT_SIZE);
        FormUtil.createLabel((Composite)composite2, (String)"Y : ");
        this.ySlider = this.createSlider(composite2);
        this.yValue = 0.0;
        this.yText = this.createText(composite2, this.df.format(this.yValue));
        FormUtil.createLabel((Composite)composite2, (String)"[radians/sec]", (Font)AccConstants.UNIT_FONT_SIZE);
        FormUtil.createLabel((Composite)composite2, (String)"Z : ");
        this.zSlider = this.createSlider(composite2);
        this.zValue = 0.0;
        this.zText = this.createText(composite2, this.df.format(this.zValue));
        FormUtil.createLabel((Composite)composite2, (String)"[radians/sec]", (Font)AccConstants.UNIT_FONT_SIZE);
    }

    private void createFileInput(Composite composite) {
        FormUtil.createLabel((Composite)composite, (String)"File input");
        Composite composite2 = FormUtil.createComposite((Composite)composite, (int)4);
        GridData gridData = FormUtil.createHGD();
        gridData.widthHint = 491;
        composite2.setLayoutData((Object)gridData);
        this.filenameText = FormUtil.createText((Composite)composite2, (String)"");
        gridData = FormUtil.createGD((int)250, (int)22);
        this.filenameText.setLayoutData((Object)gridData);
        this.filenameText.setEditable(false);
        ECPButton eCPButton = FormUtil.createPushButton((Composite)composite2, (String)"Browse");
        eCPButton.setLayoutData((Object)FormUtil.createGD((int)80, (int)22));
        eCPButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(new Shell());
                String string = fileDialog.open();
                if (string == null) {
                    return;
                }
                GyroDisplay.this.filenameText.setText(string);
            }
        });
        this.addButton = FormUtil.createPushButton((Composite)composite2, (String)"Add");
        this.addButton.setLayoutData((Object)FormUtil.createGD((int)80, (int)22));
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = GyroDisplay.this.filenameText.getText();
                if (string.isEmpty()) {
                    return;
                }
                if (GyroDisplay.this.fileCnt == 5) {
                    Shell shell = GyroDisplay.this.display.getComposite().getShell();
                    SwtUtil.openInfoDialog((Shell)shell, (String)"Emulator Control Panel", (String)"The maximum number of files is 5.");
                    return;
                }
                TableItem tableItem = new TableItem(GyroDisplay.this.table, 0);
                String[] stringArray = new String[]{Integer.toString(++GyroDisplay.this.fileCnt), string};
                tableItem.setText(stringArray);
                GyroDisplay.this.startButton.setEnabled(true);
                GyroDisplay.this.deleteButton.setEnabled(true);
            }
        });
        Composite composite3 = FormUtil.createComposite((Composite)composite, (int)1);
        gridData = FormUtil.createHGD();
        gridData.widthHint = 491;
        composite3.setLayoutData((Object)gridData);
        this.table = new Table(composite3, 2050);
        gridData = FormUtil.createGD((int)430, (int)90);
        this.table.setLayoutData((Object)gridData);
        TableColumn tableColumn = new TableColumn(this.table, 0x1000000);
        TableColumn tableColumn2 = new TableColumn(this.table, 16384);
        tableColumn.setText("No.");
        tableColumn2.setText("          File path");
        tableColumn.setWidth(80);
        tableColumn2.setWidth(350);
        this.table.setHeaderVisible(true);
        Composite composite4 = FormUtil.createComposite((Composite)composite, (int)8);
        FormUtil.createLabel((Composite)composite4, (String)"Repeat :    ");
        ECPButton eCPButton2 = FormUtil.createPushButton((Composite)composite4, (String)"<");
        eCPButton2.setLayoutData((Object)FormUtil.createGD((int)16, (int)22));
        eCPButton2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (GyroDisplay.this.repeatCount != 1) {
                    GyroDisplay.this.repeatCount = GyroDisplay.this.repeatCount - 1;
                }
                GyroDisplay.this.repeatText.setText(String.format("%d", GyroDisplay.this.repeatCount));
            }
        });
        this.repeatText = FormUtil.createText((Composite)composite4, (String)String.format("%d", this.repeatCount));
        this.repeatText.setLayoutData((Object)FormUtil.createGD((int)8, (int)22));
        this.repeatText.setEditable(false);
        ECPButton eCPButton3 = FormUtil.createPushButton((Composite)composite4, (String)">");
        eCPButton3.setLayoutData((Object)FormUtil.createGD((int)16, (int)22));
        eCPButton3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (GyroDisplay.this.repeatCount != 9) {
                    GyroDisplay.this.repeatCount = GyroDisplay.this.repeatCount + 1;
                }
                GyroDisplay.this.repeatText.setText(String.format("%d", GyroDisplay.this.repeatCount));
            }
        });
        FormUtil.createLabel((Composite)composite4, (String)" ");
        this.startButton = FormUtil.createPushButton((Composite)composite4, (String)"Start");
        this.startButton.setLayoutData((Object)FormUtil.createGD((int)80, (int)22));
        this.startButton.setEnabled(false);
        this.startButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n;
                for (int i = 0; i < GyroDisplay.this.fileCnt; ++i) {
                    TableItem tableItem = GyroDisplay.this.table.getItem(i);
                    File file = new File(tableItem.getText(1));
                    if (!file.exists()) continue;
                    GyroFileOperation.getInstance().addFile(file.getPath());
                }
                try {
                    n = Integer.parseInt(GyroDisplay.this.repeatText.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    GyroDisplay.this.logger.log(Level.SEVERE, "Number format", numberFormatException);
                    n = 1;
                }
                GyroFileOperation.getInstance().setRepeatCount(n);
                GyroDisplay.this.startButton.setEnabled(false);
                GyroDisplay.this.stopButton.setEnabled(true);
                GyroDisplay.this.deleteButton.setEnabled(false);
                GyroDisplay.this.addButton.setEnabled(false);
                GyroFileOperation.getInstance().startInjection();
            }
        });
        this.stopButton = FormUtil.createPushButton((Composite)composite4, (String)"Stop");
        this.stopButton.setLayoutData((Object)FormUtil.createGD((int)80, (int)22));
        this.stopButton.setEnabled(false);
        this.stopButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GyroFileOperation.getInstance().stopInjection();
                GyroDisplay.this.stopButton.setEnabled(false);
                GyroDisplay.this.startButton.setEnabled(true);
                GyroDisplay.this.deleteButton.setEnabled(true);
                GyroDisplay.this.addButton.setEnabled(true);
            }
        });
        this.deleteButton = FormUtil.createPushButton((Composite)composite4, (String)"Delete");
        this.deleteButton.setLayoutData((Object)FormUtil.createGD((int)80, (int)22));
        this.deleteButton.setEnabled(false);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int[] nArray = GyroDisplay.this.table.getSelectionIndices();
                GyroDisplay.this.fileCnt = GyroDisplay.this.fileCnt - nArray.length;
                GyroDisplay.this.table.remove(nArray);
                for (int i = 0; i < GyroDisplay.this.fileCnt; ++i) {
                    GyroDisplay.this.table.getItem(i).setText(Integer.toString(i + 1));
                }
                if (GyroDisplay.this.fileCnt == 0) {
                    GyroDisplay.this.startButton.setEnabled(false);
                    GyroDisplay.this.deleteButton.setEnabled(false);
                }
            }
        });
    }

    public void sendMessage() {
        this.xValue = Double.parseDouble(this.xText.getText());
        this.yValue = Double.parseDouble(this.yText.getText());
        this.zValue = Double.parseDouble(this.zText.getText());
        InjectorMessage injectorMessage = new InjectorMessage(this.xValue * 57.142857142857146, this.yValue * 57.142857142857146, this.zValue * 57.142857142857146);
        MessageSender.getInstance().sendDeviceReq("sensor", 0, 0, "4\n" + injectorMessage.getMessage());
    }

    @Override
    public void fileOpsFinished() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                GyroDisplay.this.stopButton.setEnabled(false);
                GyroDisplay.this.startButton.setEnabled(true);
                GyroDisplay.this.deleteButton.setEnabled(true);
                GyroDisplay.this.addButton.setEnabled(true);
            }
        });
    }

    public void setStatus(String string) {
        if (!string.isEmpty()) {
            String[] stringArray = string.split(",");
            double d = (double)Math.round(Double.parseDouble(stringArray[0]) / 57.142857142857146 * 100.0) / 100.0;
            double d2 = (double)Math.round(Double.parseDouble(stringArray[1]) / 57.142857142857146 * 100.0) / 100.0;
            double d3 = (double)Math.round(Double.parseDouble(stringArray[2]) / 57.142857142857146 * 100.0) / 100.0;
            this.xText.setText("" + d);
            this.yText.setText("" + d2);
            this.zText.setText("" + d3);
            int n = (int)(d * 100.0 + 1000.0);
            this.xSlider.setSelection(n, false);
            int n2 = (int)(d2 * 100.0 + 1000.0);
            this.ySlider.setSelection(n2, false);
            int n3 = (int)(d3 * 100.0 + 1000.0);
            this.zSlider.setSelection(n3, false);
        }
    }
}

