/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sensor.light;

import com.google.protobuf.GeneratedMessage;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.tizen.ecp.dialogs.MessageDialog;
import org.tizen.ecp.legacy.InjectorMessage;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sensor.light.LightConstants;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.sock.SocketClient;
import org.tizen.ecp.utils.FormUtil;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.ECPSubView;
import org.tizen.ecp.widgets.ECPSlider;

public class LightDisplay
extends ECPSubView {
    private static Logger logger = LogUtil.getECPLogger(LightDisplay.class).getLogger();
    private Text luxText;
    private ECPSlider slider;
    private Composite comp;
    private int luxData = 65535;
    private FocusAdapter focusAdapter = new FocusAdapter(){

        public void focusLost(FocusEvent focusEvent) {
            if (LightDisplay.this.luxText.getText().isEmpty()) {
                LightDisplay.this.luxText.setText("0");
            }
        }
    };
    private SelectionAdapter sliderAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            LightDisplay.this.luxData = LightDisplay.this.slider.getSelection();
            LightDisplay.this.luxText.setText(Integer.toString(LightDisplay.this.luxData));
        }
    };
    private VerifyListener luxVerify = new VerifyListener(){

        /*
         * Enabled aggressive block sorting
         */
        public void verifyText(VerifyEvent verifyEvent) {
            String string = LightDisplay.this.luxText.getText();
            if (verifyEvent.character == '\b') {
                if (verifyEvent.end == 1) {
                    string = string.substring(verifyEvent.end, string.length());
                } else {
                    if (verifyEvent.start == 0) {
                        verifyEvent.doit = false;
                        return;
                    }
                    string = string.substring(0, verifyEvent.start) + string.substring(verifyEvent.end, string.length());
                }
            } else if (string.isEmpty() && verifyEvent.text.length() != 0) {
                string = verifyEvent.text;
            } else {
                if (verifyEvent.text.length() == 1 && LightDisplay.this.checkNumberFormat(verifyEvent.text)) {
                    verifyEvent.doit = false;
                    return;
                }
                string = verifyEvent.start == 0 && verifyEvent.text.length() == 1 && LightDisplay.this.slider.getSelection() < 10 ? verifyEvent.text : (verifyEvent.start == 0 && verifyEvent.text.length() == 1 && LightDisplay.this.slider.getSelection() != 0 ? verifyEvent.text.concat(string) : (verifyEvent.start == string.length() ? string.concat(verifyEvent.text) : string.substring(0, verifyEvent.start) + verifyEvent.text + string.substring(verifyEvent.end, string.length())));
            }
            if (LightDisplay.this.validateLuxNumber(string)) {
                LightDisplay.this.luxData = Integer.parseInt(string);
                LightDisplay.this.slider.setSelection(LightDisplay.this.luxData, false);
                LightDisplay.this.setData();
            }
        }
    };

    public LightDisplay() {
        this.title = "Sensor";
        this.pageHeight = 100;
        this.useTimer = true;
    }

    public void OnTimerMessageExpired() {
        logger.info("OnTimerMessageExpired");
        MessageSender.getInstance().sendDeviceReq("sensor", 15, 113);
    }

    public void createView(Composite composite) {
        FormUtil.createLabel((Composite)composite, (String)"Light", (Font)LightConstants.TITLE_FONT, (Color)LightConstants.TITLE_COLOR);
        this.comp = FormUtil.createComposite((Composite)composite, (int)3);
        FormUtil.createLabel((Composite)this.comp, (String)"Lux");
        this.slider = FormUtil.createECPSlider((Composite)this.comp);
        GridData gridData = FormUtil.createGD((int)384, (int)21, (int)0, (int)4);
        this.slider.setLayoutData((Object)gridData);
        this.slider.addSelectionListener((SelectionListener)this.sliderAdapter);
        this.luxText = FormUtil.createText((Composite)this.comp, (int)0x1000800);
        gridData = FormUtil.createGD((int)50, (int)22);
        this.luxText.setLayoutData((Object)gridData);
        this.luxText.setTextLimit(5);
        this.luxText.addVerifyListener(this.luxVerify);
        this.luxText.addFocusListener((FocusListener)this.focusAdapter);
    }

    protected void initializeWidget() {
        this.slider.setValues(this.luxData, 0, 65535, 1, 1, 100);
    }

    private void setData() {
        if (!SocketClient.getInstance().getGuestStatus()) {
            MessageDialog messageDialog = new MessageDialog();
            messageDialog.openInfoDialog("Emulator is not ready. Please retry when the emulator is ready.");
        } else {
            this.send(2, this.luxData);
        }
    }

    private boolean checkNumberFormat(String string) {
        Pattern pattern = Pattern.compile("[^0-9]");
        Matcher matcher = pattern.matcher(string);
        return matcher.find();
    }

    private boolean validateLuxNumber(String string) {
        try {
            if (Integer.parseInt(string) < 0 || Integer.parseInt(string) > 65535) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void send(int n, int n2) {
        InjectorMessage injectorMessage = new InjectorMessage(n, n2);
        MessageSender.getInstance().sendDeviceReq("sensor", 0, 0, "3\n" + injectorMessage.getMessage());
    }

    public void destroyContents(Composite composite) {
        composite.layout(true, true);
    }

    public boolean Create() {
        this.createPage();
        EventMgr.getInstance().AddLsn("sensor", (ILsn)this);
        return true;
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
        Ecs.DeviceNtf deviceNtf;
        long l;
        if (generatedMessage instanceof Ecs.DeviceNtf && 113L == (l = (long)(deviceNtf = (Ecs.DeviceNtf)generatedMessage).getAction())) {
            String string = deviceNtf.getData().toStringUtf8();
            try {
                this.luxData = Integer.parseInt(string);
                this.slider.setSelection(this.luxData);
            }
            catch (NumberFormatException numberFormatException) {
                logger.log(Level.SEVERE, "Numberformat", numberFormatException);
            }
        }
    }
}

