/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sensor.uv;

import com.google.protobuf.GeneratedMessage;
import java.text.DecimalFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.tizen.ecp.dialogs.MessageDialog;
import org.tizen.ecp.legacy.InjectorMessage;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sensor.uv.UVConstants;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.sock.SocketClient;
import org.tizen.ecp.utils.FormUtil;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.ECPSubView;
import org.tizen.ecp.widgets.ECPSlider;

public class UVDisplay
extends ECPSubView {
    private static Logger logger = LogUtil.getECPLogger(UVDisplay.class).getLogger();
    private Text levelText;
    private ECPSlider slider;
    private Composite comp;
    private int levelData = 0;
    DecimalFormat mf = new DecimalFormat("#0.0");
    private FocusAdapter focusAdapter = new FocusAdapter(){

        public void focusLost(FocusEvent focusEvent) {
            String string = UVDisplay.this.levelText.getText();
            if (string.isEmpty() || !UVDisplay.this.validateUVNumber(string)) {
                UVDisplay.this.levelText.setText(UVDisplay.this.mf.format((float)UVDisplay.this.levelData / 10.0f));
            }
        }
    };
    private SelectionAdapter sliderAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            UVDisplay.this.levelData = UVDisplay.this.slider.getSelection();
            UVDisplay.this.levelText.setText(UVDisplay.this.mf.format((float)UVDisplay.this.levelData / 10.0f));
        }
    };
    private VerifyListener uvVerify = new VerifyListener(){

        /*
         * Enabled aggressive block sorting
         */
        public void verifyText(VerifyEvent verifyEvent) {
            String string = ((Text)verifyEvent.widget).getText();
            if (verifyEvent.start == 0 && verifyEvent.text.equals("-")) {
                string = verifyEvent.text.concat(string);
            } else if (verifyEvent.character == '\b') {
                if (verifyEvent.end == 1) {
                    string = string.substring(verifyEvent.end, string.length());
                } else {
                    if (verifyEvent.start == 0) {
                        verifyEvent.doit = false;
                        return;
                    }
                    string = string.substring(0, verifyEvent.start) + string.substring(verifyEvent.end, string.length());
                }
            } else {
                if (verifyEvent.text.length() == 1 && UVDisplay.this.checkNumberFormat(verifyEvent.text)) {
                    verifyEvent.doit = false;
                    return;
                }
                string = verifyEvent.start == 0 && verifyEvent.text.length() == 1 ? verifyEvent.text.concat(string) : (string.isEmpty() && verifyEvent.text.length() != 0 ? verifyEvent.text : (verifyEvent.start == string.length() ? string.concat(verifyEvent.text) : string.substring(0, verifyEvent.start) + verifyEvent.text + string.substring(verifyEvent.end, string.length())));
            }
            if (UVDisplay.this.validateUVNumber(string)) {
                UVDisplay.this.levelData = (int)(Float.parseFloat(string) * 10.0f);
                UVDisplay.this.slider.setSelection(UVDisplay.this.levelData, false);
                UVDisplay.this.setData();
            }
        }
    };

    public UVDisplay() {
        this.title = "Sensor";
        this.pageHeight = 100;
        this.useTimer = true;
    }

    public void OnTimerMessageExpired() {
        logger.info("OnTimerMessageExpired");
        MessageSender.getInstance().sendDeviceReq("sensor", 15, 117);
    }

    public void createView(Composite composite) {
        FormUtil.createLabel((Composite)composite, (String)"Ultraviolet Sensor", (Font)UVConstants.TITLE_FONT, (Color)UVConstants.TITLE_COLOR);
        this.comp = FormUtil.createComposite((Composite)composite, (int)3);
        FormUtil.createLabel((Composite)this.comp, (String)"Index", (boolean)true, (int)50);
        this.slider = FormUtil.createECPSlider((Composite)this.comp);
        GridData gridData = FormUtil.createHGD((int)384, (int)21, (int)0, (int)4);
        this.slider.setLayoutData((Object)gridData);
        this.slider.addSelectionListener((SelectionListener)this.sliderAdapter);
        this.levelText = FormUtil.createText((Composite)this.comp, (int)0x1000800);
        gridData = FormUtil.createGD((int)50, (int)22);
        this.levelText.setLayoutData((Object)gridData);
        this.levelText.setTextLimit(5);
        this.levelText.addVerifyListener(this.uvVerify);
        this.levelText.addFocusListener((FocusListener)this.focusAdapter);
    }

    protected void initializeWidget() {
        this.slider.setValues(this.levelData, 0, 150, 1, 1, 10);
    }

    private void setData() {
        if (!SocketClient.getInstance().getGuestStatus()) {
            MessageDialog messageDialog = new MessageDialog();
            messageDialog.openInfoDialog("Emulator is not ready. Please retry when the emulator is ready.");
        } else {
            InjectorMessage injectorMessage = new InjectorMessage(this.levelData);
            MessageSender.getInstance().sendDeviceReq("sensor", 0, 0, "21\n" + injectorMessage.getMessage());
        }
    }

    private boolean checkNumberFormat(String string) {
        Pattern pattern = Pattern.compile("[^0-9]");
        Matcher matcher = pattern.matcher(string);
        return matcher.find();
    }

    private boolean validateUVNumber(String string) {
        try {
            if (Float.parseFloat(string) < 0.0f || Float.parseFloat(string) > 15.0f) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void destroyContents(Composite composite) {
        composite.layout(true, true);
    }

    public boolean Create() {
        this.createPage();
        EventMgr.getInstance().AddLsn("sensor", (ILsn)this);
        return true;
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
        Ecs.DeviceNtf deviceNtf;
        long l;
        if (generatedMessage instanceof Ecs.DeviceNtf && 117L == (l = (long)(deviceNtf = (Ecs.DeviceNtf)generatedMessage).getAction())) {
            String string = deviceNtf.getData().toStringUtf8();
            try {
                this.levelData = Integer.parseInt(string);
                this.levelText.setText(this.mf.format((float)this.levelData / 10.0f));
                this.slider.setSelection(this.levelData, false);
            }
            catch (NumberFormatException numberFormatException) {
                logger.log(Level.SEVERE, "Numberformat", numberFormatException);
            }
        }
    }
}

