/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.battery;

import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.tizen.ecp.battery.BatterySlider;
import org.tizen.ecp.legacy.InjectorMessage;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.resources.ColorResources;
import org.tizen.ecp.resources.FontResources;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.timer.MessageTimer;
import org.tizen.ecp.utils.FormUtil;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.ECPSubView;
import org.tizen.ecp.views.VMView;
import org.tizen.ecp.widgets.ECPButton;

public class BatteryDisplay
extends ECPSubView {
    private Composite comp;
    private BatterySlider slider;
    private int data;
    private boolean chargerOn = false;
    private Text sliderText;
    private ECPButton[] radioButton;
    private static Logger logger = LogUtil.getECPLogger(BatteryDisplay.class).getLogger();
    private FocusAdapter focusAdapter = new FocusAdapter(){

        public void focusLost(FocusEvent focusEvent) {
            String string = BatteryDisplay.this.sliderText.getText().trim();
            if (string.isEmpty() || string.equals("%")) {
                BatteryDisplay.this.sliderText.setText(Integer.toString(BatteryDisplay.this.slider.getSelection()) + "%");
            } else {
                String string2 = string;
                if (string2.endsWith(" ")) {
                    string2 = string2.substring(0, string.length() - 1);
                }
                if (string2.endsWith("%")) {
                    string2 = string2.substring(0, string.length() - 1);
                }
                try {
                    if (string2 == null || string2.isEmpty() || BatteryDisplay.this.checkNumberFormat(string2) || Double.parseDouble(string2) < 0.0 || Double.parseDouble(string2) > 100.0) {
                        BatteryDisplay.this.sliderText.setText(Integer.toString(BatteryDisplay.this.slider.getSelection()) + "%");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    BatteryDisplay.this.sliderText.setText(Integer.toString(BatteryDisplay.this.slider.getSelection()) + "%");
                }
                if (!string.endsWith("%")) {
                    BatteryDisplay.this.sliderText.setText(BatteryDisplay.this.sliderText.getText() + "%");
                }
            }
        }
    };
    public KeyAdapter textAdapter = new KeyAdapter(){

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.keyCode == 0x1000003 || keyEvent.keyCode == 0x1000004 || keyEvent.keyCode == 0x1000001 || keyEvent.keyCode == 0x1000002) {
                return;
            }
            int n = BatteryDisplay.this.sliderText.getCaretPosition();
            String string = BatteryDisplay.this.sliderText.getText().trim();
            String string2 = string.endsWith("%") ? string.substring(0, string.length() - 1) : string;
            if (string2 == null || string2.isEmpty()) {
                logger.severe("BATTERY swt TEXT number is empty");
                return;
            }
            try {
                if (keyEvent.keyCode == 32 || BatteryDisplay.this.checkNumberFormat(string2) || Double.parseDouble(string2) < 0.0 || Double.parseDouble(string2) > 100.0) {
                    throw null;
                }
            }
            catch (NumberFormatException numberFormatException) {
                BatteryDisplay.this.textErrorHandling();
                return;
            }
            catch (Exception exception) {
                BatteryDisplay.this.textErrorHandling();
                return;
            }
            try {
                BatteryDisplay.this.slider.setSelection(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            BatteryDisplay.this.sliderText.setSelection(n);
        }
    };
    private SelectionAdapter sliderSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (BatteryDisplay.this.data == BatteryDisplay.this.slider.getSelection()) {
                return;
            }
            BatteryDisplay.this.data = BatteryDisplay.this.slider.getSelection();
            BatteryDisplay.this.sliderText.setText(Integer.toString(BatteryDisplay.this.data) + "%");
            BatteryDisplay.this.send(1, BatteryDisplay.this.data);
        }
    };
    private SelectionAdapter chargerOnAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (BatteryDisplay.this.chargerOn) {
                return;
            }
            BatteryDisplay.this.chargerOn = true;
            BatteryDisplay.this.send(2, 1);
        }
    };
    private SelectionAdapter chargerOffAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (!BatteryDisplay.this.chargerOn) {
                return;
            }
            BatteryDisplay.this.chargerOn = false;
            BatteryDisplay.this.send(2, 0);
        }
    };

    public BatteryDisplay() {
        this.title = "Battery";
        this.pageHeight = 190;
        this.useTimer = true;
    }

    public void createView(Composite composite) {
        FormUtil.createLabel((Composite)composite, (String)"Level", (Font)FontResources.FONT_12.getFont(), (Color)ColorResources.TEXT_GREEN.getColor());
        this.comp = FormUtil.createComposite((Composite)composite, (int)2);
        this.slider = this.createBatterySlider(this.comp);
        GridData gridData = FormUtil.createGD((int)414, (int)54, (int)0, (int)4);
        this.slider.setLayoutData(gridData);
        this.slider.addSelectionListener((SelectionListener)this.sliderSelectionListener);
        this.sliderText = FormUtil.createText((Composite)this.comp, (int)0x1000800);
        gridData = new GridData(1, 2, false, false);
        gridData.widthHint = 45;
        gridData.verticalIndent = 20;
        this.sliderText.setLayoutData((Object)gridData);
        this.sliderText.setTextLimit(4);
        this.sliderText.addKeyListener((KeyListener)this.textAdapter);
        this.sliderText.addFocusListener((FocusListener)this.focusAdapter);
        FormUtil.createLabel((Composite)composite, (String)"Charger", (Font)FontResources.FONT_12.getFont(), (Color)ColorResources.TEXT_GREEN.getColor());
        Composite composite2 = FormUtil.createComposite((Composite)composite);
        gridData = new GridData();
        gridData.heightHint = 5;
        composite2.setLayoutData((Object)gridData);
        Composite composite3 = FormUtil.createComposite((Composite)composite, (int)2);
        gridData = FormUtil.createGD();
        gridData.widthHint = 103;
        gridData.horizontalIndent = 20;
        this.radioButton = new ECPButton[2];
        this.radioButton[0] = FormUtil.createECPButton((Composite)composite3, (String)"Connect", (int)16);
        this.radioButton[1] = FormUtil.createECPButton((Composite)composite3, (String)"Disconnect", (int)16);
        this.radioButton[0].setLayoutData((Object)gridData);
        this.radioButton[1].setLayoutData((Object)gridData);
        this.radioButton[0].addSelectionListener((SelectionListener)this.chargerOnAdapter);
        this.radioButton[1].addSelectionListener((SelectionListener)this.chargerOffAdapter);
        Composite composite4 = new Composite(composite, 0);
        composite4.setLayout((Layout)new GridLayout(1, false));
        gridData = new GridData(4, 3, true, true);
        gridData.heightHint = 200;
        composite4.setLayoutData((Object)gridData);
    }

    protected void initializeWidget() {
        this.slider.setValues(50, 0, 100);
    }

    public void displayContents(VMView vMView) {
        super.showComposite();
    }

    private boolean checkNumberFormat(String string) {
        Pattern pattern = Pattern.compile("[^0-9]");
        Matcher matcher = pattern.matcher(string);
        return matcher.find();
    }

    private void textErrorHandling() {
        int n = this.sliderText.getCaretPosition();
        String string = Integer.toString(this.slider.getSelection());
        this.sliderText.setText(string + "%");
        if (n > 0) {
            this.sliderText.setSelection(n - 1);
        }
    }

    public void send(int n, int n2) {
        try {
            if (!MessageTimer.getInstance().isRunning()) {
                MessageTimer.getInstance().RestartTimer();
            }
        }
        catch (IOException iOException) {
            logger.severe(iOException.getMessage());
        }
        InjectorMessage injectorMessage = new InjectorMessage(n, n2);
        MessageSender.getInstance().sendInjectorReq("sensor", 0, 100, "8\n" + injectorMessage.getMessage());
    }

    public boolean Create() {
        this.createPage();
        EventMgr.getInstance().AddLsn("sensor", (ILsn)this);
        return true;
    }

    public BatterySlider createBatterySlider(Composite composite) {
        return this.createBatterySlider(composite, 0);
    }

    public BatterySlider createBatterySlider(Composite composite, int n) {
        BatterySlider batterySlider = new BatterySlider(composite, n);
        GridData gridData = (n & 0x200) == 512 ? new GridData(2, 4, true, true) : new GridData(4, 2, true, false);
        batterySlider.setLayoutData(gridData);
        return batterySlider;
    }

    public void OnTimerMessageExpired() {
        MessageSender.getInstance().sendInjectorReq("sensor", 15, 100);
        MessageSender.getInstance().sendInjectorReq("sensor", 15, 101);
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
        if (generatedMessage instanceof Ecs.InjectorNtf) {
            Ecs.InjectorNtf injectorNtf = (Ecs.InjectorNtf)generatedMessage;
            long l = injectorNtf.getAction();
            if (100L == l) {
                try {
                    int n = Integer.parseInt(injectorNtf.getData().toStringUtf8());
                    this.sliderText.setText(Integer.toString(n) + "%");
                    this.slider.setSelection(n);
                    this.data = n;
                }
                catch (NumberFormatException numberFormatException) {
                    logger.log(Level.SEVERE, "Numberformatexception", numberFormatException);
                }
            } else if (101L == l) {
                String string = injectorNtf.getData().toStringUtf8();
                if (string.equals("1")) {
                    this.radioButton[0].selectRadio();
                    this.chargerOn = true;
                } else {
                    this.radioButton[1].selectRadio();
                    this.chargerOn = false;
                }
            }
        }
    }
}

