/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.nfc;

import com.google.protobuf.GeneratedMessage;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.json.simple.JSONObject;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.msg.genmsg.ecs.EcsIds;
import org.tizen.ecp.nfc.MsgProc_NfcNtf;
import org.tizen.ecp.nfc.NDEFRecordPage;
import org.tizen.ecp.nfc.NFCConstants;
import org.tizen.ecp.nfc.NFCDialog;
import org.tizen.ecp.nfc.NFCErrorString;
import org.tizen.ecp.nfc.NFCEventInjector;
import org.tizen.ecp.nfc.NFCHelpProcess;
import org.tizen.ecp.nfc.TagType;
import org.tizen.ecp.resources.ColorResources;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.IMsgProc;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.sock.MsgMgr;
import org.tizen.ecp.utils.FormUtil;
import org.tizen.ecp.utils.JsonUtil;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.ECPSubView;
import org.tizen.ecp.views.PropertyView;
import org.tizen.ecp.widgets.ECPButton;

public class NFCDisplay
extends ECPSubView {
    private NFCHelpProcess process = null;
    private NDEFRecordPage recordPage = null;
    private Shell shell;
    private static Logger logger = LogUtil.getECPLogger(NFCDisplay.class).getLogger();
    private ArrayList<String> TagTypeList = TagType.getInstance().getList();
    private Combo cmbTagTypeList;
    private ECPButton butTagAttach;
    private ECPButton butTagDetach;
    private ECPButton butP2PDiscover;
    private ECPButton butP2PSend;
    private ECPButton butP2PDetach;
    private final String CMD_QTREE = "info qtree";

    public NFCDisplay() {
        this.title = "NFC";
        this.pageHeight = 530;
        this.useTimer = true;
    }

    public void createView(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginRight = 10;
        composite2.setLayout((Layout)gridLayout);
        this.shell = composite.getShell();
        this.process = new NFCHelpProcess(this.shell);
        this.recordPage = new NDEFRecordPage(this.shell);
        this.recordPage.createNDEFMessageSection(composite2);
        this.createTagSection(composite2);
        this.createP2PSection(composite2);
    }

    private void createTagSection(Composite composite) {
        FormUtil.createLabel((Composite)composite, (String)"NDEF Tag", (Font)NFCConstants.TITLE_FONT, (Color)NFCConstants.TITLE_COLOR);
        Composite composite2 = FormUtil.createComposite((Composite)composite);
        composite2.setBackground(ColorResources.CONTENTS_BORDER.getColor());
        GridData gridData = FormUtil.createHGD((int)474, (int)1, (int)5, (int)0);
        composite2.setLayoutData((Object)gridData);
        Composite composite3 = FormUtil.createComposite((Composite)composite, (int)3);
        Label label = FormUtil.createLabel((Composite)composite3, (String)"Tag Type ");
        GridData gridData2 = new GridData();
        gridData2.widthHint = 60;
        gridData2.horizontalIndent = 10;
        label.setLayoutData((Object)gridData2);
        this.cmbTagTypeList = FormUtil.createCombo((Composite)composite3, (int)12);
        GridData gridData3 = new GridData();
        gridData3.widthHint = 260;
        this.cmbTagTypeList.setLayoutData((Object)gridData3);
        FormUtil.addComboItem((Combo)this.cmbTagTypeList, this.TagTypeList, (Object)this.TagTypeList.get(0));
        GridData gridData4 = new GridData();
        gridData4.widthHint = 100;
        this.butTagAttach = FormUtil.createECPButton((Composite)composite3, (String)"Tag Attach", (int)8);
        this.butTagAttach.setLayoutData((Object)gridData4);
        FormUtil.createLabel((Composite)composite3, (String)"");
        FormUtil.createLabel((Composite)composite3, (String)"");
        this.butTagDetach = FormUtil.createECPButton((Composite)composite3, (String)"Tag Detach", (int)8);
        this.butTagDetach.setLayoutData((Object)gridData4);
        this.butTagDetach.setEnabled(false);
        this.butTagAttach.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NFCDisplay.this.clickTagDiscovered();
            }
        });
        this.butTagDetach.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NFCDisplay.this.clickTagDetached();
            }
        });
    }

    private void createP2PSection(Composite composite) {
        FormUtil.createLabel((Composite)composite, (String)"PEER TO PEER", (Font)NFCConstants.TITLE_FONT, (Color)NFCConstants.TITLE_COLOR);
        Composite composite2 = FormUtil.createComposite((Composite)composite);
        composite2.setBackground(ColorResources.CONTENTS_BORDER.getColor());
        composite2.setBackground(ColorResources.CONTENTS_BORDER.getColor());
        GridData gridData = FormUtil.createHGD((int)474, (int)1, (int)5, (int)0);
        composite2.setLayoutData((Object)gridData);
        Composite composite3 = FormUtil.createComposite((Composite)composite);
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 10;
        composite3.setLayoutData((Object)gridData2);
        Composite composite4 = FormUtil.createComposite((Composite)composite3, (int)3);
        this.butP2PDiscover = FormUtil.createECPButton((Composite)composite4, (String)"P2P Discovered", (int)8);
        this.butP2PDetach = FormUtil.createECPButton((Composite)composite4, (String)"P2P Detached", (int)8);
        this.butP2PSend = FormUtil.createECPButton((Composite)composite4, (String)"P2PSend", (int)8);
        GridData gridData3 = new GridData();
        gridData3.widthHint = 132;
        this.butP2PDiscover.setLayoutData((Object)gridData3);
        this.butP2PDetach.setLayoutData((Object)gridData3);
        this.butP2PSend.setLayoutData((Object)gridData3);
        this.butP2PDiscover.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NFCDisplay.this.clickP2PDiscovered();
            }
        });
        this.butP2PDetach.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NFCDisplay.this.clickP2PDetached();
            }
        });
        this.butP2PSend.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NFCDisplay.this.clickP2PSend();
            }
        });
    }

    private void clickTagDiscovered() {
        if (this.recordPage.getRecordList().size() == 0) {
            NFCDialog.openInfoDialog(this.shell, NFCErrorString.RecordCountIsZero);
            return;
        }
        boolean bl = this.process.sendMessage(100, this.cmbTagTypeList.getSelectionIndex(), this.recordPage.getRecordList());
        if (bl) {
            this.recordPage.setDisableState();
            this.cmbTagTypeList.setEnabled(false);
            this.butTagAttach.setEnabled(false);
            this.butTagDetach.setEnabled(true);
            this.butP2PDiscover.setEnabled(false);
            this.butP2PDetach.setEnabled(false);
            this.butP2PSend.setEnabled(false);
        }
    }

    private void clickTagDetached() {
        boolean bl = this.process.sendMessage(101, this.cmbTagTypeList.getSelectionIndex(), this.recordPage.getRecordList());
        if (bl) {
            this.recordPage.setEnableState();
            this.cmbTagTypeList.setEnabled(true);
            this.butTagAttach.setEnabled(true);
            this.butTagDetach.setEnabled(false);
            this.butP2PDiscover.setEnabled(true);
            this.butP2PDetach.setEnabled(false);
            this.butP2PSend.setEnabled(false);
        }
    }

    private void clickP2PDiscovered() {
        boolean bl = this.process.sendMessage(102, this.cmbTagTypeList.getSelectionIndex(), this.recordPage.getRecordList());
        if (bl) {
            this.cmbTagTypeList.setEnabled(false);
            this.butTagAttach.setEnabled(false);
            this.butTagDetach.setEnabled(false);
            this.butP2PDiscover.setEnabled(false);
            this.butP2PDetach.setEnabled(true);
            this.butP2PSend.setEnabled(true);
        }
    }

    private void clickP2PDetached() {
        boolean bl = this.process.sendMessage(103, this.cmbTagTypeList.getSelectionIndex(), this.recordPage.getRecordList());
        if (bl) {
            this.recordPage.setEnableState();
            this.cmbTagTypeList.setEnabled(true);
            this.butTagAttach.setEnabled(true);
            this.butTagDetach.setEnabled(false);
            this.butP2PDiscover.setEnabled(true);
            this.butP2PDetach.setEnabled(false);
            this.butP2PSend.setEnabled(false);
        }
    }

    private void clickP2PSend() {
        if (this.recordPage.getRecordList().size() == 0) {
            NFCDialog.openInfoDialog(this.shell, NFCErrorString.RecordCountIsZero);
            return;
        }
        boolean bl = this.process.sendMessage(104, this.cmbTagTypeList.getSelectionIndex(), this.recordPage.getRecordList());
        if (bl) {
            this.recordPage.setDisableState();
            this.cmbTagTypeList.setEnabled(false);
            this.butTagAttach.setEnabled(false);
            this.butTagDetach.setEnabled(false);
            this.butP2PDiscover.setEnabled(false);
            this.butP2PDetach.setEnabled(true);
            this.butP2PSend.setEnabled(false);
        } else {
            this.recordPage.setEnableState();
            this.cmbTagTypeList.setEnabled(true);
            this.butTagAttach.setEnabled(true);
            this.butTagDetach.setEnabled(false);
            this.butP2PDiscover.setEnabled(true);
            this.butP2PDetach.setEnabled(false);
            this.butP2PSend.setEnabled(false);
        }
    }

    public void destroyContents(Composite composite) {
        composite.layout(true, true);
    }

    private String createMsg() {
        String string = JsonUtil.encodeMonitorString((String)"execute", (String)"human-monitor-command", (String)"arguments", (JSONObject)JsonUtil.encodeObject((String)"command-line", (String)"info qtree"), (String)"nfc");
        return string;
    }

    protected void initializeWidget() {
        MessageSender.getInstance().sendMonitorReq(this.createMsg());
    }

    public void OnTimerMessageExpired() {
        MessageSender.getInstance().sendDeviceReq("nfc", 15, 0);
    }

    public void setPropertyItems(PropertyView propertyView, Tree tree) {
        propertyView.setTreeItem(tree, new String[]{"value", ""});
    }

    public boolean Create() {
        this.createPage();
        MsgMgr.getInstance().AddMsgProc(EcsIds.Master_Type.NFC_NTF, (IMsgProc)new MsgProc_NfcNtf());
        EventMgr.getInstance().AddLsn("nfc", (ILsn)this);
        return true;
    }

    public void OnEventProc(String string, JSONObject jSONObject) {
        String string2 = (String)jSONObject.get((Object)"return");
        logger.info("message:" + string2);
        if (string2 != null && !string2.contains("virtio-nfc-device") && !string2.contains("virtio-nfc-pci")) {
            this.butTagAttach.setEnabled(false);
            this.butP2PDiscover.setEnabled(false);
        }
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
        if (!(generatedMessage instanceof Ecs.DeviceNtf)) {
            return;
        }
        Ecs.DeviceNtf deviceNtf = (Ecs.DeviceNtf)generatedMessage;
        NFCEventInjector nFCEventInjector = new NFCEventInjector();
        String string = deviceNtf.getData().toStringUtf8();
        logger.info("value:" + string);
        if (string != null) {
            String[] stringArray = string.split(":");
            int n = Integer.valueOf(stringArray[0]);
            switch (n) {
                case 104: {
                    nFCEventInjector.makeNDEFMessage(stringArray[1]);
                    this.recordPage.setRecordList(nFCEventInjector.getAttachedRecordList());
                    this.recordPage.setDisableState();
                    this.cmbTagTypeList.setEnabled(false);
                    this.butTagAttach.setEnabled(false);
                    this.butTagDetach.setEnabled(false);
                    this.butP2PDiscover.setEnabled(false);
                    this.butP2PDetach.setEnabled(true);
                    this.butP2PSend.setEnabled(false);
                    break;
                }
                case 102: {
                    this.cmbTagTypeList.setEnabled(false);
                    this.butTagAttach.setEnabled(false);
                    this.butTagDetach.setEnabled(false);
                    this.butP2PDiscover.setEnabled(false);
                    this.butP2PDetach.setEnabled(true);
                    this.butP2PSend.setEnabled(true);
                    break;
                }
                case 103: {
                    this.recordPage.setEnableState();
                    this.cmbTagTypeList.setEnabled(true);
                    this.butTagAttach.setEnabled(true);
                    this.butTagDetach.setEnabled(false);
                    this.butP2PDiscover.setEnabled(true);
                    this.butP2PDetach.setEnabled(false);
                    this.butP2PSend.setEnabled(false);
                    break;
                }
                case 101: {
                    this.recordPage.setEnableState();
                    this.cmbTagTypeList.setEnabled(true);
                    this.butTagAttach.setEnabled(true);
                    this.butTagDetach.setEnabled(false);
                    this.butP2PDiscover.setEnabled(true);
                    this.butP2PDetach.setEnabled(false);
                    this.butP2PSend.setEnabled(false);
                    break;
                }
                case 100: {
                    nFCEventInjector.makeNDEFMessage(stringArray[1]);
                    String string2 = stringArray[1].split(",")[0];
                    logger.info("tagType: " + string2);
                    if (string2.equals("1")) {
                        this.cmbTagTypeList.select(1);
                    } else if (string2.equals("2")) {
                        this.cmbTagTypeList.select(2);
                    } else if (string2.equals("3")) {
                        this.cmbTagTypeList.select(3);
                    } else if (string2.equals("4")) {
                        this.cmbTagTypeList.select(4);
                    } else {
                        logger.severe("Tag type is wrong: " + string2);
                    }
                    this.recordPage.setRecordList(nFCEventInjector.getAttachedRecordList());
                    this.recordPage.setDisableState();
                    this.cmbTagTypeList.setEnabled(false);
                    this.butTagAttach.setEnabled(false);
                    this.butTagDetach.setEnabled(true);
                    this.butP2PDiscover.setEnabled(false);
                    this.butP2PDetach.setEnabled(false);
                    this.butP2PSend.setEnabled(false);
                    break;
                }
            }
        } else {
            logger.severe("Received data is null!");
        }
    }
}

