/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sensor;

import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.spi.SubCommand;
import org.kohsuke.args4j.spi.SubCommands;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.commands.ESubCommandHandler;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.sensor.SensorFileCLI;
import org.tizen.ecp.sensor.SensorStatusCLI;
import org.tizen.ecp.sensor.accelerometer.SensorAccelCLI;
import org.tizen.ecp.sensor.geo.SensorMagneticCLI;
import org.tizen.ecp.sensor.gyro.SensorGyroCLI;
import org.tizen.ecp.sensor.hrm.SensorHRMCLI;
import org.tizen.ecp.sensor.light.SensorLightCLI;
import org.tizen.ecp.sensor.pressure.SensorPressureCLI;
import org.tizen.ecp.sensor.proximity.SensorProxiCLI;
import org.tizen.ecp.sensor.uv.SensorUVCLI;

public class SensorCLI
extends AbstractEmulatorCLI {
    @Argument(index=0, required=true, handler=ESubCommandHandler.class, usage="Sensor Device")
    @SubCommands(value={@SubCommand(name="accelerometer", impl=SensorAccelCLI.class), @SubCommand(name="gyroscope", impl=SensorGyroCLI.class), @SubCommand(name="magnetic", impl=SensorMagneticCLI.class), @SubCommand(name="proximity", impl=SensorProxiCLI.class), @SubCommand(name="light", impl=SensorLightCLI.class), @SubCommand(name="pressure", impl=SensorPressureCLI.class), @SubCommand(name="uv", impl=SensorUVCLI.class), @SubCommand(name="hrm", impl=SensorHRMCLI.class), @SubCommand(name="file", impl=SensorFileCLI.class), @SubCommand(name="status", impl=SensorStatusCLI.class)})
    private AbstractEmulatorCLI tizenCLI;
    private String help = OutputUtil.getDeviceUsage((String)"sensor") + "Supported commands are :\n" + OutputUtil.getFormatList((String)"accelerometor <x> <y> <z>") + OutputUtil.getFormatList((String)"magnetic <x> <y> <z>") + OutputUtil.getFormatList((String)"gyroscope <x> <y> <z>") + OutputUtil.getFormatList((String)"light <level>") + OutputUtil.getFormatList((String)"proximity <state>") + OutputUtil.getFormatList((String)"pressure <level>") + OutputUtil.getFormatList((String)"uv <level>") + OutputUtil.getFormatList((String)"hrm <level>") + OutputUtil.getFormatList((String)"status [sensor]") + OutputUtil.getFormatList((String)"file <sensor> <path>") + "Command arguments :\n" + OutputUtil.getFormatList((String)"accelerometor <x> <y> <z> : set accelerometer value. Unit is '[g]' and range [-2,2]") + OutputUtil.getFormatList((String)"magnetic <x> <y> <z> set magnetic value. Unit is '[\u00b5T]' and range [-2000,2000]") + OutputUtil.getFormatList((String)"gyroscope <x> <y> <z> set gyroscope value. Unit is '[radians/sec]' and range [-10,10]") + OutputUtil.getFormatList((String)"light <level> set light value. Unit is 'Lux', and range [0,65535]") + OutputUtil.getFormatList((String)"proximity <state> is 'on' or 'off'") + OutputUtil.getFormatList((String)"pedometer 'state' is a movement state. It can be 'stop', 'walk_slow', 'walk', 'run_slow', 'run'") + OutputUtil.getFormatList((String)"pressure <level> sets pressure value. Unit is 'hPa', and range [260,1260]") + OutputUtil.getFormatList((String)"uv <level> sets ultraviolet index. range [0.0,15.0]") + OutputUtil.getFormatList((String)"hrm <heart|rri> <level> sets heart rate or peek-to-peek value.\n\t\tUnit is 'x' and 'ms', and range is [0.0,220.0] and [0,5000] respectively") + OutputUtil.getFormatList((String)"status [sensor] shows current all or [given] sensor values.");

    public int execute() {
        this.tizenCLI.help = this.help;
        return this.tizenCLI.executeCLI();
    }

    public void printHelp() {
        OutputUtil.println((String)this.help);
    }
}

