/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sensor.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Line2D;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.eclipse.swt.widgets.Display;
import org.tizen.ecp.dialogs.MessageDialog;
import org.tizen.ecp.sensor.gui.GUIDisplay;
import org.tizen.ecp.sensor.gui.Magnetic;
import org.tizen.ecp.sensor.gui.Vector;
import org.tizen.ecp.sock.IConnection;
import org.tizen.ecp.sock.SocketClient;

public class MobilePanel
extends JPanel
implements IConnection {
    GUIDisplay mPage;
    double read_accelx;
    double read_accely;
    double read_accelz;
    double read_yaw;
    double read_pitch;
    double read_roll;
    long accel_update_duration;
    long accel_next_update;
    long orientation_update_duration;
    long orientation_next_update;
    long user_settings_duration;
    long user_settings_next_update;
    double partial_accelx;
    double partial_accely;
    double partial_accelz;
    int partial_accel_n;
    boolean average_accel;
    double partial_yaw;
    double partial_pitch;
    double partial_roll;
    int partial_orientation_n;
    boolean average_orientation;
    double accelx;
    double accely;
    double accelz;
    double yaw;
    double pitch;
    double roll;
    double yawDegree;
    double pitchDegree;
    double rollDegree;
    int movex;
    int movez;
    double vx;
    double vz;
    double ax;
    double az;
    double Fx;
    double Fz;
    double accx;
    double accz;
    double k;
    double m;
    double gamma;
    double dt;
    double meterperpixel;
    double g;
    double ginverse;
    int mousedownx;
    int mousedowny;
    int mousedownyaw;
    int mousedownpitch;
    int mousedownroll;
    int mousedownmovex;
    int mousedownmovez;
    boolean gyroStart;
    Vector old_vector_yz;
    Vector old_vector_xz;
    double old_gyroYaw;
    double old_gyroPitch;
    double old_gyroRoll;
    int gyroYawCount;
    int gyroPitchCount;
    int gyroRollCount;
    private double old_gyro_rollDegree = 0.0;
    private double old_gyro_pitchDegree = 0.0;
    private double old_gyro_yawDegree = 0.0;
    private double[] gyro_axisX;
    private double[] gyro_axisY;
    private double[] gyro_axisZ;
    double gyroYaw;
    double gyroPitch;
    double gyroRoll;
    public boolean phone_pos_conv = false;
    public boolean is_Axis = false;
    private double north;
    private double east;
    private double vertical;
    static final double sx = 21.0;
    static final double sy = 56.0;
    static final double sz = 7.0;
    static final double dx = 16.799999999999997;
    static final double dy1 = 46.199999999999996;
    static final double dy2 = -21.0;
    static final double xAxisLen = -35.0;
    static final double yAxisLen = -75.0;
    static final double zAxisLen = -25.0;
    double[][] phone = new double[][]{{21.0, 56.0, -7.0}, {-21.0, 56.0, -7.0}, {-21.0, 56.0, -7.0}, {-21.0, -56.0, -7.0}, {-21.0, -56.0, -7.0}, {21.0, -56.0, -7.0}, {21.0, -56.0, -7.0}, {21.0, 56.0, -7.0}, {21.0, 56.0, 7.0}, {-21.0, 56.0, 7.0}, {-21.0, 56.0, 7.0}, {-21.0, -56.0, 7.0}, {-21.0, -56.0, 7.0}, {21.0, -56.0, 7.0}, {21.0, -56.0, 7.0}, {21.0, 56.0, 7.0}, {21.0, 56.0, -7.0}, {21.0, 56.0, 7.0}, {-21.0, 56.0, -7.0}, {-21.0, 56.0, 7.0}, {-21.0, -56.0, -7.0}, {-21.0, -56.0, 7.0}, {21.0, -56.0, -7.0}, {21.0, -56.0, 7.0}, {16.799999999999997, 46.199999999999996, 7.0}, {-16.799999999999997, 46.199999999999996, 7.0}, {-16.799999999999997, 46.199999999999996, 7.0}, {-16.799999999999997, -21.0, 7.0}, {-16.799999999999997, -21.0, 7.0}, {16.799999999999997, -21.0, 7.0}, {16.799999999999997, -21.0, 7.0}, {16.799999999999997, 46.199999999999996, 7.0}, {-35.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, -75.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, -25.0}, {0.0, 0.0, 0.0}};
    private Timer timer;
    private Timer geomagneticTimer;
    private Timer gyroTimer;
    private boolean connected = false;

    public void init_values() {
        double[] dArray = new double[]{1.0, 0.0, 0.0};
        double[] dArray2 = new double[]{0.0, 0.0, 1.0};
        double[] dArray3 = new double[]{0.0, -1.0, 0.0};
        this.setGyroAxisX(dArray);
        this.setGyroAxisY(dArray2);
        this.setGyroAxisZ(dArray3);
        this.repaint();
        this.rollDegree = 0.0;
        this.pitchDegree = 0.0;
        this.yawDegree = 0.0;
        this.old_gyro_rollDegree = 0.0;
        this.old_gyro_pitchDegree = 0.0;
        this.old_gyro_yawDegree = 0.0;
        Magnetic magnetic = Magnetic.getInstance();
        magnetic.setAzimuth(0);
        magnetic.setPitch(-90);
        magnetic.setRoll(0);
        this.partial_accelx = 0.0;
        this.partial_accely = 0.0;
        this.partial_accelz = 0.0;
        this.partial_accel_n = 0;
        this.partial_yaw = 0.0;
        this.partial_pitch = 0.0;
        this.partial_roll = 0.0;
        this.partial_orientation_n = 0;
    }

    public MobilePanel(GUIDisplay gUIDisplay) {
        SocketClient.getInstance().registerDisconnectListener((IConnection)this);
        this.mPage = gUIDisplay;
        this.yawDegree = 0.0;
        this.pitchDegree = 0.0;
        this.rollDegree = 0.0;
        this.gyroYawCount = 0;
        this.gyroPitchCount = 0;
        this.gyroRollCount = 0;
        this.gyroStart = false;
        this.gyro_axisX = (double[])Vector.getAxisX().clone();
        this.gyro_axisY = (double[])Vector.getAxisY().clone();
        this.gyro_axisZ = (double[])Vector.getAxisZ().clone();
        this.north = 22874.1;
        this.east = 5939.5;
        this.vertical = 43180.5;
        this.movex = 0;
        this.movez = 0;
        this.Fx = 0.0;
        this.Fz = 0.0;
        this.accx = 0.0;
        this.accz = 0.0;
        this.k = 500.0;
        this.m = 1.0;
        this.gamma = 50.0;
        this.dt = 0.1;
        this.meterperpixel = 3.333333333333333E-4;
        this.g = -9.80665;
        this.ginverse = 1.0 / this.g;
        this.user_settings_duration = 500L;
        this.user_settings_next_update = System.currentTimeMillis();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                MobilePanel.this.mousedownx = mouseEvent.getX();
                MobilePanel.this.mousedowny = mouseEvent.getY();
                MobilePanel.this.mousedownyaw = MobilePanel.this.mPage.getYawSliderValue();
                MobilePanel.this.mousedownpitch = MobilePanel.this.mPage.getPitchSliderValue();
                MobilePanel.this.mousedownroll = MobilePanel.this.mPage.getRollSliderValue();
                MobilePanel.this.mousedownmovex = MobilePanel.this.movex;
                MobilePanel.this.mousedownmovez = MobilePanel.this.movez;
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                MobilePanel.this.phone_pos_conv = true;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!SocketClient.getInstance().getGuestStatus()) {
                            MessageDialog messageDialog = new MessageDialog();
                            messageDialog.openInfoDialog("Emulator is not ready. Please retry when the emulator is ready.");
                        }
                    }
                });
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (MobilePanel.this.mPage.getMode() == GUIDisplay.Mode.YAW_PITCH) {
                    int n = MobilePanel.this.mousedownyaw - (mouseEvent.getX() - MobilePanel.this.mousedownx);
                    while (n > 180) {
                        n -= 360;
                        ++MobilePanel.this.gyroYawCount;
                    }
                    while (n < -180) {
                        n += 360;
                        --MobilePanel.this.gyroYawCount;
                    }
                    MobilePanel.this.mPage.setYawSliderValue(n);
                    MobilePanel.this.yawDegree = n;
                    int n2 = MobilePanel.this.mousedownpitch - (mouseEvent.getY() - MobilePanel.this.mousedowny);
                    while (n2 > 270) {
                        n2 -= 360;
                        ++MobilePanel.this.gyroPitchCount;
                    }
                    while (n2 < -90) {
                        n2 += 360;
                        --MobilePanel.this.gyroPitchCount;
                    }
                    MobilePanel.this.mPage.setPitchSliderValue(n2);
                    MobilePanel.this.pitchDegree = n2;
                } else if (MobilePanel.this.mPage.getMode() == GUIDisplay.Mode.ROLL_PITCH) {
                    int n = MobilePanel.this.mousedownroll + (mouseEvent.getX() - MobilePanel.this.mousedownx);
                    while (n > 180) {
                        n -= 360;
                        ++MobilePanel.this.gyroRollCount;
                    }
                    while (n < -180) {
                        n += 360;
                        --MobilePanel.this.gyroRollCount;
                    }
                    MobilePanel.this.mPage.setRollSliderValue(n);
                    MobilePanel.this.rollDegree = n;
                    int n3 = MobilePanel.this.mousedownpitch - (mouseEvent.getY() - MobilePanel.this.mousedowny);
                    while (n3 > 270) {
                        n3 -= 360;
                        ++MobilePanel.this.gyroPitchCount;
                    }
                    while (n3 < -90) {
                        n3 += 360;
                        --MobilePanel.this.gyroPitchCount;
                    }
                    MobilePanel.this.mPage.setPitchSliderValue(n3);
                    MobilePanel.this.pitchDegree = n3;
                } else if (MobilePanel.this.mPage.getMode() == GUIDisplay.Mode.MOVE) {
                    int n;
                    int n4;
                    MobilePanel.this.movex = n4 = MobilePanel.this.mousedownmovex + (mouseEvent.getX() - MobilePanel.this.mousedownx);
                    MobilePanel.this.movez = n = MobilePanel.this.mousedownmovez - (mouseEvent.getY() - MobilePanel.this.mousedowny);
                }
                MobilePanel.this.repaint();
            }
        });
        int n = 200;
        this.timer = new Timer(n, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MobilePanel.this.updateSensorPhysics();
                MobilePanel.this.updateSensorReadoutValues();
                MobilePanel.this.updateUserSettings();
                if (SocketClient.getInstance().getGuestStatus()) {
                    MobilePanel.this.mPage.sendMessage("1\n", MobilePanel.this.read_accelx, MobilePanel.this.read_accely, MobilePanel.this.read_accelz);
                }
            }
        });
        this.geomagneticTimer = new Timer(n, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Magnetic magnetic = Magnetic.getInstance();
                magnetic.setMagneticFiled(MobilePanel.this.north, MobilePanel.this.east, MobilePanel.this.vertical);
                magnetic.updateSensorPhysics(MobilePanel.this.rollDegree, MobilePanel.this.pitchDegree, MobilePanel.this.yawDegree);
                magnetic.updateSensorReadoutValues();
                magnetic.updateUserSettings();
                magnetic.setTilt(MobilePanel.this.read_accelx, MobilePanel.this.read_accely, MobilePanel.this.read_accelz);
                if (SocketClient.getInstance().getGuestStatus()) {
                    MobilePanel.this.mPage.sendMessage("5\n", magnetic.getAzimuth(), magnetic.getPitch(), magnetic.getRoll(), 3.0, magnetic.getReadCompassX(), magnetic.getReadCompassY(), magnetic.getReadCompassZ());
                }
            }
        });
        this.gyroTimer = new Timer(n, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                double d = MobilePanel.this.gyroPitch / 200.0;
                double d2 = MobilePanel.this.gyroRoll / 200.0;
                double d3 = MobilePanel.this.gyroYaw / 200.0;
                MobilePanel.this.updateSensorGyro();
                if (SocketClient.getInstance().getGuestStatus()) {
                    MobilePanel.this.mPage.sendMessage("4\n", d, d2, d3);
                }
            }
        });
        this.timer.setCoalesce(true);
        this.geomagneticTimer.setCoalesce(true);
        this.gyroTimer.setCoalesce(true);
    }

    private void updateSensorGyro() {
        if (!this.gyroStart) {
            this.old_gyroYaw = this.yawDegree;
            this.old_gyroPitch = this.pitchDegree;
            this.old_gyroRoll = this.rollDegree;
            this.gyroStart = true;
            return;
        }
        this.gyroRoll = (double)(this.gyroRollCount * 360) + this.rollDegree - this.old_gyroRoll;
        this.gyroPitch = (double)(this.gyroPitchCount * 360) + this.pitchDegree - this.old_gyroPitch;
        this.gyroYaw = (double)(this.gyroYawCount * 360) + this.yawDegree - this.old_gyroYaw;
        this.gyroYawCount = 0;
        this.gyroPitchCount = 0;
        this.gyroRollCount = 0;
        this.old_gyroRoll = this.rollDegree;
        this.old_gyroPitch = this.pitchDegree;
        this.old_gyroYaw = this.yawDegree;
        if (this.gyroRoll > 573.0) {
            this.gyroRoll = 573.0;
        } else if (this.gyroRoll < -573.0) {
            this.gyroRoll = -573.0;
        }
        if (this.gyroPitch > 573.0) {
            this.gyroPitch = 573.0;
        } else if (this.gyroPitch < -573.0) {
            this.gyroPitch = -573.0;
        }
        if (this.gyroYaw > 573.0) {
            this.gyroYaw = 573.0;
        } else if (this.gyroYaw < -573.0) {
            this.gyroYaw = -573.0;
        }
    }

    public void updateSensorPhysics() {
        this.dt = 0.01;
        this.g = -9.80665;
        if (this.g != 0.0) {
            this.ginverse = 1.0 / this.g;
        }
        this.k = 500.0;
        this.gamma = 50.0;
        this.Fx = this.k * ((double)this.movex - this.accx);
        this.Fz = this.k * ((double)this.movez - this.accz);
        this.ax = this.Fx / this.m;
        this.az = this.Fz / this.m;
        this.vx += this.ax * this.dt;
        this.vz += this.az * this.dt;
        this.accx += this.vx * this.dt;
        this.accz += this.vz * this.dt;
        this.accx += this.gamma * ((double)this.movex - this.accx) * this.dt;
        this.accz += this.gamma * ((double)this.movez - this.accz) * this.dt;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = -9.80665;
        Vector vector = new Vector(-this.ax * this.meterperpixel + d, d2, -this.az * this.meterperpixel + d3);
        vector.reverserollpitchyaw();
        this.accelx = vector.x;
        this.accely = vector.y;
        this.accelz = vector.z;
        double d4 = this.g * 10.0;
        if (d4 > 0.0) {
            if (this.accelx > d4) {
                this.accelx = d4;
            }
            if (this.accelx < -d4) {
                this.accelx = -d4;
            }
            if (this.accely > d4) {
                this.accely = d4;
            }
            if (this.accely < -d4) {
                this.accely = -d4;
            }
            if (this.accelz > d4) {
                this.accelz = d4;
            }
            if (this.accelz < -d4) {
                this.accelz = -d4;
            }
        }
        this.yaw = this.yawDegree;
        this.pitch = this.pitchDegree;
        this.roll = this.rollDegree;
        this.repaint();
    }

    public void updateSensorReadoutValues() {
        long l = System.currentTimeMillis();
        if (this.average_accel) {
            this.partial_accelx += this.accelx;
            this.partial_accely += this.accely;
            this.partial_accelz += this.accelz;
            ++this.partial_accel_n;
        }
        if (this.average_orientation) {
            this.partial_yaw += this.yaw;
            this.partial_pitch += this.pitch;
            this.partial_roll += this.roll;
            ++this.partial_orientation_n;
        }
        if (l >= this.accel_next_update) {
            this.accel_next_update += this.accel_update_duration;
            if (this.accel_next_update < l) {
                this.accel_next_update = l;
            }
            if (this.average_accel) {
                this.read_accelx = this.partial_accelx / (double)this.partial_accel_n;
                this.read_accely = this.partial_accely / (double)this.partial_accel_n;
                this.read_accelz = this.partial_accelz / (double)this.partial_accel_n;
                this.partial_accelx = 0.0;
                this.partial_accely = 0.0;
                this.partial_accelz = 0.0;
                this.partial_accel_n = 0;
            } else {
                this.read_accelx = this.accelx;
                this.read_accely = this.accely;
                this.read_accelz = this.accelz;
            }
            if (this.read_accelx / this.g > 2.0) {
                this.read_accelx = 2.0 * this.g;
            } else if (this.read_accelx / this.g < -2.0) {
                this.read_accelx = -2.0 * this.g;
            }
            if (this.read_accely / this.g > 2.0) {
                this.read_accely = 2.0 * this.g;
            } else if (this.read_accely / this.g < -2.0) {
                this.read_accely = -2.0 * this.g;
            }
            if (this.read_accelz / this.g > 2.0) {
                this.read_accelz = 2.0 * this.g;
            } else if (this.read_accelz / this.g < -2.0) {
                this.read_accelz = -2.0 * this.g;
            }
        }
        if (l >= this.orientation_next_update) {
            this.orientation_next_update += this.orientation_update_duration;
            if (this.orientation_next_update < l) {
                this.orientation_next_update = l;
            }
            if (this.average_orientation) {
                this.read_yaw = this.partial_yaw / (double)this.partial_orientation_n;
                this.read_pitch = this.partial_pitch / (double)this.partial_orientation_n;
                this.read_roll = this.partial_roll / (double)this.partial_orientation_n;
                this.partial_yaw = 0.0;
                this.partial_pitch = 0.0;
                this.partial_roll = 0.0;
                this.partial_orientation_n = 0;
            } else {
                this.read_yaw = this.yaw;
                this.read_pitch = this.pitch;
                this.read_roll = this.roll;
            }
            if (this.read_pitch < -90.0) {
                this.read_pitch = -180.0 - this.read_pitch;
                this.read_yaw += 180.0;
                this.read_roll += 180.0;
            } else if (this.read_pitch > 90.0) {
                this.read_pitch = 180.0 - this.read_pitch;
                this.read_yaw += 180.0;
                this.read_roll += 180.0;
            }
            if (this.read_yaw < 0.0) {
                this.read_yaw += 360.0;
            }
            if (this.read_yaw >= 360.0) {
                this.read_yaw -= 360.0;
            }
            if (this.read_roll >= 180.0) {
                this.read_roll -= 360.0;
            }
        }
    }

    public void updateUserSettings() {
        long l = System.currentTimeMillis();
        if (l >= this.user_settings_next_update) {
            this.user_settings_next_update += this.user_settings_duration;
            if (this.user_settings_next_update < l) {
                this.user_settings_next_update = System.currentTimeMillis();
            }
            this.average_accel = true;
            double d = 50.0;
            this.accel_update_duration = d != 0.0 ? (long)(1000.0 / d) : 0L;
            this.average_orientation = true;
            d = 50.0;
            this.orientation_update_duration = d != 0.0 ? (long)(1000.0 / d) : 0L;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(250, 200);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d = 100.0;
        double d2 = 100.0;
        double d3 = -150.0;
        double d4 = this.old_gyro_rollDegree - this.rollDegree;
        double d5 = this.old_gyro_pitchDegree - this.pitchDegree;
        double d6 = this.old_gyro_yawDegree - this.yawDegree;
        int n = this.phone.length;
        if (!this.is_Axis) {
            n = 32;
        }
        for (int i = 0; i < n; i += 2) {
            if (i == 0) {
                graphics2D.setColor(Color.RED);
            }
            if (i == 24) {
                graphics2D.setColor(Color.BLUE);
            }
            if (i == 32) {
                graphics2D.setColor(Color.BLACK);
            }
            Vector vector = new Vector(this.phone[i]);
            Vector vector2 = new Vector(this.phone[i + 1]);
            if (i == 0) {
                vector.setAxisX(this.gyro_axisX);
                vector.setAxisY(this.gyro_axisY);
                vector.setAxisZ(this.gyro_axisZ);
                vector.rollpitchyaw(d4, d5, d6);
            }
            vector.setPosition();
            vector2.setPosition();
            if (this.phone_pos_conv && i == n - 2) {
                this.phone_pos_conv = false;
                this.gyro_axisX = (double[])Vector.getAxisX().clone();
                this.gyro_axisY = (double[])Vector.getAxisY().clone();
                this.gyro_axisZ = (double[])Vector.getAxisZ().clone();
                this.old_gyro_rollDegree = this.rollDegree;
                this.old_gyro_pitchDegree = this.pitchDegree;
                this.old_gyro_yawDegree = this.yawDegree;
            }
            graphics2D.draw(new Line2D.Double(d + (vector.x + (double)this.movex) * d3 / (d3 - vector.y), d2 - (vector.z + (double)this.movez) * d3 / (d3 - vector.y), d + (vector2.x + (double)this.movex) * d3 / (d3 - vector2.y), d2 - (vector2.z + (double)this.movez) * d3 / (d3 - vector2.y)));
            if (i == 32) {
                graphics2D.drawString(" x+", (float)(d + (vector.x + (double)this.movex) * d3 / (d3 - vector.y)), (float)(d2 - (vector.z + (double)this.movez) * d3 / (d3 - vector.y)));
            }
            if (i == 34) {
                graphics2D.drawString(" y+", (float)(d + (vector.x + (double)this.movex) * d3 / (d3 - vector.y)), (float)(d2 - (vector.z + (double)this.movez) * d3 / (d3 - vector.y)));
            }
            if (i != 36) continue;
            graphics2D.drawString(" z+", (float)(d + (vector.x + (double)this.movex) * d3 / (d3 - vector.y)), (float)(d2 - (vector.z + (double)this.movez) * d3 / (d3 - vector.y)));
        }
    }

    public void accelerometerTimer(boolean bl) {
        if (this.timer != null) {
            if (bl && this.connected) {
                this.timer.start();
            }
            if (!bl) {
                this.timer.stop();
            }
        }
    }

    public void geomagneticTimer(boolean bl) {
        if (this.geomagneticTimer != null) {
            if (bl && this.connected) {
                this.geomagneticTimer.start();
            }
            if (!bl) {
                this.geomagneticTimer.stop();
            }
        }
    }

    public void gyroTimer(boolean bl) {
        if (this.gyroTimer != null) {
            if (bl && this.connected) {
                this.gyroTimer.start();
            }
            if (!bl) {
                this.gyroTimer.stop();
            }
        }
    }

    public void setGyroAxisX(double[] dArray) {
        this.gyro_axisX = (double[])dArray.clone();
    }

    public void setGyroAxisY(double[] dArray) {
        this.gyro_axisY = (double[])dArray.clone();
    }

    public void setGyroAxisZ(double[] dArray) {
        this.gyro_axisZ = (double[])dArray.clone();
    }

    public void setOldGyroRollDegree(double d) {
        this.old_gyro_rollDegree = d;
    }

    public void setOldGyroPitchDegree(double d) {
        this.old_gyro_pitchDegree = d;
    }

    public void setOldGyroYawDegree(double d) {
        this.old_gyro_yawDegree = d;
    }

    public void connect() {
        this.connected = true;
        this.accelerometerTimer(true);
        this.geomagneticTimer(true);
        this.gyroTimer(true);
        if (this.mPage.dataOutputTimer != null) {
            this.mPage.dataOutputTimer.start();
        }
    }

    public void disconnect() {
        this.connected = false;
        this.accelerometerTimer(false);
        this.geomagneticTimer(false);
        this.gyroTimer(false);
        if (this.mPage.dataOutputTimer != null) {
            this.mPage.dataOutputTimer.stop();
        }
    }

    public void run() {
        this.connect();
        this.init_values();
    }

    public void disconnected() {
    }

    public void guestOn() {
        this.accelerometerTimer(true);
        this.geomagneticTimer(true);
        this.gyroTimer(true);
    }

    public void guestOff() {
        this.accelerometerTimer(false);
        this.geomagneticTimer(false);
        this.gyroTimer(false);
    }

    public void guestOffMessage() {
    }
}

