/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sensor.hrm;

import com.google.protobuf.GeneratedMessage;
import org.kohsuke.args4j.Argument;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.legacy.InjectorMessage;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.MessageSender;

public class SensorHRMCLI
extends AbstractEmulatorCLI {
    private String TYPE_SENSOR;
    @Argument(required=true, index=0, metaVar="heart rri")
    String sensor;
    @Argument(required=true, index=1)
    int level;

    public SensorHRMCLI() {
        this.messageType = this.TYPE_SENSOR = "sensor";
    }

    public int execute() {
        int n = 0;
        int n2 = 0;
        if (this.sensor.equals("heart")) {
            if (this.level < 0 || this.level > 220) {
                OutputUtil.println((String)"\tlevel is out of range from 0.0 to 220.0");
                return 25;
            }
            n = 1;
            n2 = this.level * 10;
        } else if (this.sensor.equals("rri")) {
            if (this.level < 0 || this.level > 5000) {
                OutputUtil.println((String)"\tlevel is out of range from 0 to 5000");
                return 25;
            }
            n = 2;
            n2 = this.level;
        } else {
            OutputUtil.printError((String)"Invalid sensor type");
            this.printHelp();
            return 25;
        }
        InjectorMessage injectorMessage = new InjectorMessage(n, n2);
        MessageSender.getInstance().sendDeviceReq("sensor", 0, 0, "22\n" + injectorMessage.getMessage());
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            OutputUtil.printError((String)"Interrupted.", (Exception)interruptedException);
        }
        MessageSender.getInstance().sendDeviceReq("sensor", 15, 118);
        this.startRunning();
        if (this.returnValue == 128) {
            OutputUtil.printFail();
        } else {
            OutputUtil.printOK();
        }
        return 0;
    }

    public void OnEventProcPB(String string, GeneratedMessage generatedMessage) {
        if (generatedMessage instanceof Ecs.DeviceAns) {
            Ecs.DeviceAns deviceAns = (Ecs.DeviceAns)generatedMessage;
            int n = deviceAns.getErrcode();
            if (n != 0) {
                this.returnValue = 128;
            }
            this.stopRunning();
        }
    }
}

