/*
 * context-manager
 *
 * Copyright (c) 2014 Samsung Electronics Co., Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#ifndef __CONTEXT_ACTIVITY_TYPES_H__
#define __CONTEXT_ACTIVITY_TYPES_H__

#define PREFIX_ACTIVITY			"activ"

#define ID_ACTIVITY_INSTANT		PREFIX_ACTIVITY".inst"
#define ID_ACTIVITY_BATCH		PREFIX_ACTIVITY".batch"
#define ID_ACTIVITY_NOTI		PREFIX_ACTIVITY".noti"

// Option Fields
#define ACTIVITY_FILTER			"ActFil"

// Data Fields
#define ACTIVITY_DATA_SIZE		"BatchSize"
#define ACTIVITY_DATA_ACTIVITY	"Status"
#define ACTIVITY_DATA_ACCURACY	"Accuracy"

// Activity Types
// TODO: Switch the numeric acitivty IDs to strings
#define ACTIVITY_TYPE_UNKNOWN		0
#define ACTIVITY_TYPE_STATIONARY	1
#define ACTIVITY_TYPE_WALK			2
#define ACTIVITY_TYPE_RUN			3
#define ACTIVITY_TYPE_VEHICLE		4
#define NUM_ACTIVITY_TYPE			5


/* PRODUCT SCOPE: Deprecated */
#define ID_ACTIVITY_NOTI_EX		PREFIX_ACTIVITY".noti_ex"
#define ACTIVITY_DURATION		"ActDur"

#endif	/* __CONTEXT_ACTIVITY_TYPES_H__ */
