/*
 * context-manager
 *
 * Copyright (c) 2014 Samsung Electronics Co., Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#ifndef __CONTEXT_UTIL_DBUS_H__
#define __CONTEXT_UTIL_DBUS_H__

#include <dbus/dbus-glib-lowlevel.h>

namespace ctx { namespace dbus {

	DBusConnection* open(const char* name, DBusHandleMessageFunction cb, void* user_data);
	void close(DBusConnection** conn, const char* name);
	bool add_match(DBusConnection* conn, const char* match);
	bool remove_match(DBusConnection* conn, const char* match);

} }	 /* namespace ctx::dbus */


#endif /* __CONTEXT_UTIL_DBUS_H__ */
