/*
 * context-manager
 *
 * Copyright (c) 2014 Samsung Electronics Co., Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#ifndef __CONTEXT_MOTION_TYPES_H__
#define __CONTEXT_MOTION_TYPES_H__

#define PREFIX_MOTION				"motion"

// Motion
#define ID_MOTION_APPROACH			PREFIX_MOTION".approach"
#define ID_MOTION_WRIST_UP			PREFIX_MOTION".wristup"

// Data Fields
#define MOTION_DATA_ATTR			"Action"

// Option Fields
#define MOTION_SENSING_MODE			"SenMode"


/* PRODUCT SCOPE */
/* TODO: Split this into a separate header file */
#define ID_MOTION_MOVEMENT_STATUS	PREFIX_MOTION".move_stat"	/* Movement Alert */
#define ID_MOTION_PICK_UP_ON_SLEEP	PREFIX_MOTION".pickup_ex"	/* Movement */
#define ID_MOTION_SHAKE_CUSTOM		PREFIX_MOTION".shake_custom"
#define ID_MOTION_SHAKE_EX			ID_MOTION_SHAKE_CUSTOM
#define ID_MOTION_WATCH_GESTURE		PREFIX_MOTION".watch_gesture"

// Data Fields
#define MOTION_DATA_MOTION_LENGTH	"Length"
#define MOTION_DATA_MOTION_ACCEL	"Accel"

// Option Fields
#define MOTION_WEARING_POSITION		"WearPos"
#define MOTION_WATCH_GESTURE_TYPE	"WatchGsType"

#endif /* __CONTEXT_MOTION_TYPES_H__ */
