/*
 * libcore-context-manager
 *
 * Copyright (c) 2014 Samsung Electronics Co., Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#ifndef __CONTEXT_UTIL_MISC_H__
#define __CONTEXT_UTIL_MISC_H__

#include <sys/types.h>
#include <ctx_util_json.h>

namespace ctx {

	int generate_rid(void);
	int get_timestamp_array_from_json(json_t *jobj, double **ts, int size = -1);
	int is_supported(const char* feature);

	namespace time {

		int64_t get_utc(int64_t* ymd, int64_t* hms);
		void get_utc_detailed(int* day, int* hour, int* min, float* sec);
		void get_hms_utc(int* hour, int* min, int* sec);

	}	/* namespace ctx::util */

}	/* namespace ctx */

#endif /* __CONTEXT_UTIL_MISC_H__ */
