/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.EventCast;

import com.google.protobuf.GeneratedMessage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kohsuke.args4j.Argument;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.EventCast.MsgProc_EventCastNtf;
import org.tizen.ecp.msg.genmsg.ecs.EcsIds;
import org.tizen.ecp.sock.IMsgProc;
import org.tizen.ecp.sock.MsgMgr;

public class EventCastConnectCLI
extends AbstractEmulatorCLI {
    @Argument(required=true, index=0, metaVar="usb wifi")
    String type = "";
    @Argument(required=true, index=1)
    int port = 0;
    @Argument(required=false, index=2)
    String ip = "";
    private String TYPE_EVENTCAST = "eventcast";
    private String serverAddr = "";
    private Pattern pattern;
    private Matcher matcher;
    private MsgProc_EventCastNtf ntf = null;
    private static final String IPADDRESS_PATTERN = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";

    public EventCastConnectCLI() {
        this.messageType = this.TYPE_EVENTCAST;
        this.pattern = Pattern.compile(IPADDRESS_PATTERN);
        this.ntf = new MsgProc_EventCastNtf();
        MsgMgr.getInstance().AddMsgProc(EcsIds.Master_Type.EVENTCAST_NTF, (IMsgProc)this.ntf);
    }

    public boolean ipValidate(String string) {
        this.matcher = this.pattern.matcher(string);
        return this.matcher.matches();
    }

    private boolean checkArgs(String string, int n, String string2) {
        int n2 = 0;
        int n3 = 65535;
        if (n < n2 || n > n3) {
            OutputUtil.printError((String)("invalid port number: " + n));
            return false;
        }
        if (!string2.isEmpty()) {
            if (!this.ipValidate(string2)) {
                OutputUtil.printError((String)("invalid ip address: " + string2));
                return false;
            }
        } else if (string.equals("usb")) {
            OutputUtil.println((String)"use localhost as ip address");
        } else {
            OutputUtil.printError((String)("invalid connection type: " + string));
            return false;
        }
        return true;
    }

    public int execute() {
        if (!this.checkArgs(this.type, this.port, this.ip)) {
            return 25;
        }
        this.serverAddr = String.format("%s:%d", this.ip, this.port);
        this.ntf.sendEventCastReq("eventcast", 1, 1, this.serverAddr);
        this.startRunning();
        return 0;
    }

    public void OnEventProcPB(String string, GeneratedMessage generatedMessage) {
        OutputUtil.printOK();
        this.clear();
        this.stopRunning();
    }

    private void clear() {
        this.port = 0;
        this.ip = "";
        this.serverAddr = "";
    }
}

