/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.RSSI;

import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.tizen.ecp.RSSI.RSSIGauge;
import org.tizen.ecp.dialogs.MessageDialog;
import org.tizen.ecp.legacy.InjectorMessage;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.resources.ColorResources;
import org.tizen.ecp.resources.FontResources;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.sock.SocketClient;
import org.tizen.ecp.telephony.TelephonyDisplay;
import org.tizen.ecp.timer.MessageTimer;
import org.tizen.ecp.utils.FormUtil;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.ECPSubView;

public class RSSIDisplay
extends ECPSubView {
    private Text sliderText;
    private RSSIGauge gauge;
    private Composite comp;
    private static Logger logger = LogUtil.getECPLogger(RSSIDisplay.class).getLogger();
    private int sendData = -1;
    boolean isRssi0 = false;
    private KeyAdapter textAdapter = new KeyAdapter(){

        public void keyReleased(KeyEvent keyEvent) {
            String string = RSSIDisplay.this.sliderText.getText().trim();
            if (string == null || string.length() == 0) {
                return;
            }
            try {
                if (RSSIDisplay.this.checkNumberFormat(string) || Double.parseDouble(string) < 0.0 || Double.parseDouble(string) > 4.0) {
                    throw null;
                }
                RSSIDisplay.this.gauge.setSelection(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                RSSIDisplay.this.sliderText.setText(Integer.toString(RSSIDisplay.this.gauge.getSelection()));
                return;
            }
            catch (Exception exception) {
                RSSIDisplay.this.sliderText.setText(Integer.toString(RSSIDisplay.this.gauge.getSelection()));
                return;
            }
        }
    };
    private FocusAdapter focusAdapter = new FocusAdapter(){

        public void focusLost(FocusEvent focusEvent) {
            if (RSSIDisplay.this.sliderText.getText().isEmpty()) {
                RSSIDisplay.this.sliderText.setText(Integer.toString(RSSIDisplay.this.gauge.getSelection()));
            }
        }
    };
    private SelectionAdapter gaugeAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (RSSIDisplay.this.sendData == RSSIDisplay.this.gauge.getSelection()) {
                return;
            }
            RSSIDisplay.this.sendData = RSSIDisplay.this.gauge.getSelection();
            RSSIDisplay.this.sliderText.setText(Integer.toString(RSSIDisplay.this.sendData));
            if (!SocketClient.getInstance().getGuestStatus()) {
                MessageDialog messageDialog = new MessageDialog();
                messageDialog.openInfoDialog("Emulator is not ready. Please retry when the emulator is ready.");
            } else {
                RSSIDisplay.this.sendRSSI();
            }
        }
    };

    public RSSIDisplay() {
        this.title = "RSSI";
        this.pageHeight = 170;
        this.useTimer = true;
    }

    public void createView(Composite composite) {
        FormUtil.createLabel((Composite)composite, (String)"Level", (Font)FontResources.FONT_12.getFont(), (Color)ColorResources.TEXT_GREEN.getColor());
        this.comp = FormUtil.createComposite((Composite)composite, (int)2);
        this.gauge = this.createGauge(this.comp);
        this.gauge.setLayoutData(FormUtil.createGD((int)280, (int)110, (int)50, (int)0));
        this.gauge.addSelectionListener((SelectionListener)this.gaugeAdapter);
        Composite composite2 = FormUtil.createComposite((Composite)this.comp, (int)1);
        this.sliderText = FormUtil.createText((Composite)composite2, (int)0x1000800);
        this.sliderText.setTextLimit(1);
        this.sliderText.setLayoutData((Object)FormUtil.createGD((int)80, (int)25, (int)20, (int)0));
        this.sliderText.addFocusListener((FocusListener)this.focusAdapter);
        this.sliderText.addKeyListener((KeyListener)this.textAdapter);
    }

    public void sendLevelMessage(int n) {
        logger.info("RSSI - sendLevelMessage with level : " + n);
        try {
            if (!MessageTimer.getInstance().isRunning()) {
                MessageTimer.getInstance().RestartTimer();
            }
        }
        catch (IOException iOException) {
            logger.severe(iOException.getMessage());
        }
        InjectorMessage injectorMessage = new InjectorMessage(n);
        MessageSender.getInstance().sendInjectorReq("sensor", 0, 0, "11\n" + injectorMessage.getMessage());
        MessageSender.getInstance().sendInjectorReq("telephony", 19, n);
    }

    private boolean checkNumberFormat(String string) {
        Pattern pattern = Pattern.compile("[^0-9]");
        Matcher matcher = pattern.matcher(string);
        return matcher.find();
    }

    public void sendRSSI() {
        this.sendLevelMessage(this.sendData);
        if (this.sendData == 0) {
            if (!this.isRssi0) {
                TelephonyDisplay.getInstance().sendNetStatus(false);
            }
            this.isRssi0 = true;
        } else {
            if (this.isRssi0) {
                TelephonyDisplay.getInstance().sendNetStatus(true);
            }
            this.isRssi0 = false;
        }
    }

    protected void initializeWidget() {
        TelephonyDisplay.getInstance().sendNetStatus(true);
    }

    public void destroyContents(Composite composite) {
        composite.layout(true, true);
    }

    public void OnActivate() {
        MessageTimer.getInstance().startTimer(this.UPDATING_TIME);
    }

    public void OnDeactivate() {
        logger.info("RSSI - timer must be deactivated.");
        MessageTimer.getInstance().StopTimer();
    }

    public void OnTimerMessageExpired() {
        logger.info("RSSI - timer expired.");
        MessageSender.getInstance().sendInjectorReq("sensor", 15, 104);
    }

    public boolean Create() {
        this.createPage();
        EventMgr.getInstance().AddLsn("sensor", (ILsn)this);
        return true;
    }

    public RSSIGauge createGauge(Composite composite) {
        return new RSSIGauge(composite, 0);
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
        String string;
        Ecs.InjectorNtf injectorNtf;
        int n;
        if (generatedMessage instanceof Ecs.InjectorNtf && 104 == (n = (injectorNtf = (Ecs.InjectorNtf)generatedMessage).getAction()) && (string = injectorNtf.getData().toStringUtf8()) != null && !string.isEmpty()) {
            try {
                int n2 = Integer.parseInt(string);
                logger.info("RSSI - OnStatusEventProcPB : " + n2);
                if (this.sendData != n2) {
                    this.sendData = n2;
                    this.gauge.setSelection(this.sendData);
                    this.sliderText.setText(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                logger.log(Level.SEVERE, "Number format", numberFormatException);
            }
        }
    }
}

