/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.nfc;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.tizen.ecp.nfc.FileListingService;
import org.tizen.ecp.resources.ImageResources;

public class TizenRemoteFileDialog {
    private TizenRemoteFileDialogResult result = TizenRemoteFileDialogResult.CANCEL;
    private Shell shell;
    private Display display;
    private Label path;
    private String defaultPath;
    private FileListingService.FileEntry selectedDir;
    private Tree pathTree;
    private Composite upper;
    private boolean enableMultiSelection = false;

    public TizenRemoteFileDialog(Shell shell, String string, boolean bl, String string2) throws IllegalArgumentException {
        if (shell == null) {
            throw new IllegalArgumentException();
        }
        this.display = shell.getDisplay();
        this.shell = this.createNewShell(shell);
        this.shell.setText(string);
        this.shell.setSize(300, 400);
        this.shell.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 2: {
                        TizenRemoteFileDialog.this.shell.close();
                        event.detail = 0;
                        event.doit = false;
                        break;
                    }
                }
            }
        });
        this.setDefaultPath(string2);
        this.createControls((Composite)this.shell);
    }

    public TizenRemoteFileDialog(Shell shell, String string, boolean bl, String string2, boolean bl2) {
        this(shell, string, bl, string2);
        this.enableMultiSelection = bl2;
    }

    public TizenRemoteFileDialogResult open() {
        this.shell.open();
        this.runEventLoop(this.shell);
        return this.result;
    }

    public FileListingService.FileEntry getSelectedFileEntry() {
        return this.selectedDir;
    }

    private void createControls(Composite composite) {
        this.upper = new Composite(composite, 0);
        this.setUpperLayout(this.upper);
        this.createPathLabels(this.upper);
        this.createPathTree(this.upper);
        this.fillPathTree();
        Composite composite2 = new Composite(composite, 0);
        this.setLowerLayout(composite2);
        this.createButtons(composite2);
    }

    private void setPathTreeImages(TreeItem treeItem, FileListingService.FileEntry fileEntry) {
        switch (fileEntry.getType()) {
            case 5: {
                treeItem.setImage(ImageResources.FILE_LINK.getImage());
                break;
            }
            case 1: {
                treeItem.setImage(ImageResources.DIRECTORY.getImage());
                new TreeItem(treeItem, 0);
                break;
            }
            case 2: {
                treeItem.setImage(ImageResources.DIRECTORY_LINK.getImage());
                new TreeItem(treeItem, 0);
                break;
            }
            default: {
                treeItem.setImage(ImageResources.FILE.getImage());
            }
        }
    }

    private void fillPathTree() {
        this.createTreeColumn();
        FileListingService fileListingService = new FileListingService();
        FileListingService.FileEntry fileEntry = fileListingService.getRoot();
        String[] stringArray = this.defaultPath.substring(1).split("/");
        this.cacheChild(fileEntry, stringArray);
        FileListingService.FileEntry[] fileEntryArray = fileEntry.getFileListingService().getChildren(fileEntry, true, null);
        for (int i = 0; i < fileEntryArray.length; ++i) {
            TreeItem treeItem = new TreeItem(this.pathTree, 0);
            treeItem.setText(fileEntryArray[i].getName());
            treeItem.setData((Object)fileEntryArray[i]);
            this.setPathTreeImages(treeItem, fileEntryArray[i]);
        }
        this.pathTree.addListener(17, new Listener(){

            public void handleEvent(Event event) {
                TreeItem treeItem = (TreeItem)event.item;
                TreeItem[] treeItemArray = treeItem.getItems();
                for (int i = 0; i < treeItemArray.length; ++i) {
                    if (treeItemArray[i].getData() != null) {
                        return;
                    }
                    treeItemArray[i].dispose();
                }
                FileListingService.FileEntry fileEntry = (FileListingService.FileEntry)treeItem.getData();
                if (fileEntry == null) {
                    return;
                }
                FileListingService.FileEntry[] fileEntryArray = fileEntry.getFileListingService().getChildren(fileEntry, true, null);
                for (int i = 0; i < fileEntryArray.length; ++i) {
                    TreeItem treeItem2 = new TreeItem(treeItem, 0);
                    treeItem2.setText(fileEntryArray[i].getName());
                    treeItem2.setData((Object)fileEntryArray[i]);
                    TizenRemoteFileDialog.this.setPathTreeImages(treeItem2, fileEntryArray[i]);
                }
            }
        });
        this.selectDefaultPath(stringArray);
        if (this.pathTree.getSelection().length > 0) {
            this.pathTree.setTopItem(this.pathTree.getSelection()[0]);
        }
        this.pathTree.layout();
        this.pathTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TreeColumn[] treeColumnArray;
                TreeItem[] treeItemArray = TizenRemoteFileDialog.this.pathTree.getSelection();
                if (treeItemArray.length == 1 && (treeColumnArray = treeItemArray[0].getData()) instanceof FileListingService.FileEntry) {
                    TizenRemoteFileDialog.this.selectedDir = (FileListingService.FileEntry)treeColumnArray;
                    TizenRemoteFileDialog.this.path.setText(TizenRemoteFileDialog.this.selectedDir.getFullPath());
                }
                for (TreeColumn treeColumn : TizenRemoteFileDialog.this.pathTree.getColumns()) {
                    treeColumn.pack();
                }
            }
        });
    }

    private void selectDefaultPath(String[] stringArray) {
        Object object;
        TreeItem[] treeItemArray = this.pathTree.getItems();
        TreeItem treeItem = null;
        block0: for (int i = 0; i < stringArray.length; ++i) {
            if (treeItem != null) {
                treeItemArray = treeItem.getItems();
            }
            object = treeItemArray;
            int n = ((TreeItem[])object).length;
            for (int j = 0; j < n; ++j) {
                FileListingService.FileEntry fileEntry;
                TreeItem treeItem2 = object[j];
                Object object2 = treeItem2.getData();
                if (!(object2 instanceof FileListingService.FileEntry) || !(fileEntry = (FileListingService.FileEntry)object2).getName().equals(stringArray[i])) continue;
                treeItem = treeItem2;
                continue block0;
            }
        }
        if (treeItem != null) {
            this.pathTree.select(treeItem);
            Object object3 = treeItem.getData();
            if (object3 instanceof FileListingService.FileEntry) {
                this.selectedDir = object = (FileListingService.FileEntry)object3;
            }
        }
    }

    private void createTreeColumn() {
        final TreeColumn treeColumn = new TreeColumn(this.pathTree, 16384);
        treeColumn.setText("Name");
        treeColumn.setWidth(100);
        this.upper.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Point point;
                Rectangle rectangle = TizenRemoteFileDialog.this.upper.getClientArea();
                Point point2 = TizenRemoteFileDialog.this.pathTree.computeSize(-1, -1);
                ScrollBar scrollBar = TizenRemoteFileDialog.this.pathTree.getVerticalBar();
                int n = rectangle.width - ((TizenRemoteFileDialog)TizenRemoteFileDialog.this).pathTree.computeTrim((int)0, (int)0, (int)0, (int)0).width - scrollBar.getSize().x;
                if (point2.y > rectangle.height + TizenRemoteFileDialog.this.pathTree.getHeaderHeight()) {
                    point = scrollBar.getSize();
                    n -= point.x;
                }
                point = TizenRemoteFileDialog.this.pathTree.getSize();
                if (point.x > rectangle.width) {
                    treeColumn.setWidth(n);
                    TizenRemoteFileDialog.this.pathTree.setSize(rectangle.width, rectangle.height);
                } else {
                    TizenRemoteFileDialog.this.pathTree.setSize(rectangle.width, rectangle.height);
                    treeColumn.setWidth(n);
                }
            }
        });
    }

    private void cacheChild(FileListingService.FileEntry fileEntry, String[] stringArray) {
        FileListingService.FileEntry[] fileEntryArray = fileEntry.getFileListingService().getChildren(fileEntry, true, null);
        block0: for (String string : stringArray) {
            for (FileListingService.FileEntry fileEntry2 : fileEntryArray) {
                if (!string.equals(fileEntry2.getName())) continue;
                fileEntryArray = fileEntry2.getFileListingService().getChildren(fileEntry2, true, null);
                continue block0;
            }
        }
    }

    private Shell createNewShell(Shell shell) {
        this.shell = new Shell(this.display, 67680);
        this.setDefaultLayout();
        return this.shell;
    }

    private void setDefaultLayout() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.shell.setLayout((Layout)gridLayout);
    }

    private void setUpperLayout(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
    }

    private void setLowerLayout(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 3;
        composite.setLayoutData((Object)gridData);
    }

    private void createPathLabels(Composite composite) {
        Label label = new Label(composite, 0);
        this.setPathLabelLayout(label);
        label.setText("Path : ");
        this.path = new Label(composite, 0);
        this.setPathLayout(this.path);
        this.path.setText(this.defaultPath);
    }

    private void setPathLabelLayout(Label label) {
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
    }

    private void setPathLayout(Label label) {
        GridData gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
    }

    private void createPathTree(Composite composite) {
        int n = 65536;
        if (this.enableMultiSelection) {
            n |= 2;
        }
        this.pathTree = new Tree(composite, n);
        this.setTreeLayout(this.pathTree);
    }

    private void setTreeLayout(Tree tree) {
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        tree.setLayoutData((Object)gridData);
    }

    private void createButtons(Composite composite) {
        Button button = new Button(composite, 8);
        this.setOkButtonLayout(button);
        button.setText("OK");
        button.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 4: {
                        if (event.button != 1) break;
                        TizenRemoteFileDialog.this.result = TizenRemoteFileDialogResult.OK;
                        TizenRemoteFileDialog.this.shell.dispose();
                        break;
                    }
                }
            }
        });
        Button button2 = new Button(composite, 8);
        this.setCancelButtonLayout(button);
        button2.setText("Cancel");
        button2.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 4: {
                        if (event.button != 1) break;
                        TizenRemoteFileDialog.this.result = TizenRemoteFileDialogResult.CANCEL;
                        TizenRemoteFileDialog.this.shell.dispose();
                        break;
                    }
                }
            }
        });
    }

    private void setOkButtonLayout(Button button) {
        GridData gridData = new GridData();
        gridData.widthHint = 50;
        button.setLayoutData((Object)gridData);
    }

    private void setCancelButtonLayout(Button button) {
        GridData gridData = new GridData();
        gridData.widthHint = 50;
        button.setLayoutData((Object)gridData);
    }

    private void runEventLoop(Shell shell) {
        Display display = shell.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        this.display.update();
    }

    private void setDefaultPath(String string) {
        this.defaultPath = string == null ? "/" : string;
    }

    public static enum TizenRemoteFileDialogResult {
        OK,
        CANCEL;

    }
}

