/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sensor;

import com.google.protobuf.GeneratedMessage;
import java.text.DecimalFormat;
import org.kohsuke.args4j.Argument;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.MessageSender;

public class SensorStatusCLI
extends AbstractEmulatorCLI {
    private String TYPE_SENSOR = "sensor";
    DecimalFormat df = new DecimalFormat("#0.0");
    DecimalFormat df2 = new DecimalFormat("#0.00");
    @Argument(required=false, index=0, metaVar="accelerometer gyroscope magnetic proximity light pressure uv hrm")
    String mode;
    private static int retNum = 0;
    private String accel = null;
    private String mag = null;
    private String gyro = null;
    private String light = null;
    private String proxi = null;
    private String press = null;
    private String uv = null;
    private String hrm = null;
    private static final double GYRO_ADJUST = 57.142857142857146;

    public SensorStatusCLI() {
        this.messageType = this.TYPE_SENSOR;
    }

    private void send(int n) {
        MessageSender.getInstance().sendDeviceReq("sensor", 15, n);
    }

    public int execute() {
        if (this.mode == null || this.mode.isEmpty()) {
            this.send(110);
            this.send(112);
            this.send(111);
            this.send(113);
            this.send(114);
            this.send(116);
            this.send(117);
            this.send(118);
        } else if (this.mode.equals("accelerometer")) {
            this.send(110);
        } else if (this.mode.equals("gyroscope")) {
            this.send(111);
        } else if (this.mode.equals("magnetic")) {
            this.send(112);
        } else if (this.mode.equals("proximity")) {
            this.send(114);
        } else if (this.mode.equals("light")) {
            this.send(113);
        } else if (this.mode.equals("pressure")) {
            this.send(116);
        } else if (this.mode.equals("uv")) {
            this.send(117);
        } else if (this.mode.equals("hrm")) {
            this.send(118);
        } else {
            OutputUtil.println((String)("\t'" + this.mode + "' is not a valid argument."));
            this.printHelp();
            return 25;
        }
        this.startRunning();
        return 0;
    }

    private int accelTrans(String string) throws NumberFormatException {
        return Integer.parseInt(string) / 980665;
    }

    private void printAccel(String string) {
        String[] stringArray = string.split(",");
        try {
            String string2 = this.df.format(this.accelTrans(stringArray[0]));
            String string3 = this.df.format(this.accelTrans(stringArray[1]));
            String string4 = this.df.format(this.accelTrans(stringArray[2]));
            OutputUtil.printStatus((String)"Accelerometer", (String)(string2 + ", " + string3 + ", " + string4));
        }
        catch (NumberFormatException numberFormatException) {
            OutputUtil.printStatus((String)"Accelerometer", (String)"ERROR");
        }
    }

    private void printMag(String string) {
        String[] stringArray = string.split(" ");
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        String string4 = stringArray[2];
        OutputUtil.printStatus((String)"Magnetic", (String)(string2 + ", " + string3 + ", " + string4));
    }

    private double gyroTrans(String string) throws NumberFormatException {
        return (double)Integer.parseInt(string) / 57.142857142857146;
    }

    private void printGyro(String string) {
        String[] stringArray = string.split(",");
        try {
            String string2 = this.df2.format(this.gyroTrans(stringArray[0]));
            String string3 = this.df2.format(this.gyroTrans(stringArray[1]));
            String string4 = this.df2.format(this.gyroTrans(stringArray[2]));
            OutputUtil.printStatus((String)"Gyroscope", (String)(string2 + ", " + string3 + ", " + string4));
        }
        catch (NumberFormatException numberFormatException) {
            OutputUtil.printStatus((String)"Gyroscope", (String)"ERROR");
        }
    }

    private void printUV(String string) {
        try {
            String string2 = this.df.format(Integer.parseInt(string) / 10);
            OutputUtil.printStatus((String)"Ultraviolet", (String)string2);
        }
        catch (NumberFormatException numberFormatException) {
            OutputUtil.printStatus((String)"Ultraviolet", (String)"ERROR");
        }
    }

    private void printHRM(String string) {
        String[] stringArray = string.split(", ");
        try {
            String string2 = this.df.format(Integer.parseInt(stringArray[0]) / 10);
            String string3 = this.df.format(Integer.parseInt(stringArray[1]));
            OutputUtil.printStatus((String)"HRM", (String)(string2 + ", " + string3));
        }
        catch (NumberFormatException numberFormatException) {
            OutputUtil.printStatus((String)"HRM", (String)"ERROR");
        }
    }

    private void printPress(String string) {
        String[] stringArray = string.split(", ");
        OutputUtil.printStatus((String)"Pressure", (String)stringArray[0]);
    }

    public void OnEventProcPB(String string, GeneratedMessage generatedMessage) {
        if (generatedMessage instanceof Ecs.DeviceAns) {
            Ecs.DeviceAns deviceAns = (Ecs.DeviceAns)generatedMessage;
            int n = deviceAns.getErrcode();
            if (n != 0) {
                this.returnValue = 128;
                OutputUtil.printFail();
                this.clear();
                this.stopRunning();
                return;
            }
            ++retNum;
        }
        if (this.mode != null && !this.mode.isEmpty() && retNum != 0) {
            OutputUtil.printOK();
            if (this.accel != null) {
                this.printAccel(this.accel);
            } else if (this.mag != null) {
                this.printMag(this.mag);
            } else if (this.gyro != null) {
                this.printGyro(this.gyro);
            } else if (this.light != null) {
                OutputUtil.printStatus((String)"Light", (String)this.light);
            } else if (this.proxi != null) {
                OutputUtil.printStatus((String)"Proximity", (String)this.proxi);
            } else if (this.press != null) {
                this.printPress(this.press);
            } else if (this.uv != null) {
                this.printUV(this.uv);
            } else if (this.hrm != null) {
                this.printHRM(this.hrm);
            }
            this.clear();
            this.stopRunning();
        } else if (retNum == 8) {
            OutputUtil.debug((String)String.format("sensors: %s * %s * %s * %s * %s * %s * %s * %s", this.accel, this.mag, this.gyro, this.light, this.proxi, this.press, this.uv, this.hrm));
            if (this.accel != null && this.mag != null && this.gyro != null && this.light != null && this.proxi != null) {
                OutputUtil.printOK();
                this.printAccel(this.accel);
                this.printMag(this.mag);
                this.printGyro(this.gyro);
                OutputUtil.printStatus((String)"Light", (String)this.light);
                OutputUtil.printStatus((String)"Proximity", (String)this.proxi);
                this.printPress(this.press);
                this.printUV(this.uv);
                this.printHRM(this.hrm);
            }
            this.clear();
            this.stopRunning();
        }
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
        if (generatedMessage instanceof Ecs.DeviceNtf) {
            Ecs.DeviceNtf deviceNtf = (Ecs.DeviceNtf)generatedMessage;
            long l = deviceNtf.getAction();
            if (110L == l) {
                this.accel = deviceNtf.getData().toStringUtf8();
            } else if (112L == l) {
                this.mag = deviceNtf.getData().toStringUtf8();
            } else if (111L == l) {
                this.gyro = deviceNtf.getData().toStringUtf8();
            } else if (113L == l) {
                this.light = deviceNtf.getData().toStringUtf8();
            } else if (114L == l) {
                this.proxi = deviceNtf.getData().toStringUtf8().equals("8") ? "off" : "on";
            } else if (116L == l) {
                this.press = deviceNtf.getData().toStringUtf8();
            } else if (117L == l) {
                this.uv = deviceNtf.getData().toStringUtf8();
            } else if (118L == l) {
                this.hrm = deviceNtf.getData().toStringUtf8();
            }
            ++retNum;
        }
        if (this.mode != null && !this.mode.isEmpty() && retNum != 0) {
            OutputUtil.printOK();
            if (this.accel != null) {
                this.printAccel(this.accel);
            } else if (this.mag != null) {
                this.printMag(this.mag);
            } else if (this.gyro != null) {
                this.printGyro(this.gyro);
            } else if (this.light != null) {
                OutputUtil.printStatus((String)"Light", (String)this.light);
            } else if (this.proxi != null) {
                OutputUtil.printStatus((String)"Proximity", (String)this.proxi);
            } else if (this.press != null) {
                this.printPress(this.press);
            } else if (this.uv != null) {
                this.printUV(this.uv);
            } else if (this.hrm != null) {
                this.printHRM(this.hrm);
            }
            this.clear();
            this.stopRunning();
        } else if (retNum == 8) {
            OutputUtil.debug((String)String.format("sensors: %s * %s * %s * %s * %s * %s * %s * %s", this.accel, this.mag, this.gyro, this.light, this.proxi, this.press, this.uv, this.hrm));
            if (this.accel != null && this.mag != null && this.gyro != null && this.light != null && this.proxi != null) {
                OutputUtil.printOK();
                this.printAccel(this.accel);
                this.printMag(this.mag);
                this.printGyro(this.gyro);
                OutputUtil.printStatus((String)"Light", (String)this.light);
                OutputUtil.printStatus((String)"Proximity", (String)this.proxi);
                this.printPress(this.press);
                this.printUV(this.uv);
                this.printHRM(this.hrm);
            }
            this.clear();
            this.stopRunning();
        }
    }

    private void clear() {
        this.mode = null;
        retNum = 0;
        this.accel = null;
        this.mag = null;
        this.gyro = null;
        this.light = null;
        this.proxi = null;
        this.press = null;
        this.uv = null;
        this.hrm = null;
    }
}

