/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sensor.accelerometer;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.tizen.ecp.legacy.InjectorMessage;
import org.tizen.ecp.sensor.accelerometer.AccConstants;
import org.tizen.ecp.sensor.accelerometer.AccelFileFinished;
import org.tizen.ecp.sensor.accelerometer.AccelFileOperation;
import org.tizen.ecp.sensor.accelerometer.AccelerometerDisplay;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.timer.MessageTimer;
import org.tizen.ecp.utils.FormUtil;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.utils.SwtUtil;
import org.tizen.ecp.widgets.ECPButton;
import org.tizen.ecp.widgets.ECPSlider;

public class UserAccelDisplay
implements AccelFileFinished {
    private AccelerometerDisplay display;
    private Logger logger = LogUtil.getECPLogger(UserAccelDisplay.class).getLogger();
    private ECPSlider xSlider;
    private ECPSlider ySlider;
    private ECPSlider zSlider;
    private Text xText;
    private Text yText;
    private Text zText;
    double xValue;
    double yValue;
    double zValue;
    double g = 9.80665;
    DecimalFormat df = new DecimalFormat("0.##");
    private Text filenameText;
    private Text repeatText;
    private ECPButton startButton;
    private ECPButton stopButton;
    private ECPButton deleteButton;
    private ECPButton addButton;
    private Table table;
    private int repeatCount = 1;
    private int fileCnt = 0;
    private SelectionAdapter sliderSelection = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (selectionEvent.widget == UserAccelDisplay.this.xSlider) {
                int n = UserAccelDisplay.this.xSlider.getSelection() - 200;
                UserAccelDisplay.this.xValue = (double)n * 0.01;
                UserAccelDisplay.this.xText.setText(UserAccelDisplay.this.df.format(UserAccelDisplay.this.xValue));
            } else if (selectionEvent.widget == UserAccelDisplay.this.ySlider) {
                int n = UserAccelDisplay.this.ySlider.getSelection() - 200;
                UserAccelDisplay.this.yValue = (double)n * 0.01;
                UserAccelDisplay.this.yText.setText(UserAccelDisplay.this.df.format(UserAccelDisplay.this.yValue));
            } else if (selectionEvent.widget == UserAccelDisplay.this.zSlider) {
                int n = UserAccelDisplay.this.zSlider.getSelection() - 200;
                UserAccelDisplay.this.zValue = (double)n * 0.01;
                UserAccelDisplay.this.zText.setText(UserAccelDisplay.this.df.format(UserAccelDisplay.this.zValue));
            }
            UserAccelDisplay.this.sendMessage();
        }
    };
    private KeyAdapter textSelection = new KeyAdapter(){

        public void keyReleased(KeyEvent keyEvent) {
            String string = null;
            if (keyEvent.widget == UserAccelDisplay.this.xText) {
                string = UserAccelDisplay.this.xText.getText().trim();
            } else if (keyEvent.widget == UserAccelDisplay.this.yText) {
                string = UserAccelDisplay.this.yText.getText().trim();
            } else if (keyEvent.widget == UserAccelDisplay.this.zText) {
                string = UserAccelDisplay.this.zText.getText().trim();
            }
            if (string == null || string.length() == 0 || "-".equals(string) || string.endsWith(".")) {
                return;
            }
            try {
                if (!FormUtil.isNumeric((String)string) || Double.parseDouble(string) < -2.0 || Double.parseDouble(string) > 2.0) {
                    throw null;
                }
            }
            catch (NumberFormatException numberFormatException) {
                Shell shell = UserAccelDisplay.this.display.getComposite().getShell();
                SwtUtil.openInfoDialog((Shell)shell, (String)"Emulator Control Panel", (String)"Please enter the correct value.\nThe value can be entered in the range of -2  to 2.");
                if (keyEvent.widget == UserAccelDisplay.this.xText) {
                    UserAccelDisplay.this.xText.setText(UserAccelDisplay.this.df.format(UserAccelDisplay.this.xValue));
                } else if (keyEvent.widget == UserAccelDisplay.this.yText) {
                    UserAccelDisplay.this.yText.setText(UserAccelDisplay.this.df.format(UserAccelDisplay.this.yValue));
                } else if (keyEvent.widget == UserAccelDisplay.this.zText) {
                    UserAccelDisplay.this.zText.setText(UserAccelDisplay.this.df.format(UserAccelDisplay.this.zValue));
                }
                return;
            }
            catch (Exception exception) {
                Shell shell = UserAccelDisplay.this.display.getComposite().getShell();
                SwtUtil.openInfoDialog((Shell)shell, (String)"Emulator Control Panel", (String)"Please enter the correct value.\nThe value can be entered in the range of -2  to 2.");
                if (keyEvent.widget == UserAccelDisplay.this.xText) {
                    UserAccelDisplay.this.xText.setText(UserAccelDisplay.this.df.format(UserAccelDisplay.this.xValue));
                } else if (keyEvent.widget == UserAccelDisplay.this.yText) {
                    UserAccelDisplay.this.yText.setText(UserAccelDisplay.this.df.format(UserAccelDisplay.this.yValue));
                } else if (keyEvent.widget == UserAccelDisplay.this.zText) {
                    UserAccelDisplay.this.zText.setText(UserAccelDisplay.this.df.format(UserAccelDisplay.this.zValue));
                }
                return;
            }
            if (keyEvent.widget == UserAccelDisplay.this.xText) {
                UserAccelDisplay.this.xValue = Double.parseDouble(string);
                int n = (int)(Double.parseDouble(string) * 100.0 + 200.0);
                UserAccelDisplay.this.xSlider.setSelection(n);
            } else if (keyEvent.widget == UserAccelDisplay.this.yText) {
                UserAccelDisplay.this.yValue = Double.parseDouble(string);
                int n = (int)(Double.parseDouble(string) * 100.0 + 200.0);
                UserAccelDisplay.this.ySlider.setSelection(n);
            } else if (keyEvent.widget == UserAccelDisplay.this.zText) {
                UserAccelDisplay.this.zValue = Double.parseDouble(string);
                int n = (int)(Double.parseDouble(string) * 100.0 + 200.0);
                UserAccelDisplay.this.zSlider.setSelection(n);
            }
            UserAccelDisplay.this.sendMessage();
        }
    };
    private int ACCEL_ADJUST = 100000;

    public UserAccelDisplay(AccelerometerDisplay accelerometerDisplay) {
        this.display = accelerometerDisplay;
        AccelFileOperation.getInstance().registerFileOperation(this);
    }

    public void createDisplay(Composite composite) {
        this.createUserAccel(composite);
        this.createFileInput(composite);
    }

    private void setDefaultValue(ECPSlider eCPSlider) {
        eCPSlider.setValues(200, 0, 400, 1, 1, 20);
    }

    private ECPSlider createSlider(Composite composite) {
        ECPSlider eCPSlider = FormUtil.createECPSlider((Composite)composite);
        this.setDefaultValue(eCPSlider);
        eCPSlider.setLayoutData((Object)FormUtil.createGD((int)290, (int)22, (int)0, (int)4));
        eCPSlider.addSelectionListener((SelectionListener)this.sliderSelection);
        return eCPSlider;
    }

    private Text createText(Composite composite, String string) {
        Text text = FormUtil.createText((Composite)composite, (String)string);
        text.setLayoutData((Object)FormUtil.createGD((int)40, (int)22));
        text.setTextLimit(5);
        text.addKeyListener((KeyListener)this.textSelection);
        return text;
    }

    private void createUserAccel(Composite composite) {
        FormUtil.createLabel((Composite)composite, (String)"Acceleration");
        Composite composite2 = FormUtil.createComposite((Composite)composite, (int)4);
        GridData gridData = FormUtil.createHGD();
        gridData.widthHint = 491;
        composite2.setLayoutData((Object)FormUtil.createHGD());
        FormUtil.createLabel((Composite)composite2, (String)"X : ");
        this.xSlider = this.createSlider(composite2);
        this.xValue = 0.0;
        this.xText = this.createText(composite2, this.df.format(this.xValue));
        FormUtil.createLabel((Composite)composite2, (String)"[g]", (Font)AccConstants.UNIT_FONT_SIZE);
        FormUtil.createLabel((Composite)composite2, (String)"Y : ");
        this.ySlider = this.createSlider(composite2);
        this.yValue = 0.0;
        this.yText = this.createText(composite2, this.df.format(this.yValue));
        FormUtil.createLabel((Composite)composite2, (String)"[g]", (Font)AccConstants.UNIT_FONT_SIZE);
        FormUtil.createLabel((Composite)composite2, (String)"Z : ");
        this.zSlider = this.createSlider(composite2);
        this.zValue = 0.0;
        this.zText = this.createText(composite2, this.df.format(this.zValue));
        FormUtil.createLabel((Composite)composite2, (String)"[g]", (Font)AccConstants.UNIT_FONT_SIZE);
    }

    private void createFileInput(Composite composite) {
        FormUtil.createLabel((Composite)composite, (String)"File input");
        Composite composite2 = FormUtil.createComposite((Composite)composite, (int)4);
        GridData gridData = FormUtil.createHGD();
        gridData.widthHint = 491;
        composite2.setLayoutData((Object)gridData);
        this.filenameText = FormUtil.createText((Composite)composite2, (String)"");
        gridData = FormUtil.createGD((int)250, (int)22);
        this.filenameText.setLayoutData((Object)gridData);
        this.filenameText.setEditable(false);
        ECPButton eCPButton = FormUtil.createPushButton((Composite)composite2, (String)"Browse");
        eCPButton.setLayoutData((Object)FormUtil.createGD((int)80, (int)22));
        eCPButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(new Shell());
                String string = fileDialog.open();
                if (string == null) {
                    return;
                }
                UserAccelDisplay.this.filenameText.setText(string);
            }
        });
        this.addButton = FormUtil.createPushButton((Composite)composite2, (String)"Add");
        this.addButton.setLayoutData((Object)FormUtil.createGD((int)80, (int)22));
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = UserAccelDisplay.this.filenameText.getText();
                if (string.isEmpty()) {
                    return;
                }
                if (UserAccelDisplay.this.fileCnt == 5) {
                    Shell shell = UserAccelDisplay.this.display.getComposite().getShell();
                    SwtUtil.openInfoDialog((Shell)shell, (String)"Emulator Control Panel", (String)"The maximum number of files is 5.");
                    return;
                }
                TableItem tableItem = new TableItem(UserAccelDisplay.this.table, 0);
                String[] stringArray = new String[]{Integer.toString(++UserAccelDisplay.this.fileCnt), string};
                tableItem.setText(stringArray);
                UserAccelDisplay.this.startButton.setEnabled(true);
                UserAccelDisplay.this.deleteButton.setEnabled(true);
            }
        });
        Composite composite3 = FormUtil.createComposite((Composite)composite, (int)1);
        gridData = FormUtil.createHGD();
        gridData.widthHint = 491;
        composite3.setLayoutData((Object)gridData);
        this.table = new Table(composite3, 2050);
        gridData = FormUtil.createGD((int)430, (int)90);
        this.table.setLayoutData((Object)gridData);
        TableColumn tableColumn = new TableColumn(this.table, 0x1000000);
        TableColumn tableColumn2 = new TableColumn(this.table, 16384);
        tableColumn.setText("No.");
        tableColumn2.setText("          File path");
        tableColumn.setWidth(80);
        tableColumn2.setWidth(350);
        this.table.setHeaderVisible(true);
        Composite composite4 = FormUtil.createComposite((Composite)composite, (int)8);
        FormUtil.createLabel((Composite)composite4, (String)"Repeat :    ");
        ECPButton eCPButton2 = FormUtil.createPushButton((Composite)composite4, (String)"<");
        eCPButton2.setLayoutData((Object)FormUtil.createGD((int)16, (int)22));
        eCPButton2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (UserAccelDisplay.this.repeatCount != 1) {
                    UserAccelDisplay.this.repeatCount = UserAccelDisplay.this.repeatCount - 1;
                }
                UserAccelDisplay.this.repeatText.setText(String.format("%d", UserAccelDisplay.this.repeatCount));
            }
        });
        this.repeatText = FormUtil.createText((Composite)composite4, (String)String.format("%d", this.repeatCount));
        this.repeatText.setLayoutData((Object)FormUtil.createGD((int)8, (int)22));
        this.repeatText.setEditable(false);
        ECPButton eCPButton3 = FormUtil.createPushButton((Composite)composite4, (String)">");
        eCPButton3.setLayoutData((Object)FormUtil.createGD((int)16, (int)22));
        eCPButton3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (UserAccelDisplay.this.repeatCount != 9) {
                    UserAccelDisplay.this.repeatCount = UserAccelDisplay.this.repeatCount + 1;
                }
                UserAccelDisplay.this.repeatText.setText(String.format("%d", UserAccelDisplay.this.repeatCount));
            }
        });
        FormUtil.createLabel((Composite)composite4, (String)" ");
        this.startButton = FormUtil.createPushButton((Composite)composite4, (String)"Start");
        this.startButton.setLayoutData((Object)FormUtil.createGD((int)80, (int)22));
        this.startButton.setEnabled(false);
        this.startButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n;
                for (int i = 0; i < UserAccelDisplay.this.fileCnt; ++i) {
                    TableItem tableItem = UserAccelDisplay.this.table.getItem(i);
                    File file = new File(tableItem.getText(1));
                    if (!file.exists()) continue;
                    AccelFileOperation.getInstance().addFile(file.getPath());
                }
                try {
                    n = Integer.parseInt(UserAccelDisplay.this.repeatText.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    UserAccelDisplay.this.logger.log(Level.SEVERE, "Number format", numberFormatException);
                    n = 1;
                }
                AccelFileOperation.getInstance().setRepeatCount(n);
                UserAccelDisplay.this.startButton.setEnabled(false);
                UserAccelDisplay.this.stopButton.setEnabled(true);
                UserAccelDisplay.this.deleteButton.setEnabled(false);
                UserAccelDisplay.this.addButton.setEnabled(false);
                AccelFileOperation.getInstance().startInjection();
            }
        });
        this.stopButton = FormUtil.createPushButton((Composite)composite4, (String)"Stop");
        this.stopButton.setLayoutData((Object)FormUtil.createGD((int)80, (int)22));
        this.stopButton.setEnabled(false);
        this.stopButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AccelFileOperation.getInstance().stopInjection();
                UserAccelDisplay.this.stopButton.setEnabled(false);
                UserAccelDisplay.this.startButton.setEnabled(true);
                UserAccelDisplay.this.deleteButton.setEnabled(true);
                UserAccelDisplay.this.addButton.setEnabled(true);
            }
        });
        this.deleteButton = FormUtil.createPushButton((Composite)composite4, (String)"Delete");
        this.deleteButton.setLayoutData((Object)FormUtil.createGD((int)80, (int)22));
        this.deleteButton.setEnabled(false);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int[] nArray = UserAccelDisplay.this.table.getSelectionIndices();
                UserAccelDisplay.this.fileCnt = UserAccelDisplay.this.fileCnt - nArray.length;
                UserAccelDisplay.this.table.remove(nArray);
                for (int i = 0; i < UserAccelDisplay.this.fileCnt; ++i) {
                    UserAccelDisplay.this.table.getItem(i).setText(Integer.toString(i + 1));
                }
                if (UserAccelDisplay.this.fileCnt == 0) {
                    UserAccelDisplay.this.startButton.setEnabled(false);
                    UserAccelDisplay.this.deleteButton.setEnabled(false);
                }
            }
        });
    }

    public void sendMessage() {
        this.xValue = Double.parseDouble(this.xText.getText());
        this.yValue = Double.parseDouble(this.yText.getText());
        this.zValue = Double.parseDouble(this.zText.getText());
        try {
            if (!MessageTimer.getInstance().isRunning()) {
                MessageTimer.getInstance().RestartTimer();
            }
        }
        catch (IOException iOException) {
            this.logger.severe(iOException.getMessage());
        }
        InjectorMessage injectorMessage = new InjectorMessage(this.xValue * this.g * (double)this.ACCEL_ADJUST, this.yValue * this.g * (double)this.ACCEL_ADJUST, this.zValue * this.g * (double)this.ACCEL_ADJUST);
        MessageSender.getInstance().sendDeviceReq("sensor", 0, 0, "1\n" + injectorMessage.getMessage());
    }

    @Override
    public void fileOpsFinished() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                UserAccelDisplay.this.stopButton.setEnabled(false);
                UserAccelDisplay.this.startButton.setEnabled(true);
                UserAccelDisplay.this.deleteButton.setEnabled(true);
                UserAccelDisplay.this.addButton.setEnabled(true);
            }
        });
    }

    public void setStatus(String string) {
        int n = 980665;
        if (!string.isEmpty()) {
            String[] stringArray = string.split(",");
            Double d = Double.parseDouble(stringArray[0]) / (double)n;
            Double d2 = Double.parseDouble(stringArray[1]) / (double)n;
            Double d3 = Double.parseDouble(stringArray[2]) / (double)n;
            double d4 = (double)Math.round(d * 100.0) / 100.0;
            double d5 = (double)Math.round(d2 * 100.0) / 100.0;
            double d6 = (double)Math.round(d3 * 100.0) / 100.0;
            this.xText.setText(d4 + "");
            this.yText.setText(d5 + "");
            this.zText.setText(d6 + "");
            int n2 = (int)(d4 * 100.0 + 200.0);
            this.xSlider.setSelection(n2, false);
            int n3 = (int)(d5 * 100.0 + 200.0);
            this.ySlider.setSelection(n3, false);
            int n4 = (int)(d6 * 100.0 + 200.0);
            this.zSlider.setSelection(n4, false);
        }
    }
}

