/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.telephony.sms;

import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.tizen.ecp.dialogs.MessageDialog;
import org.tizen.ecp.nfc.AbstractInjectorReceiver;
import org.tizen.ecp.protocol.AbstractGA;
import org.tizen.ecp.protocol.StructureGA;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.telephony.TelephonyConstants;
import org.tizen.ecp.telephony.call.TelephonyCallDisplay;
import org.tizen.ecp.telephony.sms.encription.DecodeMsg;
import org.tizen.ecp.telephony.sms.encription.EncodeMsg;
import org.tizen.ecp.telephony.sms.encription.SMS_USERDATA;
import org.tizen.ecp.telephony.sms.encription.SmsAddressInfo;
import org.tizen.ecp.telephony.sms.encription.TPDU_SMS_DELIVER;
import org.tizen.ecp.telephony.sms.encription.TPDU_SMS_SUBMIT;
import org.tizen.ecp.telephony.sms.encription.TapiNetTextCodingScheme;
import org.tizen.ecp.telephony.sms.encription.TmDateTime;
import org.tizen.ecp.telephony.sms.protocol.G04A01;
import org.tizen.ecp.telephony.sms.protocol.G04A05;
import org.tizen.ecp.utils.FormUtil;
import org.tizen.ecp.widgets.ECPButton;

public class TelephonySMSDisplay {
    private HashMap<String, AbstractInjectorReceiver> receiverMap = new HashMap();
    private Composite parent;
    private final String[] SENDING_STATUS_VALUE_SMS = new String[]{"SMS OK(Success)", "SMS Not Available"};
    private final String[] SENDING_STATUS_VALUE_MMS = new String[]{"MMS OK(Success)", "MMS Failure"};
    private final char[] SMSC_NUM = new char[]{'\b', '\u0002', '\u0001', '\u0000', '\t', '\u0001', '\u0001', '\u0001', '\u0001'};
    private final String[] ORIGINATING_ADDRESS_LIST = new String[]{"+821030014180"};
    private Combo cmbSentStatusSendingStatus;
    private Combo cmbSentStatusMMSSendingStatus;
    private ECPButton butSentStatusSet;
    private Combo cmbMobileTerminateOriginatingAddress;
    private ECPButton butMobileTerminateSendMsg;
    private ECPButton butMobileTerminatePort;
    private Text txtMobileTerminateMessageText;
    private Text txtMobileTerminateReceivedMessage;
    private Text txtMobileTerminatePort;
    private Label lblMobileTerminateReceivedMessage;
    private Label txtMobileTerminateReceivedNumber;
    private Label lblMobileTerminatePortBlank;
    public boolean isMsgReceived = false;
    public int sleepCnt = 0;
    private static TelephonySMSDisplay instance = new TelephonySMSDisplay();

    public void setMsgReceived(boolean bl) {
        this.isMsgReceived = bl;
    }

    public boolean getMsgReceived() {
        return this.isMsgReceived;
    }

    public static TelephonySMSDisplay getInstance() {
        return instance;
    }

    public HashMap<String, AbstractInjectorReceiver> getReceiverMap() {
        return this.receiverMap;
    }

    public void createDisplay(Composite composite) {
        this.parent = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginRight = 0;
        this.parent.setLayout((Layout)gridLayout);
        this.parent.setLayoutData((Object)new GridData(4, 2, true, false));
        this.createSendSection();
        this.createReceiveSection();
        this.registerReceivers();
    }

    protected void registerReceivers() {
        SimDBReceiver simDBReceiver = new SimDBReceiver();
        TelephonyCallDisplay.getInstance().registerReceiver(simDBReceiver.getKey(), simDBReceiver);
    }

    public void showDialog(String string) {
        MessageDialog messageDialog = new MessageDialog();
        messageDialog.openInfoDialog(string);
    }

    private static boolean checkNumberFormat(String string) {
        Pattern pattern = Pattern.compile("[^0-9++]");
        Matcher matcher = pattern.matcher(string);
        return matcher.find();
    }

    private ArrayList<SMS_USERDATA> getUserData(String string) {
        ArrayList<SMS_USERDATA> arrayList = new ArrayList<SMS_USERDATA>();
        int n = 60;
        int n2 = string.length() / n;
        ++n2;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            SMS_USERDATA sMS_USERDATA = new SMS_USERDATA();
            try {
                int n4 = n3 + n > string.length() - n3 ? string.length() - n3 : n3 + n;
                sMS_USERDATA.data = string.substring(n3, n3 + n4).getBytes("ISO-10646-UCS-2");
                sMS_USERDATA.length = sMS_USERDATA.data.length;
                sMS_USERDATA.headerCnt = 1;
                sMS_USERDATA.setSMSUDH('\u0000', (short)0, (char)n2, (char)(i + 1));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
                continue;
            }
            if (n2 == 1) {
                sMS_USERDATA.headerCnt = 0;
            }
            arrayList.add(sMS_USERDATA);
            n3 += n;
        }
        return arrayList;
    }

    private byte[] convertToByte(char[] cArray, int n) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        return byArray;
    }

    protected void sendMsg(Boolean bl) {
        if (bl.booleanValue() && this.txtMobileTerminatePort.getText().equals("")) {
            this.showDialog("Please input the port value");
            this.txtMobileTerminatePort.setFocus();
            return;
        }
        if (!TelephonyCallDisplay.getInstance().getRssiStatus()) {
            this.showDialog("RSSI level is zero.\nPlease try again later.");
            return;
        }
        String string = this.cmbMobileTerminateOriginatingAddress.getText().trim();
        if (string == null || string.length() == 0) {
            this.showDialog("Input phone number.");
            return;
        }
        if (string.length() > 15) {
            this.showDialog("The maximum length of phone number is 15.");
            return;
        }
        if (TelephonySMSDisplay.checkNumberFormat(string)) {
            this.showDialog("This is invalid number. (" + string + ")");
            return;
        }
        char[] cArray = new char[500];
        int n = 0;
        int n2 = 240;
        EncodeMsg encodeMsg = new EncodeMsg();
        SmsAddressInfo smsAddressInfo = new SmsAddressInfo();
        smsAddressInfo.diallingNum = this.SMSC_NUM;
        smsAddressInfo.dialnumlen = smsAddressInfo.diallingNum.length;
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
        String string2 = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("MM");
        String string3 = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("dd");
        String string4 = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("HH");
        String string5 = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("mm");
        String string6 = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("ss");
        String string7 = simpleDateFormat.format(date);
        TmDateTime tmDateTime = new TmDateTime();
        tmDateTime.year = Integer.parseInt(string2.trim());
        tmDateTime.month = Integer.parseInt(string3.trim());
        tmDateTime.day = Integer.parseInt(string4.trim());
        tmDateTime.hour = Integer.parseInt(string5.trim());
        tmDateTime.minute = Integer.parseInt(string6.trim());
        tmDateTime.second = Integer.parseInt(string7.trim());
        TapiNetTextCodingScheme tapiNetTextCodingScheme = new TapiNetTextCodingScheme();
        tapiNetTextCodingScheme.bCompressed = false;
        tapiNetTextCodingScheme.bMsgClassSet = false;
        tapiNetTextCodingScheme.bMsgIndActive = false;
        tapiNetTextCodingScheme.codingGroupType = 0;
        tapiNetTextCodingScheme.waitingType = 0;
        tapiNetTextCodingScheme.alphabetType = 2;
        tapiNetTextCodingScheme.classType = 0;
        tapiNetTextCodingScheme.codingGroup = 0;
        tapiNetTextCodingScheme.code = 0;
        TPDU_SMS_DELIVER tPDU_SMS_DELIVER = new TPDU_SMS_DELIVER();
        tPDU_SMS_DELIVER.msgType = 0;
        tPDU_SMS_DELIVER.mms = false;
        tPDU_SMS_DELIVER.rp = false;
        tPDU_SMS_DELIVER.udhi = false;
        tPDU_SMS_DELIVER.sri = false;
        if (bl.booleanValue()) {
            tPDU_SMS_DELIVER.ported = bl;
            tPDU_SMS_DELIVER.port = Short.parseShort(this.txtMobileTerminatePort.getText());
        } else {
            tPDU_SMS_DELIVER.ported = false;
            tPDU_SMS_DELIVER.port = (short)-1;
        }
        SmsAddressInfo smsAddressInfo2 = new SmsAddressInfo();
        smsAddressInfo2.diallingNum = string.toCharArray();
        smsAddressInfo2.dialnumlen = smsAddressInfo2.diallingNum.length;
        tPDU_SMS_DELIVER.orgAddr = smsAddressInfo2;
        tPDU_SMS_DELIVER.pId = 0;
        tPDU_SMS_DELIVER.scts = tmDateTime;
        tPDU_SMS_DELIVER.dcs = tapiNetTextCodingScheme;
        tPDU_SMS_DELIVER.udl = 0;
        ArrayList<SMS_USERDATA> arrayList = this.getUserData(this.txtMobileTerminateMessageText.getText());
        if (arrayList.size() > 1 || tPDU_SMS_DELIVER.ported) {
            tPDU_SMS_DELIVER.udhi = true;
        }
        Iterator<SMS_USERDATA> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            SMS_USERDATA sMS_USERDATA;
            tPDU_SMS_DELIVER.userData = sMS_USERDATA = iterator.next();
            int n3 = encodeMsg.EncodeSmsDeliverTpdu(smsAddressInfo, tPDU_SMS_DELIVER, cArray, n, n2);
            final byte[] byArray = this.convertToByte(cArray, n3);
            G04A01 g04A01 = new G04A01(){

                @Override
                protected void makeBody() {
                    StructureGA structureGA = this.getBody();
                    structureGA.addByteArrayItem("DATA", byArray.length);
                }
            };
            g04A01.intialize();
            StructureGA structureGA = g04A01.getBody();
            structureGA.setByteArray("DATA", byArray);
            try {
                this.send(g04A01);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void createSendSection() {
        FormUtil.createLabel((Composite)this.parent, (String)"Send SMS Message", (Font)TelephonyConstants.TITLE_FONT, (Color)TelephonyConstants.TITLE_COLOR);
        Composite composite = FormUtil.createComposite((Composite)this.parent);
        GridData gridData = FormUtil.createHGD((int)474, (int)1, (int)0, (int)0);
        composite.setLayoutData((Object)gridData);
        FormUtil.createLabel((Composite)this.parent, (String)"Address Selector", (int)0);
        Composite composite2 = FormUtil.createComposite((Composite)this.parent, (int)3);
        GridData gridData2 = new GridData(4, 4, false, true);
        composite2.setLayoutData((Object)gridData2);
        FormUtil.createLabel((Composite)composite2, (String)"Originating Address :");
        this.cmbMobileTerminateOriginatingAddress = FormUtil.createEditableCombo((Composite)composite2, (int)2);
        FormUtil.addComboItem((Combo)this.cmbMobileTerminateOriginatingAddress, (Object[])this.ORIGINATING_ADDRESS_LIST);
        FormUtil.createLabel((Composite)composite2, (String)"Message : ");
        this.txtMobileTerminateMessageText = FormUtil.createText((Composite)composite2, (String)"");
        this.txtMobileTerminateMessageText.setTextLimit(80);
        this.butMobileTerminateSendMsg = FormUtil.createECPButton((Composite)composite2, (String)"Send Msg", (int)8);
        gridData2 = new GridData(4, 4, false, true);
        gridData2.widthHint = 100;
        this.butMobileTerminateSendMsg.setLayoutData((Object)gridData2);
        this.butMobileTerminateSendMsg.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TelephonySMSDisplay.this.sendMsg(TelephonySMSDisplay.this.butMobileTerminatePort.getSelection());
            }
        });
        FormUtil.createLabel((Composite)composite2, (String)"");
        Composite composite3 = FormUtil.createComposite((Composite)composite2, (int)3);
        this.lblMobileTerminatePortBlank = FormUtil.createLabel((Composite)composite3, (String)"");
        gridData2 = new GridData(4, 4, false, true);
        this.lblMobileTerminatePortBlank.setLayoutData((Object)gridData2);
        this.butMobileTerminatePort = FormUtil.createECPButton((Composite)composite3, (String)"Port", (int)32);
        this.butMobileTerminatePort.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (TelephonySMSDisplay.this.butMobileTerminatePort.getSelection()) {
                    TelephonySMSDisplay.this.txtMobileTerminatePort.setEnabled(true);
                } else {
                    TelephonySMSDisplay.this.txtMobileTerminatePort.setEnabled(false);
                }
            }
        });
        this.txtMobileTerminatePort = FormUtil.createText((Composite)composite3, (String)"");
        this.txtMobileTerminatePort.setTextLimit(5);
        gridData2 = new GridData(4, 4, false, true);
        gridData2.widthHint = 40;
        this.txtMobileTerminatePort.setLayoutData((Object)gridData2);
        this.txtMobileTerminatePort.setEnabled(false);
        this.txtMobileTerminatePort.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent keyEvent) {
                block4: {
                    if (keyEvent.character == '-') {
                        TelephonySMSDisplay.this.showDialog("You cannot use minus value.");
                        TelephonySMSDisplay.this.txtMobileTerminatePort.setText("");
                        return;
                    }
                    try {
                        if (Integer.parseInt(TelephonySMSDisplay.this.txtMobileTerminatePort.getText()) > 65535) {
                            TelephonySMSDisplay.this.showDialog("Port range : 0~65535");
                            TelephonySMSDisplay.this.txtMobileTerminatePort.setText("");
                            return;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (TelephonySMSDisplay.this.txtMobileTerminatePort.getText().equals("")) break block4;
                        TelephonySMSDisplay.this.showDialog("Please input only number");
                        TelephonySMSDisplay.this.txtMobileTerminatePort.setText("");
                        return;
                    }
                }
            }

            public void keyPressed(KeyEvent keyEvent) {
            }
        });
    }

    private void createReceiveSection() {
        FormUtil.createLabel((Composite)this.parent, (String)"Receive SMS/MMS Message", (Font)TelephonyConstants.TITLE_FONT, (Color)TelephonyConstants.TITLE_COLOR);
        Composite composite = FormUtil.createComposite((Composite)this.parent);
        GridData gridData = FormUtil.createHGD((int)474, (int)1, (int)0, (int)0);
        composite.setLayoutData((Object)gridData);
        Composite composite2 = FormUtil.createComposite((Composite)this.parent, (int)3);
        GridData gridData2 = new GridData(4, 4, false, true);
        composite2.setLayoutData((Object)gridData2);
        FormUtil.createLabel((Composite)composite2, (String)"Sending MMS Status Value :");
        this.cmbSentStatusMMSSendingStatus = FormUtil.createCombo((Composite)composite2, (int)12);
        gridData2 = new GridData(4, 4, true, true);
        this.cmbSentStatusMMSSendingStatus.setLayoutData((Object)gridData2);
        FormUtil.addComboItem((Combo)this.cmbSentStatusMMSSendingStatus, (Object[])this.SENDING_STATUS_VALUE_MMS);
        this.butSentStatusSet = FormUtil.createECPButton((Composite)composite2, (String)"Set", (int)8);
        gridData2 = new GridData(4, 4, false, true);
        gridData2.widthHint = 42;
        this.butSentStatusSet.setLayoutData((Object)gridData2);
        this.butSentStatusSet.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TelephonySMSDisplay.this.sendstatusMMS();
            }
        });
        FormUtil.createLabel((Composite)composite2, (String)"Sending SMS Status Value :");
        this.cmbSentStatusSendingStatus = FormUtil.createCombo((Composite)composite2, (int)12);
        gridData2 = new GridData(4, 4, true, true);
        this.cmbSentStatusSendingStatus.setLayoutData((Object)gridData2);
        FormUtil.addComboItem((Combo)this.cmbSentStatusSendingStatus, (Object[])this.SENDING_STATUS_VALUE_SMS);
        this.butSentStatusSet = FormUtil.createECPButton((Composite)composite2, (String)"Set", (int)8);
        gridData2 = new GridData(4, 4, false, true);
        gridData2.widthHint = 42;
        this.butSentStatusSet.setLayoutData((Object)gridData2);
        this.butSentStatusSet.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TelephonySMSDisplay.this.sendstatus();
            }
        });
        Composite composite3 = FormUtil.createComposite((Composite)this.parent, (int)2);
        gridData2 = new GridData(4, 4, false, true);
        composite3.setLayoutData((Object)gridData2);
        composite3.setBackgroundMode(1);
        FormUtil.createLabel((Composite)composite3, (String)"Call Number : ");
        this.txtMobileTerminateReceivedNumber = FormUtil.createLabel((Composite)composite3, (String)"");
        FormUtil.setWidth((Control)this.txtMobileTerminateReceivedNumber, (int)350);
        this.lblMobileTerminateReceivedMessage = FormUtil.createLabel((Composite)composite3, (String)"Message : ");
        GridData gridData3 = new GridData(4, 1, false, true);
        gridData3.horizontalIndent = 10;
        gridData3.verticalIndent = 7;
        this.lblMobileTerminateReceivedMessage.setLayoutData((Object)gridData3);
        this.txtMobileTerminateReceivedMessage = FormUtil.createText((Composite)composite3, (int)91);
        this.txtMobileTerminateReceivedMessage.setText("\n\n\n\n\n");
        GridData gridData4 = new GridData(4, 2, false, true);
        gridData4.verticalIndent = 7;
        this.txtMobileTerminateReceivedMessage.setLayoutData((Object)gridData4);
    }

    public boolean send(AbstractGA abstractGA) {
        return MessageSender.getInstance().sendInjectorReq("telephony", abstractGA.getGroupID(), abstractGA.getActionID(), abstractGA.makePacket());
    }

    protected int get_error_code_from_ui_index(int n) {
        if (n <= 17) {
            return n;
        }
        switch (n) {
            case 18: {
                return 32769;
            }
            case 19: {
                return 32776;
            }
            case 20: {
                return 32778;
            }
            case 21: {
                return 32789;
            }
            case 22: {
                return 32790;
            }
            case 23: {
                return 32795;
            }
            case 24: {
                return 32796;
            }
            case 25: {
                return 32797;
            }
            case 26: {
                return 32798;
            }
            case 27: {
                return 32806;
            }
            case 28: {
                return 32809;
            }
            case 29: {
                return 32810;
            }
            case 30: {
                return 32815;
            }
            case 31: {
                return 32818;
            }
            case 32: {
                return 32837;
            }
            case 33: {
                return 32849;
            }
            case 34: {
                return 32864;
            }
            case 35: {
                return 32865;
            }
            case 36: {
                return 32866;
            }
            case 37: {
                return 32867;
            }
            case 38: {
                return 32879;
            }
            case 39: {
                return 32895;
            }
            case 40: {
                return 33041;
            }
            case 41: {
                return 33062;
            }
            case 42: {
                return 33068;
            }
        }
        return 0;
    }

    protected void sendstatus() {
        int n = this.get_error_code_from_ui_index(this.cmbSentStatusSendingStatus.getSelectionIndex());
        int n2 = n & 0xFF;
        int n3 = n >> 8 & 0xFF;
        G04A05 g04A05 = new G04A05();
        g04A05.intialize();
        StructureGA structureGA = g04A05.getBody();
        structureGA.setInt("DATA1", n2);
        structureGA.setInt("DATA2", n3);
        try {
            this.send(g04A05);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void sendstatusMMS() {
        int n = this.get_error_code_from_ui_index(this.cmbSentStatusMMSSendingStatus.getSelectionIndex());
        int n2 = n + 10 & 0xFF;
        int n3 = n + 10 >> 8 & 0xFF;
        G04A05 g04A05 = new G04A05();
        g04A05.intialize();
        StructureGA structureGA = g04A05.getBody();
        structureGA.setInt("DATA1", n2);
        structureGA.setInt("DATA2", n3);
        try {
            this.send(g04A05);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void sendDeliveryReport() {
        char[] cArray = new char[500];
        int n = 0;
        int n2 = 240;
        EncodeMsg encodeMsg = new EncodeMsg();
        SmsAddressInfo smsAddressInfo = new SmsAddressInfo();
        smsAddressInfo.diallingNum = this.SMSC_NUM;
        smsAddressInfo.dialnumlen = smsAddressInfo.diallingNum.length;
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
        String string = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("MM");
        String string2 = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("dd");
        String string3 = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("HH");
        String string4 = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("mm");
        String string5 = simpleDateFormat.format(date);
        simpleDateFormat = new SimpleDateFormat("ss");
        String string6 = simpleDateFormat.format(date);
        TmDateTime tmDateTime = new TmDateTime();
        tmDateTime.year = Integer.parseInt(string.trim());
        tmDateTime.month = Integer.parseInt(string2.trim());
        tmDateTime.day = Integer.parseInt(string3.trim());
        tmDateTime.hour = Integer.parseInt(string4.trim());
        tmDateTime.minute = Integer.parseInt(string5.trim());
        tmDateTime.second = Integer.parseInt(string6.trim());
        TapiNetTextCodingScheme tapiNetTextCodingScheme = new TapiNetTextCodingScheme();
        tapiNetTextCodingScheme.bCompressed = false;
        tapiNetTextCodingScheme.bMsgClassSet = false;
        tapiNetTextCodingScheme.bMsgIndActive = false;
        tapiNetTextCodingScheme.codingGroupType = 0;
        tapiNetTextCodingScheme.waitingType = 0;
        tapiNetTextCodingScheme.alphabetType = 2;
        tapiNetTextCodingScheme.classType = 0;
        tapiNetTextCodingScheme.codingGroup = 0;
        tapiNetTextCodingScheme.code = 0;
        TPDU_SMS_DELIVER tPDU_SMS_DELIVER = new TPDU_SMS_DELIVER();
        tPDU_SMS_DELIVER.msgType = 0;
        tPDU_SMS_DELIVER.mms = false;
        tPDU_SMS_DELIVER.rp = false;
        tPDU_SMS_DELIVER.udhi = false;
        tPDU_SMS_DELIVER.sri = false;
        SmsAddressInfo smsAddressInfo2 = new SmsAddressInfo();
        String string7 = DecodeMsg.deliveryReportNum_set.iterator().next();
        DecodeMsg.deliveryReportNum_set.remove(string7);
        smsAddressInfo2.diallingNum = String.format(string7, new Object[0]).toCharArray();
        smsAddressInfo2.dialnumlen = smsAddressInfo2.diallingNum.length;
        tPDU_SMS_DELIVER.orgAddr = smsAddressInfo2;
        tPDU_SMS_DELIVER.pId = 0;
        tPDU_SMS_DELIVER.scts = tmDateTime;
        tPDU_SMS_DELIVER.dcs = tapiNetTextCodingScheme;
        tPDU_SMS_DELIVER.udl = 0;
        String string8 = "Message delivered.";
        SMS_USERDATA sMS_USERDATA = new SMS_USERDATA();
        try {
            sMS_USERDATA.data = string8.getBytes("ISO-10646-UCS-2");
            sMS_USERDATA.length = sMS_USERDATA.data.length;
            sMS_USERDATA.headerCnt = 0;
            sMS_USERDATA.setSMSUDH('\u0000', (short)0, '\u0002', '\u0001');
            tPDU_SMS_DELIVER.userData = sMS_USERDATA;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        int n3 = encodeMsg.EncodeSmsDeliverTpdu(smsAddressInfo, tPDU_SMS_DELIVER, cArray, n, n2);
        final byte[] byArray = this.convertToByte(cArray, n3);
        G04A01 g04A01 = new G04A01(){

            @Override
            protected void makeBody() {
                StructureGA structureGA = this.getBody();
                structureGA.addByteArrayItem("DATA", byArray.length);
            }
        };
        g04A01.intialize();
        StructureGA structureGA = g04A01.getBody();
        structureGA.setByteArray("DATA", byArray);
        try {
            this.MatrixTime(1200);
            this.send(g04A01);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void MatrixTime(int n) {
        long l = System.currentTimeMillis();
        long l2 = 0L;
        while (l2 - l < (long)n) {
            l2 = System.currentTimeMillis();
        }
    }

    private char[] convertToChar(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2];
        int n3 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (i < n) continue;
            cArray[n3++] = (char)byArray[i];
            if (n3 >= n2) break;
        }
        return cArray;
    }

    public class SimDBReceiver
    extends AbstractInjectorReceiver {
        @Override
        public void run(AbstractGA abstractGA) {
            StructureGA structureGA = abstractGA.getBody();
            TPDU_SMS_SUBMIT tPDU_SMS_SUBMIT = new TPDU_SMS_SUBMIT();
            byte[] byArray = structureGA.getByteArray("DATA");
            char[] cArray = TelephonySMSDisplay.this.convertToChar(byArray, 3, byArray.length - 3);
            DecodeMsg decodeMsg = new DecodeMsg();
            decodeMsg.DecodeSmsSubmitTpdu(tPDU_SMS_SUBMIT, 500, cArray);
            TelephonySMSDisplay.this.txtMobileTerminateReceivedNumber.setText(String.valueOf(tPDU_SMS_SUBMIT.destAddr.diallingNum).trim());
            if (DecodeMsg.relayedsms) {
                TelephonySMSDisplay.this.txtMobileTerminateReceivedMessage.setText(String.valueOf(DecodeMsg.smsbuffer).trim());
                if (--DecodeMsg.relay_cnt == 0) {
                    for (int i = 0; i < DecodeMsg.smsbuffer_index; ++i) {
                        DecodeMsg.smsbuffer[i] = '\u0000';
                    }
                    DecodeMsg.smsbuffer_index = 0;
                    DecodeMsg.relayedsms = false;
                }
            } else {
                TelephonySMSDisplay.this.txtMobileTerminateReceivedMessage.setText(String.valueOf(tPDU_SMS_SUBMIT.userData).trim());
            }
            if (DecodeMsg.deliveryReport) {
                if (DecodeMsg.relayedsms) {
                    if (tPDU_SMS_SUBMIT.udl < 255) {
                        TelephonySMSDisplay.this.sendDeliveryReport();
                    }
                } else {
                    TelephonySMSDisplay.this.sendDeliveryReport();
                }
            }
        }

        @Override
        public AbstractGA createTransferObject() {
            return new G04A01();
        }
    }
}

