/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.location;

import com.google.protobuf.GeneratedMessage;
import java.util.logging.Logger;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.tizen.ecp.location.LocationLogPage;
import org.tizen.ecp.location.LocationManualPage;
import org.tizen.ecp.location.LocationMapPage;
import org.tizen.ecp.location.LocationSheet;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.resources.ColorResources;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.ECPSubView;

public class LocationDisplay
extends ECPSubView {
    private static Logger logger = LogUtil.getECPLogger(LocationDisplay.class).getLogger();
    private Composite m_comp;
    private LocationSheet m_sheet = new LocationSheet();
    private LocationMapPage pageMap;
    private LocationManualPage pageManual;
    private LocationLogPage pageLog;

    public LocationDisplay() {
        this.title = "Location";
        this.pageHeight = 740;
        this.useTimer = true;
    }

    public void createView(Composite composite) {
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 10;
        this.m_comp = new Composite(composite, 0);
        this.m_comp.setLayout((Layout)gridLayout);
        this.m_comp.setLayoutData((Object)new GridData(768));
        this.m_comp.setBackground(ColorResources.CONTENTS_BG.getColor());
        this.pageMap = new LocationMapPage();
        this.pageMap.createView(this.m_comp);
        this.m_sheet.AddPage(this.pageMap);
        this.pageManual = new LocationManualPage();
        this.pageManual.createView(this.m_comp);
        this.m_sheet.AddPage(this.pageManual);
        this.pageLog = new LocationLogPage();
        this.pageLog.createView(this.m_comp);
        this.m_sheet.AddPage(this.pageLog);
    }

    protected void initializeWidget() {
    }

    public boolean Create() {
        this.createPage();
        EventMgr.getInstance().AddLsn("sensor", (ILsn)this);
        return true;
    }

    public void OnTimerMessageExpired() {
        MessageSender.getInstance().sendInjectorReq("sensor", 15, 120);
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
        Ecs.InjectorNtf injectorNtf;
        long l;
        if (generatedMessage instanceof Ecs.InjectorNtf && 120L == (l = (long)(injectorNtf = (Ecs.InjectorNtf)generatedMessage).getAction())) {
            String string = injectorNtf.getData().toStringUtf8();
            Enum enum_ = null;
            if (string != null) {
                String[] stringArray = string.split(",");
                for (LocationEventMode locationEventMode : LocationEventMode.values()) {
                    if (!locationEventMode.toString().equals(stringArray[0])) continue;
                    enum_ = locationEventMode;
                    break;
                }
                if (enum_ != null) {
                    switch (1.$SwitchMap$org$tizen$ecp$location$LocationDisplay$LocationEventMode[enum_.ordinal()]) {
                        case 1: {
                            logger.info("STOPMODE");
                            this.pageManual.setLocation(null, null, null, null);
                            break;
                        }
                        case 2: {
                            logger.info("LOGMODE");
                            this.pageManual.setLocation(null, null, null, null);
                            break;
                        }
                        case 3: {
                            logger.info("MANUALMODE");
                            this.pageManual.setLocation(stringArray[1], stringArray[2], stringArray[3], stringArray[4]);
                            break;
                        }
                    }
                } else {
                    logger.severe("cannot get mode.");
                }
            } else {
                logger.severe("Failed to get value from emulator.");
            }
        }
    }

    public static enum LocationEventMode {
        NONE(-1, "-1", "None"),
        STOPMODE(0, "0", "Stop"),
        LOGMODE(1, "1", "Log"),
        MANUALMODE(2, "2", "Manual");

        int mode;
        String strMode;
        String modeName;

        private LocationEventMode(int n2, String string2, String string3) {
            this.mode = n2;
            this.strMode = string2;
            this.modeName = string3;
        }

        public int getMode() {
            return this.mode;
        }

        public String toString() {
            return this.strMode;
        }

        public String getModeName() {
            return this.modeName;
        }
    }
}

