/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.nfc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.nfc.MimeTypeList;
import org.tizen.ecp.nfc.NDEFFormat;
import org.tizen.ecp.nfc.NDEFRecord;
import org.tizen.ecp.nfc.NFCErrorString;
import org.tizen.ecp.nfc.NFCEventException;
import org.tizen.ecp.nfc.NFCEventType;
import org.tizen.ecp.nfc.NFCHelpProcess;
import org.tizen.ecp.nfc.NFCTagType;
import org.tizen.ecp.sdb.IShellOutputReceiver;
import org.tizen.ecp.sdb.MultiLineReceiver;
import org.tizen.ecp.sdb.SDBCommandRejectedException;
import org.tizen.ecp.sdb.SDBHelperUtil;
import org.tizen.ecp.sdb.SDBNotExistException;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.LogUtil;

public class NFCEventInjector {
    static NFCEventInjector instance;
    private String shellCmd;
    private ArrayList<NDEFRecord> recordList = new ArrayList();
    private ArrayList<NDEFRecord> attachedList = new ArrayList();
    private static final int MaxRecordListLength = 4096;
    private static final int MaxRecordCount = 5;
    private static NFCEventType currentEventType;
    private static Logger logger;
    private int recordListLength = 0;
    private String shellResult = null;

    public NFCEventType getNfcStatus(String string) throws NFCEventException {
        if (!this.avaliableNfc()) {
            throw new NFCEventException(NFCErrorString.NFCIsDisable);
        }
        NFCEventType nFCEventType = null;
        if (string != null) {
            String[] stringArray = string.split(":");
            int n = Integer.valueOf(stringArray[0]);
            for (NFCEventType nFCEventType2 : NFCEventType.values()) {
                if (n != nFCEventType2.getType()) continue;
                currentEventType = nFCEventType = nFCEventType2;
                break;
            }
            this.attachedList.clear();
            if (nFCEventType != null && (nFCEventType == NFCEventType.TAG_DISCOVERED || nFCEventType == NFCEventType.P2P_SEND)) {
                this.makeNDEFMessage(stringArray[1]);
            }
        }
        return nFCEventType == null ? NFCEventType.NONE : nFCEventType;
    }

    public ArrayList<NDEFRecord> getAttachedRecordList() {
        return this.attachedList;
    }

    public NFCEventType getCurrentEventType() {
        return currentEventType;
    }

    private int checkRecordListMaxLength() {
        int n = 0;
        for (NDEFRecord nDEFRecord : this.recordList) {
            n += 1 + nDEFRecord.toString().length() + 4;
        }
        if (n > 4096) {
            return -1;
        }
        return n;
    }

    public ArrayList<NDEFRecord> getRecordList() {
        return this.recordList;
    }

    public int getRecordListLength() {
        return this.recordListLength;
    }

    public void addNDEFRecord(NDEFRecord nDEFRecord) throws NFCEventException {
        if (nDEFRecord == null) {
            throw new NFCEventException(NFCErrorString.NullRecord);
        }
        if (this.recordList.size() >= 5) {
            throw new NFCEventException(NFCErrorString.RecordCountIsMax);
        }
        this.checkRecordFormat(nDEFRecord);
        this.recordList.add(nDEFRecord);
        int n = this.checkRecordListMaxLength();
        if (n == -1) {
            this.recordList.remove(nDEFRecord);
            throw new NFCEventException(NFCErrorString.MessageLenIsMax);
        }
        this.recordListLength = n;
    }

    public void removeNDEFRecord(int n) throws NFCEventException {
        try {
            this.recordList.remove(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NFCEventException(NFCErrorString.FailedRemoveRecord);
        }
        this.checkRecordListMaxLength();
    }

    private void checkInvaildCharacters(String string) throws NFCEventException {
        for (char c : string.toCharArray()) {
            if (c == '\n') {
                throw new NFCEventException(NFCErrorString.InvalidCharNewLine);
            }
            if (c == ',') {
                throw new NFCEventException(NFCErrorString.InvalidChar);
            }
            if (c < '\u0080') continue;
            throw new NFCEventException(NFCErrorString.InvalidCharAscii);
        }
    }

    private boolean checktFileSize(String string) throws NFCEventException {
        int n;
        boolean bl = false;
        this.shellCmd = "du " + string;
        MultiLineReceiver multiLineReceiver = new MultiLineReceiver(){

            public void processNewLines(String[] stringArray) {
                NFCEventInjector.this.shellResult = stringArray[0];
            }
        };
        try {
            SDBHelperUtil.getInstance().executeShellCommand(this.shellCmd, (IShellOutputReceiver)multiLineReceiver);
        }
        catch (SDBNotExistException sDBNotExistException) {
            logger.info("SDBNotExistException: " + sDBNotExistException.getMessage());
            SDBHelperUtil.getInstance().closeMultiLineReceiver(multiLineReceiver);
            return bl;
        }
        catch (SDBCommandRejectedException sDBCommandRejectedException) {
            logger.info("SDBCommandRejectedException: " + sDBCommandRejectedException.getMessage());
            SDBHelperUtil.getInstance().closeMultiLineReceiver(multiLineReceiver);
            this.errorCheckVconf("Emulator is not ready.\nPlease retry when the emulator is ready.");
            return bl;
        }
        catch (TimeoutException timeoutException) {
            logger.info("TimeoutException: " + timeoutException.getMessage());
            SDBHelperUtil.getInstance().closeMultiLineReceiver(multiLineReceiver);
            this.errorCheckVconf("SDB: " + timeoutException.getMessage());
            return bl;
        }
        catch (IOException iOException) {
            logger.info("IOException: " + iOException.getMessage());
            SDBHelperUtil.getInstance().closeMultiLineReceiver(multiLineReceiver);
            this.errorCheckVconf("SDB: " + iOException.getMessage());
            return bl;
        }
        if (this.shellResult != null && (n = this.shellResult.indexOf(9)) != -1) {
            this.shellResult = this.shellResult.substring(0, n);
            if (Integer.valueOf(this.shellResult) <= 10) {
                bl = true;
            }
        }
        SDBHelperUtil.getInstance().closeMultiLineReceiver(multiLineReceiver);
        return bl;
    }

    private String checkFileTpye(String string) {
        int n = string.lastIndexOf(46);
        String string2 = null;
        if (n != -1) {
            String string3 = string.substring(n + 1);
            MimeTypeList mimeTypeList = MimeTypeList.getInstance();
            string2 = mimeTypeList.findMimeType(string3);
        }
        return string2;
    }

    private void checkRecordFormat(NDEFRecord nDEFRecord) throws NFCEventException {
        this.checkInvaildCharacters(nDEFRecord.getId());
        this.checkInvaildCharacters(nDEFRecord.getTypeName());
        this.checkInvaildCharacters(nDEFRecord.getPayload());
        if (nDEFRecord.getNdefFormat() == NDEFFormat.WELL_KNOWN) {
            if (!nDEFRecord.getTypeName().equals("U") && !nDEFRecord.getTypeName().equals("T")) {
                throw new NFCEventException(NFCErrorString.InvalidWellKnownType);
            }
        } else if (nDEFRecord.getNdefFormat() == NDEFFormat.MEDIA) {
            if (this.checkFileTpye(nDEFRecord.getPayload()) == null) {
                throw new NFCEventException(NFCErrorString.NotMimeType);
            }
            if (!this.checktFileSize(nDEFRecord.getPayload())) {
                throw new NFCEventException(NFCErrorString.BigSizeFile);
            }
        }
    }

    public void makeNDEFMessage(String string) {
        if (string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        String[] stringArray = string.split(",");
        int n = Integer.valueOf(stringArray[1]);
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray[2 + 4 * i];
            NDEFFormat nDEFFormat = null;
            for (NDEFFormat nDEFFormat2 : NDEFFormat.values()) {
                if (!nDEFFormat2.getFormat().equals(string2)) continue;
                nDEFFormat = nDEFFormat2;
                break;
            }
            if (nDEFFormat == null) continue;
            this.attachedList.add(new NDEFRecord(nDEFFormat, stringArray[3 + 4 * i], stringArray[4 + 4 * i], stringArray[5 + 4 * i]));
        }
    }

    private void errorCheckVconf(String string) {
        OutputUtil.printError((String)(NFCErrorString.CheckVconfException + string));
    }

    private boolean avaliableNfc() {
        boolean bl = false;
        this.shellCmd = "vconftool get db/nfc/enable";
        MultiLineReceiver multiLineReceiver = new MultiLineReceiver(){

            public void processNewLines(String[] stringArray) {
                NFCEventInjector.this.shellResult = stringArray[0];
            }
        };
        try {
            SDBHelperUtil.getInstance().executeShellRootCommand(this.shellCmd, (IShellOutputReceiver)multiLineReceiver);
        }
        catch (SDBNotExistException sDBNotExistException) {
            logger.info("SDBNotExistException: " + sDBNotExistException.getMessage());
            SDBHelperUtil.getInstance().closeMultiLineReceiver(multiLineReceiver);
            return bl;
        }
        catch (SDBCommandRejectedException sDBCommandRejectedException) {
            logger.info("SDBCommandRejectedException: " + sDBCommandRejectedException.getMessage());
            SDBHelperUtil.getInstance().closeMultiLineReceiver(multiLineReceiver);
            this.errorCheckVconf("Emulator is not ready.\nPlease retry when the emulator is ready.");
            return bl;
        }
        catch (TimeoutException timeoutException) {
            logger.info("TimeoutException: " + timeoutException.getMessage());
            SDBHelperUtil.getInstance().closeMultiLineReceiver(multiLineReceiver);
            this.errorCheckVconf("SDB: " + timeoutException.getMessage());
            return bl;
        }
        catch (IOException iOException) {
            logger.info("IOException: " + iOException.getMessage());
            SDBHelperUtil.getInstance().closeMultiLineReceiver(multiLineReceiver);
            this.errorCheckVconf("SDB: " + iOException.getMessage());
            return bl;
        }
        logger.info("shellResult: " + this.shellResult);
        if (this.shellResult != null) {
            if (this.shellResult.indexOf(49) != -1) {
                bl = true;
            } else {
                OutputUtil.printError((String)NFCErrorString.NFCIsDisable);
            }
        }
        SDBHelperUtil.getInstance().closeMultiLineReceiver(multiLineReceiver);
        return bl;
    }

    public NFCTagType getTagType(String string) throws NFCEventException {
        NFCTagType nFCTagType = null;
        for (NFCTagType nFCTagType2 : NFCTagType.values()) {
            if (!nFCTagType2.getShortName().equals(string)) continue;
            nFCTagType = nFCTagType2;
            break;
        }
        if (nFCTagType == null) {
            throw new NFCEventException(NFCErrorString.WrongTagType);
        }
        return nFCTagType;
    }

    public boolean sendTagDiscovered(NFCTagType nFCTagType) throws NFCEventException {
        if (currentEventType == NFCEventType.TAG_DISCOVERED) {
            throw new NFCEventException(NFCErrorString.TagAttachState);
        }
        if (currentEventType == NFCEventType.P2P_DISCOVERED || currentEventType == NFCEventType.P2P_SEND) {
            throw new NFCEventException(NFCErrorString.P2PAttachState);
        }
        if (!this.avaliableNfc()) {
            throw new NFCEventException(NFCErrorString.NFCIsDisable);
        }
        if (this.recordList.size() == 0) {
            throw new NFCEventException(NFCErrorString.RecordCountIsZero);
        }
        if (nFCTagType == null || nFCTagType == NFCTagType.P2P) {
            throw new NFCEventException(NFCErrorString.WrongTagType);
        }
        String string = NFCEventType.TAG_DISCOVERED.getType() + ":" + nFCTagType.getType() + "," + this.recordList.size();
        for (NDEFRecord nDEFRecord : this.recordList) {
            string = string + "," + nDEFRecord.getMessage();
        }
        this.send(string + "\n");
        currentEventType = NFCEventType.TAG_DISCOVERED;
        return true;
    }

    public boolean sendTagDetached() throws NFCEventException {
        if (currentEventType != NFCEventType.TAG_DISCOVERED) {
            throw new NFCEventException(NFCErrorString.CanNotDettach);
        }
        if (!this.avaliableNfc()) {
            throw new NFCEventException(NFCErrorString.NFCIsDisable);
        }
        this.send(NFCEventType.TAG_DETACHED.getType() + ":" + "\n");
        currentEventType = NFCEventType.TAG_DETACHED;
        return true;
    }

    public boolean sendP2PDiscovered() throws NFCEventException {
        if (currentEventType == NFCEventType.TAG_DISCOVERED) {
            throw new NFCEventException(NFCErrorString.TagAttachState);
        }
        if (currentEventType == NFCEventType.P2P_DISCOVERED || currentEventType == NFCEventType.P2P_SEND) {
            throw new NFCEventException(NFCErrorString.P2PAttachState);
        }
        if (!this.avaliableNfc()) {
            throw new NFCEventException(NFCErrorString.NFCIsDisable);
        }
        this.send(NFCEventType.P2P_DISCOVERED.getType() + ":" + "\n");
        currentEventType = NFCEventType.P2P_DISCOVERED;
        return true;
    }

    public boolean sendP2PSend() throws NFCEventException {
        if (currentEventType != NFCEventType.P2P_DISCOVERED && currentEventType != NFCEventType.P2P_SEND) {
            throw new NFCEventException(NFCErrorString.CanNotSend);
        }
        if (!this.avaliableNfc()) {
            throw new NFCEventException(NFCErrorString.NFCIsDisable);
        }
        if (this.recordList.size() == 0) {
            throw new NFCEventException(NFCErrorString.RecordCountIsZero);
        }
        String string = NFCEventType.P2P_SEND.getType() + ":" + NFCTagType.P2P.getType() + "," + this.recordList.size();
        for (NDEFRecord nDEFRecord : this.recordList) {
            string = string + "," + nDEFRecord.getMessage();
        }
        this.send(string + "\n");
        currentEventType = NFCEventType.P2P_SEND;
        return true;
    }

    public boolean sendP2PDetached() throws NFCEventException {
        if (currentEventType != NFCEventType.P2P_DISCOVERED && currentEventType != NFCEventType.P2P_SEND) {
            throw new NFCEventException(NFCErrorString.CanNotDettach);
        }
        if (!this.avaliableNfc()) {
            throw new NFCEventException(NFCErrorString.NFCIsDisable);
        }
        this.send(NFCEventType.P2P_DETACHED.getType() + ":" + "\n");
        currentEventType = NFCEventType.P2P_DETACHED;
        return true;
    }

    public void send(String string) {
        MessageSender.getInstance().sendDeviceReq("nfc", 0, 0, string);
    }

    static {
        currentEventType = NFCEventType.NONE;
        logger = LogUtil.getECPLogger(NFCHelpProcess.class).getLogger();
    }
}

