/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sensor.accelerometer;

import com.google.protobuf.GeneratedMessage;
import java.util.HashMap;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.resources.ColorResources;
import org.tizen.ecp.resources.PatchImageResources;
import org.tizen.ecp.sensor.accelerometer.AccConstants;
import org.tizen.ecp.sensor.accelerometer.UserAccelDisplay;
import org.tizen.ecp.sensor.geo.MagneticDisplay;
import org.tizen.ecp.sensor.gui.GUIDisplay;
import org.tizen.ecp.sensor.gyro.GyroDisplay;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.FormUtil;
import org.tizen.ecp.views.ECPSubView;
import org.tizen.ecp.widgets.ECPButton;

public class AccelerometerDisplay
extends ECPSubView
implements ILsn {
    private Composite tabArea;
    private StackLayout tabSelection;
    GUIDisplay guiDisplay = new GUIDisplay();
    UserAccelDisplay userAccelDisplay = new UserAccelDisplay(this);
    MagneticDisplay magneticDisplay = new MagneticDisplay(this);
    GyroDisplay gyroDisplay = new GyroDisplay(this);
    private HashMap<String, ECPButton> buttons = new HashMap();
    private HashMap<String, Composite> comp = new HashMap();
    private PaintListener imageSpacingPaint = new PaintListener(){

        public void paintControl(PaintEvent paintEvent) {
            Composite composite = (Composite)paintEvent.widget;
            Rectangle rectangle = composite.getClientArea();
            paintEvent.gc.setForeground(ColorResources.TAB_INTERNAL_BORDER.getColor());
            paintEvent.gc.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width, rectangle.y + rectangle.height - 1);
        }
    };
    private PaintListener backPaint = new PaintListener(){

        public void paintControl(PaintEvent paintEvent) {
            Composite composite = (Composite)paintEvent.widget;
            Rectangle rectangle = composite.getClientArea();
            paintEvent.gc.setForeground(ColorResources.TAB_INTERNAL_BORDER.getColor());
            paintEvent.gc.drawLine(2, rectangle.y + rectangle.height - 1, rectangle.width + 2 - 1, rectangle.y + rectangle.height - 1);
        }
    };
    private PaintListener tabBorderPaint = new PaintListener(){

        public void paintControl(PaintEvent paintEvent) {
            Composite composite = (Composite)paintEvent.widget;
            Rectangle rectangle = composite.getClientArea();
            paintEvent.gc.setForeground(ColorResources.TAB_INTERNAL_BORDER.getColor());
            paintEvent.gc.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.height);
            paintEvent.gc.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
            paintEvent.gc.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width, rectangle.y + rectangle.height - 1);
        }
    };
    private SelectionAdapter tabToggleSelection = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            for (tab_list tab_list2 : tab_list.values()) {
                String string = tab_list2.getTitle();
                ECPButton eCPButton = (ECPButton)AccelerometerDisplay.this.buttons.get(string);
                if (selectionEvent.widget == eCPButton) {
                    eCPButton.setSelection(true);
                    ((AccelerometerDisplay)AccelerometerDisplay.this).tabSelection.topControl = (Control)AccelerometerDisplay.this.comp.get(string);
                    if (string.equals("GUI")) {
                        AccelerometerDisplay.this.guiDisplay.connectPanel();
                    } else {
                        AccelerometerDisplay.this.guiDisplay.disconnectPanel();
                        if (string.equals("Acceleration")) {
                            AccelerometerDisplay.this.send(110);
                        } else if (string.equals("Gyro")) {
                            AccelerometerDisplay.this.send(111);
                        } else if (string.equals("Magnetic")) {
                            AccelerometerDisplay.this.send(112);
                        }
                    }
                    AccelerometerDisplay.this.tabArea.layout();
                    continue;
                }
                eCPButton.setSelection(false);
            }
        }
    };

    public AccelerometerDisplay() {
        this.title = "Sensor";
        this.pageHeight = 500;
        this.useTimer = true;
    }

    public void createView(Composite composite) {
        Composite composite2;
        ECPButton eCPButton;
        tab_list tab_list22;
        FormUtil.createLabel((Composite)composite, (String)"3-Axis Sensors", (Font)AccConstants.TITLE_FONT, (Color)AccConstants.TITLE_COLOR);
        Composite composite3 = FormUtil.createComposite((Composite)composite);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 2;
        composite3.setLayout((Layout)gridLayout);
        Composite composite4 = FormUtil.createComposite((Composite)composite3);
        GridLayout gridLayout2 = new GridLayout(8, false);
        gridLayout2.horizontalSpacing = 0;
        gridLayout2.verticalSpacing = 0;
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 2;
        composite4.setLayout((Layout)gridLayout2);
        composite4.setLayoutData((Object)FormUtil.createHGD());
        composite4.addPaintListener(this.backPaint);
        Image image = PatchImageResources.getSelTabImage((int)90, (int)24);
        Image image2 = PatchImageResources.getNotSelTabImage((int)90, (int)24);
        for (tab_list tab_list22 : tab_list.values()) {
            eCPButton = FormUtil.createECPButton((Composite)composite4, (String)tab_list22.getTitle(), (int)2);
            this.buttons.put(tab_list22.getTitle(), eCPButton);
            eCPButton.setLayoutData((Object)FormUtil.createGD((int)90, (int)24));
            eCPButton.setImages(image2, image2, image, image, null, image);
            eCPButton.addSelectionListener((SelectionListener)this.tabToggleSelection);
            composite2 = FormUtil.createComposite((Composite)composite4);
            composite2.setLayoutData((Object)FormUtil.createGD((int)2, (int)24));
            composite2.addPaintListener(this.imageSpacingPaint);
        }
        this.buttons.get("GUI").setSelection(true);
        this.tabArea = FormUtil.createComposite((Composite)composite3);
        GridLayout gridLayout3 = new GridLayout();
        gridLayout3.horizontalSpacing = 0;
        gridLayout3.verticalSpacing = 0;
        gridLayout3.marginHeight = 1;
        gridLayout3.marginWidth = 2;
        this.tabArea.setLayout((Layout)gridLayout3);
        GridData gridData = FormUtil.createHGD((int)491, (int)419, (int)2, (int)0);
        gridData.verticalAlignment = 1;
        this.tabArea.setLayoutData((Object)gridData);
        this.tabArea.setBackground(ColorResources.WHITE.getColor());
        this.tabSelection = new StackLayout();
        this.tabArea.setLayout((Layout)this.tabSelection);
        Composite composite5 = FormUtil.createComposite((Composite)this.tabArea);
        composite5.setData((Object)new GridData(768));
        composite5.addPaintListener(this.tabBorderPaint);
        this.guiDisplay.createDisplay(composite5);
        this.comp.put("GUI", composite5);
        tab_list22 = FormUtil.createComposite((Composite)this.tabArea);
        tab_list22.setData(new GridData(768));
        tab_list22.addPaintListener(this.tabBorderPaint);
        this.userAccelDisplay.createDisplay((Composite)tab_list22);
        this.comp.put("Acceleration", (Composite)tab_list22);
        eCPButton = FormUtil.createComposite((Composite)this.tabArea);
        eCPButton.setData((Object)new GridData(768));
        eCPButton.addPaintListener(this.tabBorderPaint);
        this.magneticDisplay.createDisplay((Composite)eCPButton);
        this.comp.put("Magnetic", (Composite)eCPButton);
        composite2 = FormUtil.createComposite((Composite)this.tabArea);
        composite2.setData((Object)new GridData(768));
        composite2.addPaintListener(this.tabBorderPaint);
        this.gyroDisplay.createDisplay(composite2);
        this.comp.put("Gyro", composite2);
        this.tabSelection.topControl = composite5;
    }

    protected void initializeWidget() {
    }

    public boolean isTabGUI() {
        return this.tabSelection.topControl == this.comp.get("GUI");
    }

    public boolean Create() {
        EventMgr.getInstance().AddLsn("sensor", (ILsn)this);
        this.createPage();
        return true;
    }

    private void send(int n) {
        MessageSender.getInstance().sendDeviceReq("sensor", 15, n);
    }

    public void OnTimerMessageExpired() {
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
        if (generatedMessage instanceof Ecs.DeviceNtf) {
            Ecs.DeviceNtf deviceNtf = (Ecs.DeviceNtf)generatedMessage;
            long l = deviceNtf.getAction();
            if (110L == l) {
                this.userAccelDisplay.setStatus(deviceNtf.getData().toStringUtf8());
            } else if (112L == l) {
                this.magneticDisplay.setStatus(deviceNtf.getData().toStringUtf8());
            } else if (111L == l) {
                this.gyroDisplay.setStatus(deviceNtf.getData().toStringUtf8());
            } else {
                return;
            }
        }
    }

    private static enum tab_list {
        GUI("GUI"),
        ACCEL("Acceleration"),
        MAGNETIC("Magnetic"),
        GYRO("Gyro");

        private String title;

        private tab_list(String string2) {
            this.title = string2;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

