/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sensor.gui;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Timer;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.tizen.ecp.legacy.InjectorMessage;
import org.tizen.ecp.resources.ColorResources;
import org.tizen.ecp.resources.FontResources;
import org.tizen.ecp.resources.StringResources;
import org.tizen.ecp.sensor.gui.Magnetic;
import org.tizen.ecp.sensor.gui.MobilePanel;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.FormUtil;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.widgets.ECPButton;
import org.tizen.ecp.widgets.ECPSlider;

public class GUIDisplay {
    ECPSlider yawSlider;
    ECPSlider pitchSlider;
    ECPSlider rollSlider;
    Mode mode;
    MobilePanel panel;
    ECPButton buttonXZ;
    ECPButton buttonXY;
    ECPButton buttonMove;
    ECPButton withAxisCheck;
    private Text dataText;
    Timer dataOutputTimer;
    private int yawValue;
    private int pitchValue;
    private int rollValue;
    private int orientation_yaw = 180;
    private int orientation_pitch = 90;
    private int orientation_roll = 180;
    Logger logger = LogUtil.getECPLogger(GUIDisplay.class).getLogger();
    private SelectionAdapter modeListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (selectionEvent.widget == GUIDisplay.this.buttonXZ) {
                GUIDisplay.this.mode = Mode.YAW_PITCH;
            } else if (selectionEvent.widget == GUIDisplay.this.buttonXY) {
                GUIDisplay.this.mode = Mode.ROLL_PITCH;
            } else if (selectionEvent.widget == GUIDisplay.this.buttonMove) {
                GUIDisplay.this.mode = Mode.MOVE;
            }
        }
    };
    private SelectionAdapter axisListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            GUIDisplay.this.panel.is_Axis = GUIDisplay.this.withAxisCheck.getSelection();
        }
    };
    private String oldData;
    private ActionListener timerListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    DecimalFormat decimalFormat = new DecimalFormat("#0.00");
                    Magnetic magnetic = Magnetic.getInstance();
                    double d = 0.0;
                    double d2 = 0.0;
                    double d3 = 0.0;
                    double d4 = 0.0;
                    double d5 = 0.0;
                    double d6 = 0.0;
                    d = GUIDisplay.this.setRange(GUIDisplay.this.panel.read_accelx / GUIDisplay.this.panel.g);
                    d2 = GUIDisplay.this.setRange(GUIDisplay.this.panel.read_accely / GUIDisplay.this.panel.g);
                    d3 = GUIDisplay.this.setRange(GUIDisplay.this.panel.read_accelz / GUIDisplay.this.panel.g);
                    d4 = GUIDisplay.this.setRange(magnetic.getReadCompassX());
                    d5 = GUIDisplay.this.setRange(magnetic.getReadCompassY());
                    d6 = GUIDisplay.this.setRange(magnetic.getReadCompassZ());
                    String string = "Acceleration : " + decimalFormat.format(d) + ", " + decimalFormat.format(d2) + ", " + decimalFormat.format(d3);
                    String string2 = "Magnetic : " + decimalFormat.format(d4) + ", " + decimalFormat.format(d5) + ", " + decimalFormat.format(d6);
                    String string3 = "Gyro : " + decimalFormat.format(GUIDisplay.this.panel.gyroPitch) + ", " + decimalFormat.format(GUIDisplay.this.panel.gyroRoll) + ", " + decimalFormat.format(GUIDisplay.this.panel.gyroYaw);
                    String string4 = string + StringResources.NEW_LINE + string2 + StringResources.NEW_LINE + string3;
                    if (!string4.equals(GUIDisplay.this.oldData)) {
                        GUIDisplay.this.dataText.setText(string4);
                        GUIDisplay.this.oldData = new String(string4);
                    }
                }
            });
        }
    };
    private SelectionAdapter sliderSelection = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (selectionEvent.widget == GUIDisplay.this.pitchSlider) {
                GUIDisplay.this.pitchValue = GUIDisplay.this.pitchSlider.getSelection() - GUIDisplay.this.orientation_pitch;
                GUIDisplay.this.panel.pitchDegree = GUIDisplay.this.pitchValue;
            } else if (selectionEvent.widget == GUIDisplay.this.rollSlider) {
                GUIDisplay.this.rollValue = GUIDisplay.this.rollSlider.getSelection() - GUIDisplay.this.orientation_roll;
                GUIDisplay.this.panel.rollDegree = GUIDisplay.this.rollValue;
            } else if (selectionEvent.widget == GUIDisplay.this.yawSlider) {
                GUIDisplay.this.yawValue = GUIDisplay.this.yawSlider.getSelection() - GUIDisplay.this.orientation_yaw;
                GUIDisplay.this.panel.yawDegree = GUIDisplay.this.yawValue;
            }
            GUIDisplay.this.panel.repaint();
            GUIDisplay.this.sendMessage("1\n", GUIDisplay.this.panel.read_accelx, GUIDisplay.this.panel.read_accely, GUIDisplay.this.panel.read_accelz);
        }
    };
    private MouseAdapter sliderMouseUp = new MouseAdapter(){

        public void mouseUp(MouseEvent mouseEvent) {
            GUIDisplay.this.panel.phone_pos_conv = true;
        }
    };
    private HashMap<String, ECPButton> roWidget = new HashMap();
    private SelectionAdapter rotationSelection = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            int n = 90;
            int n2 = 180;
            int n3 = 180;
            double[] dArray = new double[]{0.0, 0.0, 0.0};
            double[] dArray2 = new double[]{0.0, 0.0, 0.0};
            double[] dArray3 = new double[]{0.0, -1.0, 0.0};
            if (selectionEvent.widget == GUIDisplay.this.getECPButton("Landscape")) {
                n2 = 270;
                dArray[2] = 1.0;
                dArray2[0] = -1.0;
            } else if (selectionEvent.widget == GUIDisplay.this.getECPButton("Reverse Portrait")) {
                n2 = 360;
                dArray[0] = -1.0;
                dArray2[2] = -1.0;
            } else if (selectionEvent.widget == GUIDisplay.this.getECPButton("Reverse Landscape")) {
                n2 = 90;
                dArray[2] = -1.0;
                dArray2[0] = 1.0;
            } else {
                dArray[0] = 1.0;
                dArray2[2] = 1.0;
            }
            GUIDisplay.this.pitchSlider.setSelection(n, true);
            GUIDisplay.this.yawSlider.setSelection(n2, false);
            GUIDisplay.this.rollSlider.setSelection(n3, false);
            GUIDisplay.this.panel.setGyroAxisX(dArray);
            GUIDisplay.this.panel.setGyroAxisY(dArray2);
            GUIDisplay.this.panel.setGyroAxisZ(dArray3);
            GUIDisplay.this.panel.repaint();
            GUIDisplay.this.orientation_pitch = n;
            GUIDisplay.this.orientation_yaw = n2;
            GUIDisplay.this.orientation_roll = n3;
            GUIDisplay.this.initValues();
        }
    };
    private double tmp_accel_x = 0.1;
    private double tmp_accel_y = 0.1;
    private double tmp_accel_z = 0.1;
    private double tmp_gyro_x = 0.1;
    private double tmp_gyro_y = 0.1;
    private double tmp_gyro_z = 0.1;
    private int ACCEL_ADJUST = -100000;
    private double GYRO_ADJUST = 57.142857142857146;
    private double tmp_geo_x = 0.1;
    private double tmp_geo_y = 0.1;
    private double tmp_geo_z = 0.1;
    private double tmp_geo_a = 0.1;
    private double tmp_geo_b = 0.1;
    private double tmp_geo_c = 0.1;
    private double tmp_geo_d = 0.1;

    public void createDisplay(Composite composite) {
        try {
            Composite composite2 = FormUtil.createComposite((Composite)composite, (int)2);
            GridData gridData = FormUtil.createGD();
            composite2.setLayoutData((Object)gridData);
            this.drawMobile(composite2);
            this.drawControl(composite2);
            this.initializeWidget();
            this.panel.run();
            composite.layout(true, true);
        }
        catch (Exception exception) {
            this.logger.log(Level.SEVERE, " mobile panel error occured.", exception);
        }
    }

    private void drawMobile(Composite composite) {
        Composite composite2 = FormUtil.createComposite((Composite)composite);
        GridData gridData = FormUtil.createGD();
        gridData.widthHint = 204;
        composite2.setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite2, 0x1000800);
        this.panel = new MobilePanel(this);
        Frame frame = SWT_AWT.new_Frame((Composite)composite3);
        frame.add(this.panel);
        frame.pack();
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)FormUtil.createHGD((int)200, (int)200));
        this.dataText = new Text(composite2, 0x20000802);
        this.dataText.setFont(FontResources.FONT_9.getFont());
        this.dataText.setLayoutData((Object)FormUtil.createHGD());
        this.dataText.setBackground(ColorResources.TAB_INTERNAL_BORDER.getColor());
        this.dataText.setForeground(ColorResources.BLACK.getColor());
        this.dataText.setEnabled(false);
        Composite composite4 = FormUtil.createBorderComposite((Composite)composite2, (int)1, (boolean)true);
        gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 0;
        composite4.setLayout((Layout)gridLayout);
        composite4.setLayoutData((Object)FormUtil.createHGD());
        composite4.setBackground(ColorResources.TAB_INTERNAL_BORDER_LIGHT.getColor());
        Composite composite5 = FormUtil.createComposite((Composite)composite4);
        gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.numColumns = 3;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        composite5.setLayout((Layout)gridLayout);
        composite5.setLayoutData((Object)FormUtil.createHGD());
        this.buttonXZ = FormUtil.createECPButton((Composite)composite5, (String)"X/Z", (int)16);
        this.buttonXY = FormUtil.createECPButton((Composite)composite5, (String)"X/Y", (int)16);
        this.buttonMove = FormUtil.createECPButton((Composite)composite5, (String)"Move", (int)16);
        gridData = FormUtil.createHGD();
        gridData.horizontalIndent = 0;
        this.buttonXZ.setLayoutData((Object)gridData);
        this.buttonXY.setLayoutData((Object)gridData);
        this.buttonMove.setLayoutData((Object)gridData);
        this.buttonXZ.addSelectionListener((SelectionListener)this.modeListener);
        this.buttonXY.addSelectionListener((SelectionListener)this.modeListener);
        this.buttonMove.addSelectionListener((SelectionListener)this.modeListener);
        Composite composite6 = FormUtil.createComposite((Composite)composite4, (int)1);
        composite6.setLayoutData((Object)FormUtil.createHGD((int)1));
        this.withAxisCheck = FormUtil.createECPButton((Composite)composite6, (String)"With axis", (int)32);
        this.withAxisCheck.addSelectionListener((SelectionListener)this.axisListener);
        this.dataOutputTimer = new Timer(200, this.timerListener);
        this.dataOutputTimer.setCoalesce(true);
    }

    private double setRange(double d) {
        if (d > -0.01 && d < 0.01) {
            return 0.0;
        }
        return d;
    }

    private void drawControl(Composite composite) {
        Composite composite2 = FormUtil.createComposite((Composite)composite, (int)1);
        GridData gridData = new GridData(1, 1, true, true);
        gridData.widthHint = 265;
        gridData.verticalIndent = 20;
        composite2.setLayoutData((Object)gridData);
        Composite composite3 = FormUtil.createComposite((Composite)composite2, (int)2);
        composite3.setLayoutData((Object)gridData);
        FormUtil.createLabel((Composite)composite3, (String)"X : ", (int)0);
        this.pitchSlider = FormUtil.createECPSlider((Composite)composite3);
        this.pitchValue = (int)this.panel.pitchDegree;
        this.pitchSlider.addSelectionListener((SelectionListener)this.sliderSelection);
        this.pitchSlider.addMouseListener((MouseListener)this.sliderMouseUp);
        Composite composite4 = FormUtil.createComposite((Composite)composite2, (int)2);
        composite4.setLayoutData((Object)gridData);
        FormUtil.createLabel((Composite)composite4, (String)"Y : ", (int)0);
        this.rollSlider = FormUtil.createECPSlider((Composite)composite4);
        this.rollValue = (int)this.panel.rollDegree;
        this.rollSlider.addSelectionListener((SelectionListener)this.sliderSelection);
        this.rollSlider.addMouseListener((MouseListener)this.sliderMouseUp);
        Composite composite5 = FormUtil.createComposite((Composite)composite2, (int)2);
        composite5.setLayoutData((Object)gridData);
        FormUtil.createLabel((Composite)composite5, (String)"Z : ", (int)0);
        this.yawSlider = FormUtil.createECPSlider((Composite)composite5);
        this.yawValue = (int)this.panel.yawDegree;
        this.yawSlider.addSelectionListener((SelectionListener)this.sliderSelection);
        this.yawSlider.addMouseListener((MouseListener)this.sliderMouseUp);
        Composite composite6 = FormUtil.createBorderComposite((Composite)composite2, (int)2, (boolean)false);
        gridData = FormUtil.createHGD();
        gridData.verticalIndent = 20;
        gridData.widthHint = 310;
        composite6.setLayoutData((Object)gridData);
        this.createRotationButton(composite6);
    }

    private void setDefaultSlider(ECPSlider eCPSlider) {
        eCPSlider.setMinimum(0);
        eCPSlider.setMaximum(360);
        eCPSlider.setIncrement(1);
        eCPSlider.setPageIncrement(20);
    }

    private void initializeWidget() {
        this.mode = Mode.YAW_PITCH;
        this.buttonXZ.setSelection(true);
        this.dataText.setText("\n\n\n");
        this.setDefaultSlider(this.pitchSlider);
        this.pitchSlider.setSelection(this.pitchValue + this.orientation_pitch, false);
        this.setDefaultSlider(this.rollSlider);
        this.rollSlider.setSelection(this.rollValue + this.orientation_roll, false);
        this.setDefaultSlider(this.yawSlider);
        this.yawSlider.setSelection(this.yawValue + this.orientation_yaw, false);
    }

    public void initValues() {
        this.panel.rollDegree = 0.0;
        this.panel.pitchDegree = 0.0;
        this.panel.yawDegree = 0.0;
        this.panel.setOldGyroRollDegree(0.0);
        this.panel.setOldGyroPitchDegree(0.0);
        this.panel.setOldGyroYawDegree(0.0);
        this.yawValue = 0;
        this.pitchValue = 0;
        this.rollValue = 0;
    }

    private ECPButton getECPButton(String string) {
        return this.roWidget.get(string);
    }

    private void createRotationButton(Composite composite) {
        for (rotation rotation2 : rotation.values()) {
            ECPButton eCPButton = FormUtil.createPushButton((Composite)composite, (String)rotation2.getTitle());
            eCPButton.setLayoutData((Object)FormUtil.createGD((int)119, (int)22));
            this.roWidget.put(rotation2.getTitle(), eCPButton);
            eCPButton.addSelectionListener((SelectionListener)this.rotationSelection);
        }
    }

    public void destroyContents(Composite composite) {
        composite.layout(true, true);
    }

    public int getYawSliderValue() {
        return this.yawValue;
    }

    public void setYawSliderValue(int n) {
        this.yawValue = n;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                GUIDisplay.this.yawSlider.setSelection(GUIDisplay.this.yawValue + GUIDisplay.this.orientation_yaw, false);
            }
        });
    }

    public int getPitchSliderValue() {
        return this.pitchValue;
    }

    public void setPitchSliderValue(int n) {
        this.pitchValue = n;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                GUIDisplay.this.pitchSlider.setSelection(GUIDisplay.this.pitchValue + GUIDisplay.this.orientation_pitch, false);
            }
        });
    }

    public int getRollSliderValue() {
        return this.rollValue;
    }

    public void setRollSliderValue(int n) {
        this.rollValue = n;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                GUIDisplay.this.rollSlider.setSelection(GUIDisplay.this.rollValue + GUIDisplay.this.orientation_roll, false);
            }
        });
    }

    public void sendMessage(String string, double d, double d2, double d3) {
        if (string == "1\n") {
            if (this.tmp_accel_x != d || this.tmp_accel_y != d2 || this.tmp_accel_z != d3) {
                InjectorMessage injectorMessage = new InjectorMessage(d * (double)this.ACCEL_ADJUST, d2 * (double)this.ACCEL_ADJUST, d3 * (double)this.ACCEL_ADJUST);
                MessageSender.getInstance().sendDeviceReq("sensor", 0, 0, "1\n" + injectorMessage.getMessage());
                this.tmp_accel_x = d;
                this.tmp_accel_y = d2;
                this.tmp_accel_z = d3;
            }
        } else if ("4\n".equals(string) && (this.tmp_gyro_x != d || this.tmp_gyro_y != d2 || this.tmp_gyro_z != d3)) {
            InjectorMessage injectorMessage = new InjectorMessage(d * this.GYRO_ADJUST, d2 * this.GYRO_ADJUST, d3 * this.GYRO_ADJUST);
            MessageSender.getInstance().sendDeviceReq("sensor", 0, 0, "4\n" + injectorMessage.getMessage());
            this.tmp_gyro_x = d;
            this.tmp_gyro_y = d2;
            this.tmp_gyro_z = d3;
        }
    }

    public void sendMessage(String string, double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        if ("5\n".equals(string) && (this.tmp_geo_x != d || this.tmp_geo_y != d2 || this.tmp_geo_z != d3 || this.tmp_geo_a != d4 || this.tmp_geo_b != d5 || this.tmp_geo_c != d6 || this.tmp_geo_d != d7)) {
            InjectorMessage injectorMessage = new InjectorMessage(d, d2, d3, d4, d5, d6, d7);
            MessageSender.getInstance().sendDeviceReq("sensor", 0, 0, "5\n" + injectorMessage.getMessage());
            this.tmp_geo_x = d;
            this.tmp_geo_y = d2;
            this.tmp_geo_z = d3;
            this.tmp_geo_a = d4;
            this.tmp_geo_b = d5;
            this.tmp_geo_c = d6;
            this.tmp_geo_d = d7;
        }
    }

    public Mode getMode() {
        return this.mode;
    }

    public void connectPanel() {
        this.panel.connect();
    }

    public void disconnectPanel() {
        this.panel.disconnect();
    }

    public static enum Mode {
        YAW_PITCH,
        ROLL_PITCH,
        MOVE;

    }

    private static enum rotation {
        R0("Portrait"),
        R90("Landscape"),
        R180("Reverse Portrait"),
        R270("Reverse Landscape");

        String title;

        private rotation(String string2) {
            this.title = string2;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

