/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.telephony;

import com.google.protobuf.GeneratedMessage;
import java.util.HashMap;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.json.simple.JSONObject;
import org.tizen.ecp.RSSI.G02A31;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.nfc.AbstractInjectorReceiver;
import org.tizen.ecp.protocol.StructureGA;
import org.tizen.ecp.resources.ColorResources;
import org.tizen.ecp.resources.PatchImageResources;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.telephony.TelephonyConstants;
import org.tizen.ecp.telephony.call.TelephonyCallDisplay;
import org.tizen.ecp.telephony.sms.TelephonySMSDisplay;
import org.tizen.ecp.utils.FormUtil;
import org.tizen.ecp.views.ECPSubView;
import org.tizen.ecp.widgets.ECPButton;

public class TelephonyDisplay
extends ECPSubView
implements ILsn {
    private static TelephonyDisplay instance = new TelephonyDisplay();
    private Composite tabArea;
    private StackLayout tabSelection;
    private boolean isInitialized = false;
    private HashMap<String, ECPButton> buttons = new HashMap();
    private HashMap<String, Composite> comp = new HashMap();
    private PaintListener imageSpacingPaint = new PaintListener(){

        public void paintControl(PaintEvent paintEvent) {
            Composite composite = (Composite)paintEvent.widget;
            Rectangle rectangle = composite.getClientArea();
            paintEvent.gc.setForeground(ColorResources.TAB_INTERNAL_BORDER.getColor());
            paintEvent.gc.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width, rectangle.y + rectangle.height - 1);
        }
    };
    private PaintListener backPaint = new PaintListener(){

        public void paintControl(PaintEvent paintEvent) {
            Composite composite = (Composite)paintEvent.widget;
            Rectangle rectangle = composite.getClientArea();
            paintEvent.gc.setForeground(ColorResources.TAB_INTERNAL_BORDER.getColor());
            paintEvent.gc.drawLine(2, rectangle.y + rectangle.height - 1, rectangle.width + 2 - 1, rectangle.y + rectangle.height - 1);
        }
    };
    private PaintListener tabBorderPaint = new PaintListener(){

        public void paintControl(PaintEvent paintEvent) {
            Composite composite = (Composite)paintEvent.widget;
            Rectangle rectangle = composite.getClientArea();
            paintEvent.gc.setForeground(ColorResources.TAB_INTERNAL_BORDER.getColor());
            paintEvent.gc.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.height);
            paintEvent.gc.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width, rectangle.y + rectangle.height - 1);
            paintEvent.gc.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        }
    };
    private SelectionAdapter tabToggleSelection = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            for (tab_list tab_list2 : tab_list.values()) {
                ECPButton eCPButton = (ECPButton)TelephonyDisplay.this.buttons.get(tab_list2.getTitle());
                if (selectionEvent.widget == eCPButton) {
                    eCPButton.setSelection(true);
                    ((TelephonyDisplay)TelephonyDisplay.this).tabSelection.topControl = (Control)TelephonyDisplay.this.comp.get(tab_list2.getTitle());
                    TelephonyDisplay.this.tabArea.layout();
                    continue;
                }
                eCPButton.setSelection(false);
            }
        }
    };

    public TelephonyDisplay() {
        this.title = "Telephony";
        this.pageHeight = 510;
        this.createPage();
        EventMgr.getInstance().AddLsn("telephony", (ILsn)this);
        EventMgr.getInstance().AddLsn("sensor", (ILsn)this);
    }

    public static TelephonyDisplay getInstance() {
        return instance;
    }

    public void createView(Composite composite) {
        tab_list tab_list22;
        FormUtil.createLabel((Composite)composite, (String)"Telephony", (Font)TelephonyConstants.TITLE_FONT, (Color)TelephonyConstants.TITLE_COLOR);
        Composite composite2 = FormUtil.createComposite((Composite)composite);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 2;
        composite2.setLayout((Layout)gridLayout);
        Composite composite3 = FormUtil.createComposite((Composite)composite2);
        GridLayout gridLayout2 = new GridLayout(8, false);
        gridLayout2.horizontalSpacing = 0;
        gridLayout2.verticalSpacing = 0;
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 2;
        composite3.setLayout((Layout)gridLayout2);
        composite3.setLayoutData((Object)FormUtil.createHGD());
        composite3.addPaintListener(this.backPaint);
        Image image = PatchImageResources.getSelTabImage((int)90, (int)24);
        Image image2 = PatchImageResources.getNotSelTabImage((int)90, (int)24);
        for (tab_list tab_list22 : tab_list.values()) {
            ECPButton eCPButton = FormUtil.createECPButton((Composite)composite3, (String)tab_list22.getTitle(), (int)2);
            this.buttons.put(tab_list22.getTitle(), eCPButton);
            eCPButton.setLayoutData((Object)FormUtil.createGD((int)90, (int)24));
            eCPButton.setImages(image2, image2, image, image, null, image);
            eCPButton.addSelectionListener((SelectionListener)this.tabToggleSelection);
            Composite composite4 = FormUtil.createComposite((Composite)composite3);
            composite4.setLayoutData((Object)FormUtil.createGD((int)2, (int)24));
            composite4.addPaintListener(this.imageSpacingPaint);
        }
        this.buttons.get("Call").setSelection(true);
        this.tabArea = FormUtil.createComposite((Composite)composite2);
        GridLayout gridLayout3 = new GridLayout();
        gridLayout3.horizontalSpacing = 0;
        gridLayout3.verticalSpacing = 0;
        gridLayout3.marginHeight = 0;
        gridLayout3.marginWidth = 2;
        this.tabArea.setLayout((Layout)gridLayout3);
        GridData gridData = FormUtil.createHGD((int)491, (int)440, (int)2, (int)0);
        gridData.verticalAlignment = 1;
        this.tabArea.setLayoutData((Object)gridData);
        this.tabArea.setBackground(ColorResources.WHITE.getColor());
        this.tabSelection = new StackLayout();
        this.tabArea.setLayout((Layout)this.tabSelection);
        Composite composite5 = FormUtil.createComposite((Composite)this.tabArea);
        composite5.setData((Object)new GridData(768));
        composite5.addPaintListener(this.tabBorderPaint);
        TelephonyCallDisplay.getInstance().createDisplay(composite5);
        this.comp.put("Call", composite5);
        tab_list22 = FormUtil.createComposite((Composite)this.tabArea);
        tab_list22.setData(new GridData(768));
        tab_list22.addPaintListener(this.tabBorderPaint);
        TelephonySMSDisplay.getInstance().createDisplay((Composite)tab_list22);
        this.comp.put("Messaging", (Composite)tab_list22);
        this.tabSelection.topControl = composite5;
    }

    public void sendInitialize() {
        byte[] byArray = new byte[]{22, 0, 0, 0};
        MessageSender.getInstance().sendInjectorReq("telephony", 64, 65, byArray);
        byte[] byArray2 = new byte[]{0, 0, 64, 66};
        MessageSender.getInstance().sendInjectorReq("telephony", 64, 71, byArray2);
        this.isInitialized = true;
    }

    public void sendNetStatus(boolean bl) {
        if (!this.isInitialized) {
            this.sendInitialize();
        }
        int n = 2;
        int n2 = 1;
        int n3 = bl ? 1 : 0;
        int n4 = 0;
        int n5 = 17;
        int n6 = 32;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 10;
        int n11 = 0;
        G02A31 g02A31 = new G02A31();
        g02A31.intialize();
        StructureGA structureGA = g02A31.getBody();
        structureGA.setInt("NET_ACT_TYPE", n);
        structureGA.setInt("NET_SVC_DOMAIN", n2);
        structureGA.setInt("NET_REG_STATUS", n3);
        structureGA.setInt("NET_EDGE_SUPPORT", n4);
        structureGA.setInt("LAC0", n5);
        structureGA.setInt("LAC1", n6);
        structureGA.setInt("CELL_ID0", n7);
        structureGA.setInt("CELL_ID1", n8);
        structureGA.setInt("CELL_ID2", n9);
        structureGA.setInt("CELL_ID3", n10);
        structureGA.setInt("REJ_CAUSE", n11);
        byte[] byArray = g02A31.makePacket();
        try {
            MessageSender.getInstance().sendInjectorReq("telephony", 49, 2, byArray);
            TelephonyCallDisplay.getInstance().setRssiStatus(bl);
        }
        catch (Exception exception) {
            return;
        }
    }

    public boolean sendAskData() {
        int n = 17;
        int n2 = 91;
        String string = "";
        this.isInitialized = true;
        return MessageSender.getInstance().sendInjectorReq("telephony", n, n2, string);
    }

    protected void initializeWidget() {
    }

    public boolean Create() {
        this.createPage();
        return true;
    }

    public void OnActivate() {
        if (!this.isInitialized) {
            this.sendInitialize();
        }
        MessageSender.getInstance().sendInjectorReq("sensor", 15, 104);
        this.sendAskData();
    }

    public void OnDeactivate() {
    }

    public void OnEventProc(String string, JSONObject jSONObject) {
        try {
            AbstractInjectorReceiver abstractInjectorReceiver;
            byte[] byArray = null;
            JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"header");
            long l = (Long)jSONObject2.get((Object)"action");
            long l2 = (Long)jSONObject2.get((Object)"group");
            long l3 = (Long)jSONObject2.get((Object)"length");
            if (l3 != 0L) {
                byArray = new byte[(int)l3];
                String string2 = jSONObject.get((Object)"ijdata").toString();
                byArray = string2.getBytes();
            }
            if (byArray == null) {
                return;
            }
            if (l2 == 3L && l == 73L) {
                for (int i = 0; i < byArray.length; ++i) {
                    if (byArray[i] != -1) continue;
                    if (byArray[i + 4] == 3) {
                        TelephonyCallDisplay.getInstance().setCallWaiting(true);
                        continue;
                    }
                    if (byArray[i + 4] != 4) continue;
                    TelephonyCallDisplay.getInstance().setCallWaiting(false);
                }
            } else if (l2 == 4L && l == 12L) {
                TelephonySMSDisplay.getInstance().setMsgReceived(true);
                return;
            }
            if ((abstractInjectorReceiver = TelephonyCallDisplay.getInstance().getReceiver(l2, l)) == null) {
                return;
            }
            abstractInjectorReceiver.analyzePacket(byArray);
            abstractInjectorReceiver.run(abstractInjectorReceiver.getTransferObject());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void OnEventProcPB(String string, GeneratedMessage generatedMessage) {
        if (!(generatedMessage instanceof Ecs.InjectorNtf)) {
            return;
        }
        Ecs.InjectorNtf injectorNtf = (Ecs.InjectorNtf)generatedMessage;
        try {
            AbstractInjectorReceiver abstractInjectorReceiver;
            byte[] byArray = null;
            String string2 = "";
            long l = injectorNtf.getAction();
            long l2 = injectorNtf.getGroup();
            long l3 = injectorNtf.getLength();
            if (l3 != 0L) {
                byArray = new byte[(int)l3];
                byArray = injectorNtf.getData().toByteArray();
            }
            if (byArray == null) {
                return;
            }
            if (l2 == 3L && l == 73L) {
                for (int i = 0; i < byArray.length; ++i) {
                    if (byArray[i] != -1) continue;
                    if (byArray[i + 4] == 3) {
                        TelephonyCallDisplay.getInstance().setCallWaiting(true);
                        continue;
                    }
                    if (byArray[i + 4] != 4) continue;
                    TelephonyCallDisplay.getInstance().setCallWaiting(false);
                }
            } else {
                if (l2 == 4L && l == 12L) {
                    TelephonySMSDisplay.getInstance().setMsgReceived(true);
                    return;
                }
                if (l2 == 15L && l == 104L) {
                    if (string2.equals("0")) {
                        this.sendNetStatus(false);
                        TelephonyCallDisplay.getInstance().setRssiStatus(false);
                    } else {
                        this.sendNetStatus(true);
                        TelephonyCallDisplay.getInstance().setRssiStatus(true);
                    }
                }
            }
            if ((abstractInjectorReceiver = TelephonyCallDisplay.getInstance().getReceiver(l2, l)) == null) {
                return;
            }
            abstractInjectorReceiver.analyzePacket(byArray);
            abstractInjectorReceiver.run(abstractInjectorReceiver.getTransferObject());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    private static enum tab_list {
        CALL("Call"),
        MESSAGING("Messaging");

        private String title;

        private tab_list(String string2) {
            this.title = string2;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

