/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.telephony.call;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.tizen.ecp.dialogs.MessageDialog;
import org.tizen.ecp.nfc.AbstractInjectorReceiver;
import org.tizen.ecp.protocol.AbstractGA;
import org.tizen.ecp.protocol.StructureGA;
import org.tizen.ecp.resources.ColorResources;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.telephony.TelephonyConstants;
import org.tizen.ecp.telephony.call.CallListVO;
import org.tizen.ecp.telephony.call.ErrorCode;
import org.tizen.ecp.telephony.call.protocol.G01A07;
import org.tizen.ecp.telephony.call.protocol.G01A21MO;
import org.tizen.ecp.telephony.call.protocol.G01A21MT;
import org.tizen.ecp.telephony.call.protocol.G01A22;
import org.tizen.ecp.telephony.call.protocol.G01A22End;
import org.tizen.ecp.telephony.call.protocol.G01A23;
import org.tizen.ecp.telephony.call.protocol.G01A26;
import org.tizen.ecp.telephony.call.protocol.G01A29;
import org.tizen.ecp.telephony.call.protocol.G01A62;
import org.tizen.ecp.utils.FormUtil;
import org.tizen.ecp.widgets.ECPButton;

public class TelephonyCallDisplay {
    private static TelephonyCallDisplay instance = new TelephonyCallDisplay();
    private Text txtMTCallNumber;
    private ECPButton butMTCallHidden;
    private ECPButton butMTCallConnect;
    private Composite parent;
    boolean listfull = false;
    boolean incomming = false;
    boolean dialing = false;
    boolean calling = false;
    boolean isbtenabled = true;
    boolean callWaiting = true;
    private boolean rssiStatus = true;
    private static Table table;
    private Combo cmbCallListInformationCallStatus;
    private ECPButton butCallListInformationCallEnd;
    private static ArrayList<AbstractInjectorReceiver> receiverList;
    private final String[] CALL_TYPE_LIST = new String[]{"NONE", "VOICE", "DATA", "VIDEO", "MAX", "", "", "EMERGENCY"};
    private String defaultErrorCode = "CALL OK(Success)";
    private ErrorCode ERROR_CODE_LIST = new ErrorCode();
    private Label lblMOCallCallId;
    private Label lblMOCallNumber;
    private Label lblMOCallCallType;
    private ECPButton butMOCall;
    private Combo cmbMOCallCallStatus;
    private int MOCallevent;
    private ArrayList<CallListVO> callList = new ArrayList();
    private HashMap<String, AbstractInjectorReceiver> receiverMap = new HashMap();

    public HashMap<String, AbstractInjectorReceiver> getReceiverMap() {
        return this.receiverMap;
    }

    public void addInjectorReceiver(ArrayList<AbstractInjectorReceiver> arrayList) {
        if (arrayList == null) {
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            AbstractInjectorReceiver abstractInjectorReceiver = arrayList.get(i);
            this.receiverMap.put(abstractInjectorReceiver.getKey(), abstractInjectorReceiver);
        }
    }

    public void removeInjectorReceiver() {
        this.receiverMap.clear();
    }

    public void refresh() {
        table.removeAll();
        for (CallListVO callListVO : this.callList) {
            TableItem tableItem = new TableItem(table, 0);
            tableItem.setText(callListVO.getRowValues());
        }
        if (table.getItemCount() == 0) {
            this.butCallListInformationCallEnd.setEnabled(false);
        }
        table.layout();
    }

    public void createDisplay(Composite composite) {
        this.parent = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginRight = 0;
        this.parent.setLayout((Layout)gridLayout);
        this.parent.setLayoutData((Object)new GridData(4, 2, true, false));
        this.createMTCallSection();
        this.createCallListInformationSection();
        this.createMOCallSection();
        this.registerReceivers();
        this.addInjectorReceiver(receiverList);
    }

    private void createMOCallSection() {
        FormUtil.createLabel((Composite)this.parent, (String)"MO Call (Mobile Origination)", (Font)TelephonyConstants.TITLE_FONT, (Color)TelephonyConstants.TITLE_COLOR);
        Composite composite = FormUtil.createComposite((Composite)this.parent);
        composite.setBackground(ColorResources.CONTENTS_BORDER.getColor());
        GridData gridData = FormUtil.createHGD((int)474, (int)1, (int)0, (int)0);
        composite.setLayoutData((Object)gridData);
        Composite composite2 = FormUtil.createComposite((Composite)this.parent, (int)2);
        FormUtil.createLabel((Composite)composite2, (String)"Call ID : ", (int)0);
        this.lblMOCallCallId = FormUtil.createLabel((Composite)composite2, (String)"");
        FormUtil.setWidth((Control)this.lblMOCallCallId, (int)400);
        FormUtil.createLabel((Composite)composite2, (String)"Number : ", (int)0);
        this.lblMOCallNumber = FormUtil.createLabel((Composite)composite2, (String)"");
        FormUtil.setWidth((Control)this.lblMOCallNumber, (int)400);
        FormUtil.createLabel((Composite)composite2, (String)"Call Type : ", (int)0);
        this.lblMOCallCallType = FormUtil.createLabel((Composite)composite2, (String)"");
        FormUtil.setWidth((Control)this.lblMOCallCallType, (int)400);
        Composite composite3 = FormUtil.createComposite((Composite)this.parent, (int)2);
        this.cmbMOCallCallStatus = FormUtil.createCombo((Composite)composite3, (int)12);
        GridData gridData2 = new GridData(4, 4, true, false);
        this.cmbMOCallCallStatus.setLayoutData((Object)gridData2);
        this.cmbMOCallCallStatus.setEnabled(false);
        FormUtil.addComboItem((Combo)this.cmbMOCallCallStatus, (Object[])this.ERROR_CODE_LIST.getErrorList(), (Object)this.defaultErrorCode);
        this.butMOCall = FormUtil.createECPButton((Composite)composite3, (String)"Disconnect", (int)8);
        GridData gridData3 = new GridData(4, 4, false, false);
        gridData3.widthHint = 82;
        this.butMOCall.setLayoutData((Object)gridData3);
        this.butMOCall.setEnabled(false);
        this.MOCallevent = 0;
        this.butMOCall.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                switch (TelephonyCallDisplay.this.MOCallevent) {
                    case 0: {
                        TelephonyCallDisplay.this.moAlert();
                        break;
                    }
                    case 1: {
                        TelephonyCallDisplay.this.moConnect();
                        break;
                    }
                    default: {
                        TelephonyCallDisplay.this.moDisconnect();
                    }
                }
            }
        });
    }

    private void moDisconnect() {
        int n = this.ERROR_CODE_LIST.getKey(this.cmbMOCallCallStatus.getText());
        int n2 = n & 0xFF;
        int n3 = n >> 8 & 0xFF;
        String string = this.lblMOCallCallId.getText();
        G01A07 g01A07 = new G01A07();
        g01A07.intialize();
        StructureGA structureGA = g01A07.getBody();
        structureGA.setInt("ERROR_CAUSE_0", n2);
        structureGA.setInt("ERROR_CAUSE_1", n3);
        G01A22End g01A22End = new G01A22End();
        g01A22End.intialize();
        StructureGA structureGA2 = g01A22End.getBody();
        structureGA2.setInt("CALL_ID", Integer.parseInt(string));
        try {
            this.send(g01A07);
            this.send(g01A22End);
            this.cmbMOCallCallStatus.setEnabled(false);
            this.butMTCallConnect.setEnabled(true);
            this.butMOCall.setEnabled(false);
            this.dialing = false;
            this.MOCallevent = 0;
            this.lblMOCallCallId.setText("");
            this.lblMOCallNumber.setText("");
            this.lblMOCallCallType.setText("");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void moAlert() {
        G01A62 g01A62 = new G01A62();
        g01A62.intialize();
        try {
            this.send(g01A62);
            this.butMTCallConnect.setEnabled(true);
            this.butMOCall.setText("Connect");
            this.MOCallevent = 1;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void moConnect() {
        G01A23 g01A23 = new G01A23();
        g01A23.intialize();
        try {
            this.send(g01A23);
            this.dialing = false;
            this.butMOCall.setText("Disconnect");
            this.MOCallevent = 2;
        }
        catch (Exception exception) {
            this.dialing = true;
            exception.printStackTrace();
        }
    }

    public Table createTable(Composite composite, String[] stringArray, int n, int n2) {
        Table table = new Table(composite, n2);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = n;
        table.setLayoutData((Object)gridData);
        TableColumn tableColumn = null;
        for (int i = 0; i < stringArray.length; ++i) {
            tableColumn = new TableColumn(table, 0);
            tableColumn.setText(stringArray[i]);
            tableColumn.setWidth(95);
        }
        return table;
    }

    private void createCallListInformationSection() {
        FormUtil.createLabel((Composite)this.parent, (String)"Call List Information", (Font)TelephonyConstants.TITLE_FONT, (Color)TelephonyConstants.TITLE_COLOR);
        Composite composite = FormUtil.createComposite((Composite)this.parent);
        composite.setBackground(ColorResources.CONTENTS_BORDER.getColor());
        GridData gridData = FormUtil.createHGD((int)474, (int)1, (int)0, (int)0);
        composite.setLayoutData((Object)gridData);
        String[] stringArray = new String[]{"Call Id", "Status", "Multiparty", "MO/MT", "Number"};
        table = this.createTable(this.parent, stringArray, 1, 68354);
        GridData gridData2 = FormUtil.createHGD((int)474, (int)105, (int)0, (int)0);
        table.setLayoutData((Object)gridData2);
        table.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent focusEvent) {
                TelephonyCallDisplay.this.cmbCallListInformationCallStatus.setEnabled(false);
            }

            public void focusGained(FocusEvent focusEvent) {
                if (table.getSelectionIndex() == -1) {
                    TelephonyCallDisplay.this.cmbCallListInformationCallStatus.setEnabled(false);
                } else {
                    TelephonyCallDisplay.this.cmbCallListInformationCallStatus.setEnabled(true);
                }
            }
        });
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TelephonyCallDisplay.this.cmbCallListInformationCallStatus.setEnabled(true);
                TelephonyCallDisplay.this.butCallListInformationCallEnd.setEnabled(true);
            }
        });
        Composite composite2 = FormUtil.createComposite((Composite)this.parent, (int)2);
        this.cmbCallListInformationCallStatus = FormUtil.createCombo((Composite)composite2, (int)12);
        gridData2 = new GridData(4, 0x1000000, true, false);
        this.cmbCallListInformationCallStatus.setLayoutData((Object)gridData2);
        FormUtil.addComboItem((Combo)this.cmbCallListInformationCallStatus, (Object[])this.ERROR_CODE_LIST.getErrorList(), (Object)this.defaultErrorCode);
        this.cmbCallListInformationCallStatus.setEnabled(false);
        this.butCallListInformationCallEnd = FormUtil.createECPButton((Composite)composite2, (String)"Disconnect", (int)8);
        gridData2 = new GridData(4, 4, false, false);
        gridData2.widthHint = 82;
        this.butCallListInformationCallEnd.setLayoutData((Object)gridData2);
        this.butCallListInformationCallEnd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TelephonyCallDisplay.this.callEnd(false);
            }
        });
        this.butCallListInformationCallEnd.setEnabled(false);
    }

    private void createMTCallSection() {
        FormUtil.createLabel((Composite)this.parent, (String)"MT Call (Mobile Termination)", (Font)TelephonyConstants.TITLE_FONT, (Color)TelephonyConstants.TITLE_COLOR);
        Composite composite = FormUtil.createComposite((Composite)this.parent);
        composite.setBackground(ColorResources.CONTENTS_BORDER.getColor());
        GridData gridData = FormUtil.createHGD((int)474, (int)1, (int)0, (int)0);
        composite.setLayoutData((Object)gridData);
        Composite composite2 = FormUtil.createComposite((Composite)this.parent);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(4, 2, true, false));
        FormUtil.createLabel((Composite)composite2, (String)"Number : ", (int)0);
        this.txtMTCallNumber = FormUtil.createText((Composite)composite2, (String)"");
        GridData gridData2 = new GridData(4, 0x1000000, true, false);
        this.txtMTCallNumber.setLayoutData((Object)gridData2);
        this.txtMTCallNumber.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent verifyEvent) {
                String string = TelephonyCallDisplay.this.txtMTCallNumber.getText();
                if (TelephonyCallDisplay.checkNumberFormat(verifyEvent.text)) {
                    verifyEvent.doit = false;
                    return;
                }
                String string2 = string.substring(0, verifyEvent.start) + verifyEvent.text + string.substring(verifyEvent.end);
                if (string2.length() > 15) {
                    verifyEvent.doit = false;
                    return;
                }
            }
        });
        this.butMTCallConnect = FormUtil.createECPButton((Composite)composite2, (String)"Connect", (int)8);
        gridData2 = new GridData(4, 4, false, false);
        gridData2.widthHint = 62;
        this.butMTCallConnect.setLayoutData((Object)gridData2);
        FormUtil.createLabel((Composite)composite2, (String)"Call Type : ", (int)0);
        this.butMTCallHidden = FormUtil.createECPButton((Composite)composite2, (String)"Hidden", (int)32);
        this.butMTCallConnect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TelephonyCallDisplay.this.mtConnecct();
            }
        });
    }

    public void showWarningDialog(String string) {
        Shell shell = new Shell(Display.getDefault());
        MessageDialog messageDialog = new MessageDialog(shell);
        messageDialog.openWarningDialog(string);
        this.connectBtStatus(true);
    }

    public void showInfoDialog(String string) {
        Shell shell = new Shell(Display.getDefault());
        MessageDialog messageDialog = new MessageDialog(shell);
        messageDialog.openInfoDialog(string);
        this.connectBtStatus(true);
    }

    public void connectBtStatus(boolean bl) {
        this.butMTCallConnect.setEnabled(bl);
        this.isbtenabled = bl;
    }

    public static boolean checkNumberFormat(String string) {
        Pattern pattern = Pattern.compile("[^0-9++]");
        Matcher matcher = pattern.matcher(string);
        return matcher.find();
    }

    public void setRssiStatus(boolean bl) {
        this.rssiStatus = bl;
        if (!bl) {
            this.callEnd(true);
        }
    }

    public boolean getRssiStatus() {
        return this.rssiStatus;
    }

    public void setCallWaiting(boolean bl) {
        this.callWaiting = bl;
    }

    private void mtConnecct() {
        this.connectBtStatus(false);
        if (!this.rssiStatus) {
            this.showInfoDialog("RSSI level is zero.\nPlease try again later.");
            return;
        }
        if (this.listfull) {
            this.showInfoDialog("There are many pending connections.\nCan't connect anymore.");
        }
        if (this.incomming || this.dialing) {
            this.showInfoDialog("User is busy.\nPlease try again later.");
            return;
        }
        if (!this.callWaiting && this.calling) {
            this.showInfoDialog("User is busy.\nCall waiting mode of emulator is off.\nPlease try again later.");
            return;
        }
        String string = this.txtMTCallNumber.getText().trim();
        if (string == null || string.length() == 0) {
            this.butMTCallConnect.setEnabled(true);
            return;
        }
        int n = 1;
        int n2 = 0;
        int n3 = this.butMTCallHidden.getSelection() ? 1 : 0;
        int n4 = 1;
        int n5 = 1;
        int n6 = 0;
        G01A21MT g01A21MT = new G01A21MT();
        g01A21MT.intialize();
        StructureGA structureGA = g01A21MT.getBody();
        structureGA.setInt("CALL_TYPE", n);
        structureGA.setInt("FORWARDED_STATUS", n2);
        structureGA.setInt("CLIR_STATUS", n3);
        structureGA.setInt("NUM_LEN", string.getBytes().length);
        structureGA.setInt("NUM_TYPE", n4);
        structureGA.setInt("CLI_PRESENT_ID", n5);
        structureGA.setInt("NO_CLI_CAUSE", n6);
        structureGA.setByteArray("CALL_NUMBER", string.getBytes());
        try {
            this.send(g01A21MT);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        new Thread(){

            @Override
            public void run() {
                while (!TelephonyCallDisplay.this.isbtenabled) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
        }.start();
    }

    public void callEnd(boolean bl) {
        TableItem[] tableItemArray;
        if (bl) {
            table.setSelection(0, 5);
        }
        if ((tableItemArray = table.getSelection()).length == 0) {
            return;
        }
        for (int i = 0; i < tableItemArray.length; ++i) {
            int n = this.ERROR_CODE_LIST.getKey(this.cmbCallListInformationCallStatus.getText());
            int n2 = n & 0xFF;
            int n3 = n >> 8 & 0xFF;
            int n4 = Integer.parseInt(tableItemArray[i].getText(0));
            G01A07 g01A07 = new G01A07();
            g01A07.intialize();
            StructureGA structureGA = g01A07.getBody();
            structureGA.setInt("ERROR_CAUSE_0", n2);
            structureGA.setInt("ERROR_CAUSE_1", n3);
            G01A22End g01A22End = new G01A22End();
            g01A22End.intialize();
            StructureGA structureGA2 = g01A22End.getBody();
            structureGA2.setInt("CALL_ID", n4);
            try {
                this.send(g01A07);
                this.send(g01A22End);
                String string = this.lblMOCallCallId.getText();
                if (string == null || string.isEmpty() || n4 != Integer.parseInt(string)) continue;
                this.cmbMOCallCallStatus.setEnabled(false);
                this.butMTCallConnect.setEnabled(true);
                this.butMOCall.setEnabled(false);
                this.dialing = false;
                this.MOCallevent = 0;
                this.lblMOCallCallId.setText("");
                this.lblMOCallNumber.setText("");
                this.lblMOCallCallType.setText("");
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.cmbMOCallCallStatus.setEnabled(false);
                this.butMTCallConnect.setEnabled(true);
                this.butMOCall.setEnabled(false);
                this.dialing = false;
                this.MOCallevent = 0;
                this.lblMOCallCallId.setText("");
                this.lblMOCallNumber.setText("");
                this.lblMOCallCallType.setText("");
            }
        }
    }

    public boolean send(AbstractGA abstractGA) {
        return MessageSender.getInstance().sendInjectorReq("telephony", abstractGA.getGroupID(), abstractGA.getActionID(), abstractGA.makePacket());
    }

    public AbstractInjectorReceiver getReceiver(long l, long l2) {
        return this.receiverMap.get(l + ":" + l2);
    }

    public void registerReceiver(String string, AbstractInjectorReceiver abstractInjectorReceiver) {
        this.receiverMap.put(string, abstractInjectorReceiver);
    }

    protected void registerReceivers() {
        CallList22Receiver callList22Receiver = new CallList22Receiver();
        CallList26Receiver callList26Receiver = new CallList26Receiver();
        CallList29Receiver callList29Receiver = new CallList29Receiver();
        CallReceiver callReceiver = new CallReceiver();
        this.registerReceiver(callList22Receiver.getKey(), callList22Receiver);
        this.registerReceiver(callList26Receiver.getKey(), callList26Receiver);
        this.registerReceiver(callList29Receiver.getKey(), callList29Receiver);
        this.registerReceiver(callReceiver.getKey(), callReceiver);
    }

    public static TelephonyCallDisplay getInstance() {
        return instance;
    }

    static {
        receiverList = new ArrayList();
    }

    public class CallReceiver
    extends AbstractInjectorReceiver {
        @Override
        public void run(AbstractGA abstractGA) {
            StructureGA structureGA = abstractGA.getBody();
            int n = structureGA.getInt("CALL_ID");
            int n2 = structureGA.getInt("CALL_TYPE");
            String string = new String(structureGA.getByteArray("CALL_NUMBER")).trim();
            TelephonyCallDisplay.this.lblMOCallCallId.setText(new Integer(n).toString());
            TelephonyCallDisplay.this.lblMOCallNumber.setText(string);
            TelephonyCallDisplay.this.lblMOCallCallType.setText(TelephonyCallDisplay.this.CALL_TYPE_LIST[n2]);
            TelephonyCallDisplay.this.lblMOCallCallType.getParent().layout();
            TelephonyCallDisplay.this.butMOCall.setEnabled(true);
            byte[] byArray = structureGA.getByteArray("CALL_NUMBER");
            if (byArray[0] == 4) {
                TelephonyCallDisplay.this.dialing = true;
                TelephonyCallDisplay.this.butMOCall.setText("Connect");
                TelephonyCallDisplay.this.MOCallevent = 1;
            } else {
                TelephonyCallDisplay.this.dialing = true;
                TelephonyCallDisplay.this.butMOCall.setText("Alert");
                TelephonyCallDisplay.this.MOCallevent = 0;
            }
            TelephonyCallDisplay.this.cmbMOCallCallStatus.setEnabled(true);
            TelephonyCallDisplay.this.butMTCallConnect.setEnabled(false);
        }

        @Override
        public AbstractGA createTransferObject() {
            return new G01A21MO();
        }
    }

    public class CallList29Receiver
    extends AbstractInjectorReceiver {
        @Override
        public void run(AbstractGA abstractGA) {
            TelephonyCallDisplay.this.callList.clear();
            StructureGA structureGA = abstractGA.getHeader();
            int n = structureGA.getInt("COUNT");
            int n2 = 0;
            TelephonyCallDisplay.this.incomming = false;
            TelephonyCallDisplay.this.connectBtStatus(true);
            StructureGA structureGA2 = abstractGA.getBody();
            for (int i = 0; i < n; ++i) {
                CallListVO callListVO = new CallListVO();
                callListVO.setCallId(structureGA2.getInt("IDX", i));
                callListVO.setStatus(structureGA2.getInt("STAT", i) - 1);
                callListVO.setMultiParty(structureGA2.getInt("MULTIPARTY", i));
                callListVO.setMomt(structureGA2.getInt("DIR", i) - 1);
                callListVO.setNumber(new String(structureGA2.getByteArray("NUMBER", i)).trim());
                if (callListVO.getStatus() == -1) {
                    ++n;
                    ++n2;
                    continue;
                }
                if (callListVO.getStatus() == 4 || callListVO.getStatus() == 5) {
                    TelephonyCallDisplay.this.incomming = true;
                }
                TelephonyCallDisplay.this.callList.add(callListVO);
                TelephonyCallDisplay.this.calling = true;
            }
            TelephonyCallDisplay.this.refresh();
            TelephonyCallDisplay.this.listfull = (n -= n2) == 6;
        }

        @Override
        public AbstractGA createTransferObject() {
            return new G01A29();
        }
    }

    public class CallList26Receiver
    extends AbstractInjectorReceiver {
        @Override
        public void run(AbstractGA abstractGA) {
            TelephonyCallDisplay.this.callList.clear();
            StructureGA structureGA = abstractGA.getHeader();
            int n = structureGA.getInt("COUNT");
            TelephonyCallDisplay.this.incomming = false;
            TelephonyCallDisplay.this.connectBtStatus(true);
            StructureGA structureGA2 = abstractGA.getBody();
            for (int i = 0; i < n; ++i) {
                CallListVO callListVO = new CallListVO();
                callListVO.setCallId(structureGA2.getInt("IDX", i));
                callListVO.setStatus(structureGA2.getInt("STAT", i) - 1);
                callListVO.setMultiParty(structureGA2.getInt("MULTIPARTY", i));
                callListVO.setMomt(structureGA2.getInt("DIR", i) - 1);
                callListVO.setNumber(new String(structureGA2.getByteArray("NUMBER", i)).trim());
                if (callListVO.getStatus() == 4 || callListVO.getStatus() == 5) {
                    TelephonyCallDisplay.this.incomming = true;
                }
                TelephonyCallDisplay.this.callList.add(callListVO);
                TelephonyCallDisplay.this.calling = true;
            }
            TelephonyCallDisplay.this.refresh();
        }

        @Override
        public AbstractGA createTransferObject() {
            return new G01A26();
        }
    }

    public class CallList22Receiver
    extends AbstractInjectorReceiver {
        @Override
        public void run(AbstractGA abstractGA) {
            TelephonyCallDisplay.this.callList.clear();
            StructureGA structureGA = abstractGA.getHeader();
            int n = structureGA.getInt("COUNT");
            int n2 = 0;
            boolean bl = false;
            TelephonyCallDisplay.this.connectBtStatus(true);
            StructureGA structureGA2 = abstractGA.getBody();
            TelephonyCallDisplay.this.incomming = false;
            for (int i = 0; i < n; ++i) {
                String string;
                String string2;
                CallListVO callListVO = new CallListVO();
                callListVO.setCallId(structureGA2.getInt("IDX", i));
                callListVO.setStatus(structureGA2.getInt("STAT", i) - 1);
                callListVO.setMultiParty(structureGA2.getInt("MULTIPARTY", i));
                callListVO.setMomt(structureGA2.getInt("DIR", i) - 1);
                callListVO.setNumber(new String(structureGA2.getByteArray("NUMBER", i)).trim());
                if (callListVO.getStatus() == -1) {
                    ++n;
                    ++n2;
                    continue;
                }
                if (callListVO.getStatus() == 4 || callListVO.getStatus() == 5) {
                    TelephonyCallDisplay.this.incomming = true;
                }
                if ((string2 = callListVO.getNumber()).compareTo(string = TelephonyCallDisplay.this.lblMOCallNumber.getText()) == 0) {
                    bl = true;
                }
                TelephonyCallDisplay.this.callList.add(callListVO);
            }
            TelephonyCallDisplay.this.refresh();
            if ((n -= n2) != 6) {
                TelephonyCallDisplay.this.listfull = false;
            }
            if (n == 0) {
                TelephonyCallDisplay.this.calling = false;
            }
            if (!bl) {
                TelephonyCallDisplay.this.cmbMOCallCallStatus.setEnabled(false);
                TelephonyCallDisplay.this.butMTCallConnect.setEnabled(true);
                TelephonyCallDisplay.this.butMOCall.setEnabled(false);
                TelephonyCallDisplay.this.dialing = false;
                TelephonyCallDisplay.this.MOCallevent = 0;
                TelephonyCallDisplay.this.lblMOCallCallId.setText("");
                TelephonyCallDisplay.this.lblMOCallNumber.setText("");
                TelephonyCallDisplay.this.lblMOCallCallType.setText("");
            }
        }

        @Override
        public AbstractGA createTransferObject() {
            return new G01A22();
        }
    }
}

