/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.nfc.ui;

import java.util.ArrayList;
import java.util.List;
import org.tizen.ecp.dialog.MessageBox;
import org.tizen.ecp.nfc.NDEFRecord;
import org.tizen.ecp.nfc.NFCErrorString;
import org.tizen.ecp.nfc.NFCEventException;
import org.tizen.ecp.nfc.NFCEventInjector;
import org.tizen.ecp.nfc.NFCUtil;
import org.tizen.ecp.nfc.cli.NFCEventType;
import org.tizen.ecp.nfc.cli.NFCTagType;
import org.tizen.ecp.nfc.ui.NFCDialog;
import org.tizen.ecp.string.DeviceMessages;

public class NFCUIUtil {
    static boolean sendMessage(NFCEventType nFCEventType, NFCTagType nFCTagType, List<NDEFRecord> list) {
        boolean bl;
        try {
            bl = NFCUtil.availableNfc();
            if (!bl) {
                NFCDialog.openErrorDialog(NFCErrorString.NFCIsDisable);
            }
        }
        catch (NFCEventException nFCEventException) {
            bl = false;
            MessageBox.error((String)nFCEventException.getMessage());
        }
        if (!bl) {
            return nFCEventType != NFCEventType.TAG_DISCOVERED && nFCEventType != NFCEventType.P2P_DISCOVERED && nFCEventType != NFCEventType.P2P_SEND;
        }
        switch (nFCEventType) {
            case TAG_DISCOVERED: {
                if (nFCTagType == null) {
                    NFCDialog.openErrorDialog(NFCErrorString.SelecTagType);
                    return false;
                }
                NFCEventInjector.sendMessage(nFCEventType, nFCTagType, list);
                break;
            }
            case TAG_DETACHED: 
            case P2P_DISCOVERED: 
            case P2P_DETACHED: {
                NFCEventInjector.sendMessage(nFCEventType);
                break;
            }
            case P2P_SEND: {
                NFCEventInjector.sendMessage(nFCEventType, NFCTagType.P2P, list);
                break;
            }
        }
        return true;
    }

    static int checkRecordlistMaxLength(ArrayList<NDEFRecord> arrayList, int n) {
        int n2 = 0;
        for (NDEFRecord nDEFRecord : arrayList) {
            n2 += 1 + nDEFRecord.getTypeName().length() + nDEFRecord.getId().length() + nDEFRecord.getPayload().length() + 4;
        }
        if (n2 > n) {
            MessageBox.confirm((String)(DeviceMessages.getString("NFCUIUtil.0") + n + DeviceMessages.getString("NFCUIUtil.1")));
            return 0;
        }
        return n2;
    }
}

