/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sensor.axis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.Event;
import javafx.event.EventHandler;
import org.tizen.ecp.sensor.axis.SensorFileEvent;
import org.tizen.ecp.utils.LogUtil;

public abstract class SensorFileOperation {
    protected Logger logger;
    private Thread workerThread;
    private List<File> fileList = new ArrayList<File>();
    private boolean isFinished = false;
    private List<EventHandler<SensorFileEvent>> handlerList = new ArrayList<EventHandler<SensorFileEvent>>();

    public SensorFileOperation() {
        this.logger = LogUtil.getECPLogger(this.getClass()).getLogger();
    }

    protected abstract void sendMessage(double var1, double var3, double var5);

    public void addSenorFileListener(EventHandler<SensorFileEvent> eventHandler) {
        this.handlerList.add(eventHandler);
    }

    public void removeSensorFileListener(EventHandler<SensorFileEvent> eventHandler) {
        this.handlerList.remove(eventHandler);
    }

    private void fileOperationFinished() {
        this.setFinished(true);
        for (EventHandler<SensorFileEvent> eventHandler : this.handlerList) {
            eventHandler.handle((Event)new SensorFileEvent());
        }
    }

    public synchronized boolean isFinished() {
        return this.isFinished;
    }

    public synchronized void setFinished(boolean bl) {
        this.isFinished = bl;
    }

    public void addFile(File file) {
        this.fileList.add(file);
    }

    public void startInjection() {
        this.setFinished(false);
        this.workerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                SensorFileOperation.this.fileOperation();
            }
        });
        this.workerThread.start();
    }

    public void stopInjection() {
        this.fileList.clear();
        this.workerThread.interrupt();
        try {
            this.workerThread.join();
        }
        catch (InterruptedException interruptedException) {
            this.logger.log(Level.SEVERE, "stopInjection: worker thread is interrupted.", interruptedException);
        }
        this.setFinished(true);
    }

    protected void fileOperation() {
        int n = 0;
        int n2 = 0;
        String string = null;
        for (File file : this.fileList) {
            this.logger.log(Level.FINE, "fileOperation: path is " + file.getAbsolutePath());
        }
        for (File file : this.fileList) {
            if (!file.exists()) {
                this.logger.log(Level.SEVERE, "file path does not exist : " + file.getAbsolutePath());
                continue;
            }
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                Throwable throwable = null;
                try {
                    while ((string = bufferedReader.readLine()) != null) {
                        double d;
                        double d2;
                        double d3;
                        String[] stringArray = string.split(",");
                        if (stringArray.length != 4) continue;
                        try {
                            n2 = Integer.parseInt(stringArray[0]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            n2 = n + 1;
                        }
                        int n3 = (n2 - n) * 10;
                        if (n3 < 0) {
                            n3 = 1000;
                            n = 0;
                            n2 = n + 1;
                        }
                        try {
                            Thread.sleep(n3);
                        }
                        catch (InterruptedException interruptedException) {
                            this.logger.log(Level.SEVERE, "Interrupt exception", interruptedException);
                            if (bufferedReader != null) {
                                if (throwable != null) {
                                    try {
                                        bufferedReader.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                } else {
                                    bufferedReader.close();
                                }
                            }
                            return;
                        }
                        n = n2;
                        try {
                            d3 = stringArray[1] == null || stringArray[1].isEmpty() ? 0.0 : Double.parseDouble(stringArray[1]);
                            d2 = stringArray[2] == null || stringArray[2].isEmpty() ? 0.0 : Double.parseDouble(stringArray[2]);
                            d = stringArray[3] == null || stringArray[3].isEmpty() ? 0.0 : Double.parseDouble(stringArray[3]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.logger.log(Level.SEVERE, "number format exception: xyz", numberFormatException);
                            continue;
                        }
                        this.sendMessage(d3, d2, d);
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (bufferedReader == null) continue;
                    if (throwable != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                this.logger.log(Level.SEVERE, "IOexception", iOException);
                return;
            }
        }
        this.fileList.clear();
        this.fileOperationFinished();
    }
}

