#ifndef _ELM_COLOR_ITEM_EO_LEGACY_H_
#define _ELM_COLOR_ITEM_EO_LEGACY_H_

#ifndef _ELM_COLOR_ITEM_EO_CLASS_TYPE
#define _ELM_COLOR_ITEM_EO_CLASS_TYPE

typedef Eo Elm_Color_Item;

#endif

#ifndef _ELM_COLOR_ITEM_EO_TYPES
#define _ELM_COLOR_ITEM_EO_TYPES


#endif

/**
 *
 * @internal
 *
 * Set Palette item's color.
 *
 * @ingroup Colorselector
 *
 * @param[in] obj The elm color item object
 * @param[in] r red-value of color
 * @param[in] g green-value of color
 * @param[in] b blue-value of color
 * @param[in] a alpha-value of color
 */
//EAPI void elm_color_item_color_set(Elm_Color_Item *obj, int r, int g, int b, int a);

/**
 *
 * @internal
 *
 * Get Palette item's color.
 *
 * @ingroup Colorselector
 *
 * @param[in] obj The elm color item object
 * @param[out] r red-value of color
 * @param[out] g green-value of color
 * @param[out] b blue-value of color
 * @param[out] a alpha-value of color
 */
//EAPI void elm_color_item_color_get(const Elm_Color_Item *obj, int *r, int *g, int *b, int *a);

/**
 *
 * @internal
 *
 * Set the selected state of color palette item
 *
 * @since 1.9
 * @ingroup Colorselector
 *
 * @param[in] obj The elm color item object
 * @param[in] selected @c EINA_TRUE if selected @c EINA_FALSE otherwise
 */
//EAPI void elm_color_item_selected_set(Elm_Color_Item *obj, Eina_Bool selected);

/**
 *
 * @internal
 *
 * Get the selected state of color palette item
 *
 * @since 1.9
 * @ingroup Colorselector
 *
 * @param[in] obj The elm color item object
 */
//EAPI Eina_Bool elm_color_item_selected_get(const Elm_Color_Item *obj);

#endif
