#ifndef _ELM_COLORSELECTOR_EO_H_
#define _ELM_COLORSELECTOR_EO_H_

#ifndef _ELM_COLORSELECTOR_EO_CLASS_TYPE
#define _ELM_COLORSELECTOR_EO_CLASS_TYPE

typedef Eo Elm_Colorselector;

#endif

#ifndef _ELM_COLORSELECTOR_EO_TYPES
#define _ELM_COLORSELECTOR_EO_TYPES


#endif
#define ELM_COLORSELECTOR_CLASS elm_colorselector_class_get()

const Eo_Class *elm_colorselector_class_get(void) EINA_CONST;

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Set color to colorselector
 *
 * @if MOBILE @since_tizen 2.3
 * @endif
 *
 * @ingroup Colorselector
 *
 * @param[in] r r-value of color
 * @param[in] g g-value of color
 * @param[in] b b-value of color
 * @param[in] a a-value of color
 *
 */
EOAPI void  elm_obj_colorselector_color_set(int r, int g, int b, int a);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Get current color from colorselector
 *
 * @if MOBILE @since_tizen 2.3
 * @endif
 *
 * @ingroup Colorselector
 *
 * @param[out] r r-value of color
 * @param[out] g g-value of color
 * @param[out] b b-value of color
 * @param[out] a a-value of color
 *
 */
EOAPI void  elm_obj_colorselector_color_get(int *r, int *g, int *b, int *a);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Set current palette's name
 *
 * @if MOBILE @since_tizen 2.3
 * @endif
 *
 * @remark When colorpalette name is set, colors will be loaded from and saved to config
 * using the set name. If no name is set then colors will be loaded from or
 * saved to "default" config.
 *
 * @ingroup Colorselector
 *
 * @param[in] palette_name Name of palette
 *
 */
EOAPI void  elm_obj_colorselector_palette_name_set(const char *palette_name);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Get current palette's name
 *
 * @if MOBILE @since_tizen 2.3
 * @endif
 *
 * @return Name of palette
 *
 * @remark Returns the currently set palette name using which colors will be
 * saved/loaded in to config.
 *
 * @ingroup Colorselector
 *
 *
 */
EOAPI const char * elm_obj_colorselector_palette_name_get(void);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Set Colorselector's mode.
 *
 * @if MOBILE @since_tizen 2.3
 * @endif
 *
 * @remark Colorselector supports three modes palette only, selector only and both.
 *
 * @ingroup Colorselector
 *
 * @param[in] mode Elm_Colorselector_Mode
 *
 */
EOAPI void  elm_obj_colorselector_mode_set(Elm_Colorselector_Mode mode);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Get Colorselector's mode.
 *
 * @if MOBILE @since_tizen 2.3
 * @endif
 *
 * @return mode The current mode of colorselector
 *
 * @ingroup Colorselector
 *
 *
 */
EOAPI Elm_Colorselector_Mode  elm_obj_colorselector_mode_get(void);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Get list of palette items.
 *
 * @if MOBILE @since_tizen 2.3
 * @endif
 *
 * @return The list of color palette items.
 *
 * @remark Note That palette item list is internally managed by colorselector widget and
 * it should not be freed/modified by application.
 *
 * @since 1.9
 *
 * @ingroup Colorselector
 *
 *
 */
EOAPI const Eina_List * elm_obj_colorselector_palette_items_get(void);

/**
 *
 * @internal
 *
 * Get the selected item in colorselector palette.
 *
 * @return The selected item, or NULL if none is selected.
 *
 * @since 1.9
 * @ingroup Colorselector
 *
 *
 */
EOAPI Elm_Object_Item * elm_obj_colorselector_palette_selected_item_get(void);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Add a new color item to palette.
 *
 * @if MOBILE @since_tizen 2.3
 * @endif
 *
 * @return A new color palette Item.
 *
 * @ingroup Colorselector
 * 
 *
 * @param[in] r r-value of color
 * @param[in] g g-value of color
 * @param[in] b b-value of color
 * @param[in] a a-value of color
 *
 */
EOAPI Elm_Object_Item * elm_obj_colorselector_palette_color_add(int r, int g, int b, int a);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Clear the palette items.
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @ingroup Colorselector
 * 
 *
 *
 */
EOAPI void  elm_obj_colorselector_palette_clear(void);

EOAPI extern const Eo_Event_Description _ELM_COLORSELECTOR_EVENT_COLOR_ITEM_SELECTED;
EOAPI extern const Eo_Event_Description _ELM_COLORSELECTOR_EVENT_COLOR_ITEM_LONGPRESSED;
EOAPI extern const Eo_Event_Description _ELM_COLORSELECTOR_EVENT_CHANGED;
EOAPI extern const Eo_Event_Description _ELM_COLORSELECTOR_EVENT_LANGUAGE_CHANGED;
EOAPI extern const Eo_Event_Description _ELM_COLORSELECTOR_EVENT_ACCESS_CHANGED;
EOAPI extern const Eo_Event_Description _ELM_COLORSELECTOR_EVENT_FOCUSED;
EOAPI extern const Eo_Event_Description _ELM_COLORSELECTOR_EVENT_UNFOCUSED;

/**
 * No description
 */
#define ELM_COLORSELECTOR_EVENT_COLOR_ITEM_SELECTED (&(_ELM_COLORSELECTOR_EVENT_COLOR_ITEM_SELECTED))

/**
 * No description
 */
#define ELM_COLORSELECTOR_EVENT_COLOR_ITEM_LONGPRESSED (&(_ELM_COLORSELECTOR_EVENT_COLOR_ITEM_LONGPRESSED))

/**
 * No description
 */
#define ELM_COLORSELECTOR_EVENT_CHANGED (&(_ELM_COLORSELECTOR_EVENT_CHANGED))

/**
 * No description
 */
#define ELM_COLORSELECTOR_EVENT_LANGUAGE_CHANGED (&(_ELM_COLORSELECTOR_EVENT_LANGUAGE_CHANGED))

/**
 * No description
 */
#define ELM_COLORSELECTOR_EVENT_ACCESS_CHANGED (&(_ELM_COLORSELECTOR_EVENT_ACCESS_CHANGED))

/**
 * No description
 */
#define ELM_COLORSELECTOR_EVENT_FOCUSED (&(_ELM_COLORSELECTOR_EVENT_FOCUSED))

/**
 * No description
 */
#define ELM_COLORSELECTOR_EVENT_UNFOCUSED (&(_ELM_COLORSELECTOR_EVENT_UNFOCUSED))

#endif
