#ifndef _ELM_INTERFACE_ATSPI_ACCESSIBLE_EO_H_
#define _ELM_INTERFACE_ATSPI_ACCESSIBLE_EO_H_

#ifndef _ELM_INTERFACE_ATSPI_ACCESSIBLE_EO_CLASS_TYPE
#define _ELM_INTERFACE_ATSPI_ACCESSIBLE_EO_CLASS_TYPE

typedef Eo Elm_Interface_Atspi_Accessible;

#endif

#ifndef _ELM_INTERFACE_ATSPI_ACCESSIBLE_EO_TYPES
#define _ELM_INTERFACE_ATSPI_ACCESSIBLE_EO_TYPES


#endif
#define ELM_INTERFACE_ATSPI_ACCESSIBLE_MIXIN elm_interface_atspi_accessible_mixin_get()

const Eo_Class *elm_interface_atspi_accessible_mixin_get(void) EINA_CONST;

/**
 *
 * @brief Defines the relationship between two accessible objects.
 *
 * Adds unique relation between source object and relation_object of a
 * given type.
 *
 * Relationships can be queried by Assistive Technology clients to
 * provide customized feedback, improving overall user experience.
 *
 * @remark relationship_append API is asymmetric, which means that
 * appending, for example, relation ELM_ATSPI_RELATION_FLOWS_TO from object A to B,
 * do NOT append relation ELM_ATSPI_RELATION_FLOWS_FROM from object B to
 * object A.
 *
 * @return EINA_TRUE is relationship was successfully appended, EINA_FALSE
 * otherwise
 *
 * @since_tizen 2.4
 *
 * @ingroup Accessibility
 * 
 *
 * @param[in] type No description supplied.
 * @param[in] relation_object No description supplied.
 *
 */
EOAPI Eina_Bool  elm_interface_atspi_accessible_relationship_append(Elm_Atspi_Relation_Type type, const Elm_Interface_Atspi_Accessible *relation_object);

/**
 *
 * @brief Removes the relationship between two accessible objects.
 *
 * @since_tizen 2.4
 *
 * @ingroup Accessibility
 * 
 *
 * @param[in] type No description supplied.
 * @param[in] relation_object No description supplied.
 *
 */
EOAPI void  elm_interface_atspi_accessible_relationship_remove(Elm_Atspi_Relation_Type type, const Elm_Interface_Atspi_Accessible *relation_object);

/**
 *
 * @brief Gets the translation domain of "name" and "description"
 * properties.
 *
 * @since_tizen 2.4
 *
 * @return Translation domain of "name" and "description"
 *
 * @ingroup Accessibility
 *
 *
 */
EOAPI const char * elm_interface_atspi_accessible_translation_domain_get(void);

/**
 *
 * @brief Sets the translation domain of "name" and "description"
 * properties.
 *
 * Translation domain should be set if application wants to support i18n
 * for accessibily "name" and "descriptions" properties.
 *
 * When translation domain is set values of "name" and "description"
 * properties will be translated with dgettext function using
 * current translation domain as "domainname" and values of properties as
 * "msgid" parameter.
 *
 * @remark It is up to application developer to ensure that
 * translation files are properly binded to translation domain with
 * bindtextdomain function when accessibility is enabled.
 *
 * @since_tizen 2.4
 *
 * @ingroup Accessibility
 *
 * @param[in] domain No description supplied.
 *
 */
EOAPI void  elm_interface_atspi_accessible_translation_domain_set(const char *domain);

#ifdef ELM_INTERFACE_ATSPI_ACCESSIBLE_PROTECTED
/**
 *
 * Gets an localized string describing accessible object role name.
 *
 *
 */
EOAPI const char * elm_interface_atspi_accessible_localized_role_name_get(void);
#endif

/**
 *
 * @brief Sets an accessible name of the object. This string should be short,
 * human-readable name identyfing gui element.
 * @since_tizen 2.4
 *
 * Example of good accessible name for icon-only button closing the
 * application might be: "exit" or "quit".
 *
 * @remark Function parameter will not be modified or referenced afterwards.
 *
 * @ingroup Accessibility
 *
 * @param[in] name accessible name
 *
 */
EOAPI void  elm_interface_atspi_accessible_name_set(char *name);

/**
 *
 * @brief Gets an accessible name of the object.
 * @since_tizen 2.4
 *
 * @return Newly allocated string with object accessible name
 * Should be free by a user
 *
 * @ingroup Accessibility
 *
 *
 */
EOAPI char * elm_interface_atspi_accessible_name_get(void);

#ifdef ELM_INTERFACE_ATSPI_ACCESSIBLE_PROTECTED
/**
 *
 * Gets an all relations between accessible object and other accessible
 * * objects.
 * elements Should be free by a user.
 *
 *
 */
EOAPI Elm_Atspi_Relation_Set  elm_interface_atspi_accessible_relation_set_get(void);
#endif

/**
 *
 * @brief Sets role of the object in accessibility domain. Role describes
 * a class of gui elements that provides same functionality. Role list is
 * predefined.
 *
 * @since_tizen 2.4
 *
 * @ingroup Accessibility
 *
 * @param[in] role No description supplied.
 *
 */
EOAPI void  elm_interface_atspi_accessible_role_set(Elm_Atspi_Role role);

/**
 *
 * @brief Gets the role of the object in accessibility domain.
 *
 * @since_tizen 2.4
 *
 * @return Acccessible role of the object in accessibility domain
 *
 * @ingroup Accessibility
 *
 *
 */
EOAPI Elm_Atspi_Role  elm_interface_atspi_accessible_role_get(void);

#ifdef ELM_INTERFACE_ATSPI_ACCESSIBLE_PROTECTED
/**
 *
 * Gets object's accessible children.
 *
 *
 */
EOAPI Eina_List * elm_interface_atspi_accessible_children_get(void);
#endif

#ifdef ELM_INTERFACE_ATSPI_ACCESSIBLE_PROTECTED
/**
 *
 * Gets human-readable string indentifying object accessibility
 * role.
 *
 *
 */
EOAPI const char * elm_interface_atspi_accessible_role_name_get(void);
#endif

#ifdef ELM_INTERFACE_ATSPI_ACCESSIBLE_PROTECTED
/**
 *
 * Gets key-value pairs indentifying object extra
 * attributes. Must be free by a user.
 *
 *
 */
EOAPI Eina_List * elm_interface_atspi_accessible_attributes_get(void);
#endif

#ifdef ELM_INTERFACE_ATSPI_ACCESSIBLE_PROTECTED
/**
 *
 * Gets index of the child in parent's children list.
 *
 *
 */
EOAPI int  elm_interface_atspi_accessible_index_in_parent_get(void);
#endif

/**
 *
 * @brief Sets contextual information about object.
 * Description contrary to "name" property contain more verbose
 * information about object. Property may contain description of
 * functionality which given element provides in application.
 *
 * Example of good accessible description for icon-only button closing the
 * application might be: "Close the application".
 *
 * @since_tizen 2.4
 *
 * @ingroup Accessibility
 *
 * @param[in] description No description supplied.
 *
 */
EOAPI void  elm_interface_atspi_accessible_description_set(const char *description);

/**
 *
 * @brief Gets contextual information about object.
 *
 * @since_tizen 2.4
 *
 * @return Statically allocated string with contextual information
 *
 * @ingroup Accessibility
 *
 *
 */
EOAPI const char * elm_interface_atspi_accessible_description_get(void);

#ifdef ELM_INTERFACE_ATSPI_ACCESSIBLE_PROTECTED
/**
 *
 * Sets object accessible parent.
 *
 * @param[in] parent No description supplied.
 *
 */
EOAPI void  elm_interface_atspi_accessible_parent_set(Elm_Interface_Atspi_Accessible *parent);
#endif

#ifdef ELM_INTERFACE_ATSPI_ACCESSIBLE_PROTECTED
/**
 *
 * Gets object accessible parent.
 *
 *
 */
EOAPI Elm_Interface_Atspi_Accessible * elm_interface_atspi_accessible_parent_get(void);
#endif

#ifdef ELM_INTERFACE_ATSPI_ACCESSIBLE_PROTECTED
/**
 *
 * Gets set describing object accessible states.
 *
 *
 */
EOAPI Elm_Atspi_State_Set  elm_interface_atspi_accessible_state_set_get(void);
#endif

EOAPI extern const Eo_Event_Description _ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_PROPERTY_CHANGED;
EOAPI extern const Eo_Event_Description _ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_CHILDREN_CHANGED;
EOAPI extern const Eo_Event_Description _ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_STATE_CHANGED;
EOAPI extern const Eo_Event_Description _ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_VISIBLE_DATA_CHANGED;
EOAPI extern const Eo_Event_Description _ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_ACTIVE_DESCENDANT_CHANGED;

/**
 * No description
 */
#define ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_PROPERTY_CHANGED (&(_ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_PROPERTY_CHANGED))

/**
 * No description
 */
#define ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_CHILDREN_CHANGED (&(_ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_CHILDREN_CHANGED))

/**
 * No description
 */
#define ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_STATE_CHANGED (&(_ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_STATE_CHANGED))

/**
 * No description
 */
#define ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_VISIBLE_DATA_CHANGED (&(_ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_VISIBLE_DATA_CHANGED))

/**
 * No description
 */
#define ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_ACTIVE_DESCENDANT_CHANGED (&(_ELM_INTERFACE_ATSPI_ACCESSIBLE_EVENT_ACTIVE_DESCENDANT_CHANGED))

#endif
