#ifndef _ELM_SCROLLER_EO_LEGACY_H_
#define _ELM_SCROLLER_EO_LEGACY_H_

#ifndef _ELM_SCROLLER_EO_CLASS_TYPE
#define _ELM_SCROLLER_EO_CLASS_TYPE

typedef Eo Elm_Scroller;

#endif

#ifndef _ELM_SCROLLER_EO_TYPES
#define _ELM_SCROLLER_EO_TYPES


#endif

/**
 *
 * @brief Set event propagation on a scroller
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @remark This enables or disables event propagation from the scroller
 * content to the scroller and its parent. By default event
 * propagation is @b enabled.
 *
 * @ingroup Scroller
 *
 * @param[in] obj The elm scroller object
 * @param[in] propagation If propagation is enabled or not
 */
EAPI void elm_scroller_propagate_events_set(Elm_Scroller *obj, Eina_Bool propagation);

/**
 *
 * @brief Get event propagation for a scroller
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @return The propagation state
 *
 * @remark This gets the event propagation for a scroller.
 *
 * @see elm_scroller_propagate_events_set()
 *
 * @ingroup Scroller
 *
 * @param[in] obj The elm scroller object
 */
EAPI Eina_Bool elm_scroller_propagate_events_get(const Elm_Scroller *obj);

/**
 *
 * Set custom theme elements for the scroller
 *
 * @param[in] obj The elm scroller object
 * @param[in] klass No description supplied.
 * @param[in] group No description supplied.
 */
//EAPI void elm_scroller_custom_widget_base_theme_set(Elm_Scroller *obj, const char *klass, const char *group);

/**
 *
 * @brief Set the maximum of the movable page at a flicking.
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @remark The value of maximum movable page should be more than 1.
 *
 * @see elm_scroller_page_scroll_limit_get()
 *
 * @since 1.8
 *
 * @ingroup Scroller
 * 
 *
 * @param[in] obj The elm scroller object
 * @param[in] page_limit_h The maximum of the movable horizontal page
 * @param[in] page_limit_v The maximum of the movable vertical page
 */
EAPI void elm_scroller_page_scroll_limit_set(const Elm_Scroller *obj, int page_limit_h, int page_limit_v);

/**
 *
 * @brief Get the maximum of the movable page at a flicking.
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @see elm_scroller_page_scroll_limit_set()
 *
 * @since 1.8
 *
 * @ingroup Scroller
 * 
 *
 * @param[in] obj The elm scroller object
 * @param[in] page_limit_h The maximum of the movable horizontal page
 * @param[in] page_limit_v The maximum of the movable vertical page
 */
EAPI void elm_scroller_page_scroll_limit_get(const Elm_Scroller *obj, int *page_limit_h, int *page_limit_v);

#endif
