#ifndef _ELM_HOVERSEL_EO_LEGACY_H_
#define _ELM_HOVERSEL_EO_LEGACY_H_

#ifndef _ELM_HOVERSEL_EO_CLASS_TYPE
#define _ELM_HOVERSEL_EO_CLASS_TYPE

typedef Eo Elm_Hoversel;

#endif

#ifndef _ELM_HOVERSEL_EO_TYPES
#define _ELM_HOVERSEL_EO_TYPES


#endif

/**
 *
 * @MOBILE_ONLY
 *
 * @brief This sets the hoversel to expand horizontally.
 *
 * @if MOBILE @since_tizen 2.4
 * @endif
 *
 * @note The initial button will display horizontally regardless of this
 * setting.
 *
 * @ingroup Hoversel
 *
 * @param[in] obj The elm hoversel object
 * @param[in] horizontal If true, the hover will expand horizontally to the
right.
 */
EAPI void elm_hoversel_horizontal_set(Elm_Hoversel *obj, Eina_Bool horizontal);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief This returns whether the hoversel is set to expand horizontally.
 *
 * @if MOBILE @since_tizen 2.4
 * @endif
 *
 * @return If true, the hover will expand horizontally to the right.
 *
 * @see elm_hoversel_horizontal_set()
 *
 * @ingroup Hoversel
 *
 * @param[in] obj The elm hoversel object
 */
EAPI Eina_Bool elm_hoversel_horizontal_get(const Elm_Hoversel *obj);

/**
 *
 * @MOBILE_ONLY
 * @brief Set the Hover parent
 *
 * @if MOBILE @since_tizen 2.4
 * @endif
 *
 * @remark Sets the hover parent object, the area that will be darkened when the
 * hoversel is clicked. Should probably be the window that the hoversel is
 * in. See @ref Hover objects for more information.
 *
 * @ingroup Hoversel
 *
 * @param[in] obj The elm hoversel object
 * @param[in] parent The parent to use
 */
EAPI void elm_hoversel_hover_parent_set(Elm_Hoversel *obj, Evas_Object *parent);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Get the Hover parent
 *
 * @if MOBILE @since_tizen 2.4
 * @endif
 *
 * @return The used parent
 *
 * @remark Get the hover parent object.
 *
 * @see elm_hoversel_hover_parent_set()
 *
 * @ingroup Hoversel
 *
 * @param[in] obj The elm hoversel object
 */
EAPI Evas_Object *elm_hoversel_hover_parent_get(const Elm_Hoversel *obj);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Returns whether the hoversel is expanded.
 *
 * @if MOBILE @since_tizen 2.4
 * @endif
 *
 * @return This will return @c EINA_TRUE if the hoversel is expanded or
 * @c EINA_FALSE if it is not expanded.
 *
 * @ingroup Hoversel
 *
 * @param[in] obj The elm hoversel object
 */
EAPI Eina_Bool elm_hoversel_expanded_get(const Elm_Hoversel *obj);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Get the list of items within the given hoversel.
 *
 * @if MOBILE @since_tizen 2.4
 * @endif
 *
 * @return Returns a list of Elm_Object_Item
 *
 * @see elm_hoversel_item_add()
 *
 * @ingroup Hoversel
 *
 * @param[in] obj The elm hoversel object
 */
EAPI const Eina_List *elm_hoversel_items_get(const Elm_Hoversel *obj);

/**
 *
 * @internal
 *
 * @brief Returns whether the contents of hoversel are scrollable or not.
 *
 * @if MOBILE @since_tizen 2.4
 * @endif
 *
 * @return @c EINA_TRUE scrollable. @c EINA_FALSE otherwise.
 *
 * @ingroup Hoversel
 *
 * @param[in] obj The elm hoversel object
 * @param[in] scrollable No description supplied.
 */
//EAPI void elm_hoversel_scrollable_set(Elm_Hoversel *obj, Eina_Bool scrollable);

/**
 *
 * @internal
 *
 * @brief Limit the size of contents and make them scrollable.
 *
 * @if MOBILE @since_tizen 2.4
 * @endif
 *
 * @ingroup Hoversel
 *
 * @param[in] obj The elm hoversel object
 */
//EAPI Eina_Bool elm_hoversel_scrollable_get(const Elm_Hoversel *obj);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief This triggers the hoversel popup from code, the same as if the user
 * had clicked the button.
 *
 * @if MOBILE @since_tizen 2.4
 * @endif
 *
 * @ingroup Hoversel
 * 
 *
 * @param[in] obj The elm hoversel object
 */
EAPI void elm_hoversel_hover_begin(Elm_Hoversel *obj);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief This will remove all the children items from the hoversel.
 *
 * @if MOBILE @since_tizen 2.4
 * @endif
 *
 * @warning Should @b not be called while the hoversel is active; use
 * elm_hoversel_expanded_get() to check first.
 *
 * @see elm_object_item_del()
 *
 * @ingroup Hoversel
 * 
 *
 * @param[in] obj The elm hoversel object
 */
EAPI void elm_hoversel_clear(Elm_Hoversel *obj);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief This dismisses the hoversel popup as if the user had clicked
 * outside the hover.
 *
 * @if MOBILE @since_tizen 2.4
 * @endif
 *
 * @ingroup Hoversel
 * 
 *
 * @param[in] obj The elm hoversel object
 */
EAPI void elm_hoversel_hover_end(Elm_Hoversel *obj);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Add an item to the hoversel button
 *
 * @if MOBILE @since_tizen 2.4
 * @endif
 *
 * @return A handle to the item added.
 *
 * @remark This adds an item to the hoversel to show when it is clicked. Note: if you
 * need to use an icon from an edje file then use
 * elm_hoversel_item_icon_set() right after this function, and set
 * icon_file to NULL here.
 * For more information on what @p icon_file and @p icon_type are, see the
 * @ref Icon "icon documentation".
 *
 * @ingroup Hoversel
 * 
 *
 * @param[in] obj The elm hoversel object
 * @param[in] label The text label to use for the item (NULL if not desired)
 * @param[in] icon_file An image file path on disk to use for the icon or standard
icon name (NULL if not desired)
 * @param[in] icon_type The icon type if relevant
 * @param[in] func Convenience function to call when this item is selected. The last
parameter @p event_info of @c func is the selected item pointer.
 * @param[in] data Data to pass to item-related functions
 */
EAPI Elm_Object_Item *elm_hoversel_item_add(Elm_Hoversel *obj, const char *label, const char *icon_file, Elm_Icon_Type icon_type, Evas_Smart_Cb func, const void *data);

#endif
