#ifndef _ELM_INTERFACE_ATSPI_COMPONENT_EO_LEGACY_H_
#define _ELM_INTERFACE_ATSPI_COMPONENT_EO_LEGACY_H_

#ifndef _ELM_INTERFACE_ATSPI_COMPONENT_EO_CLASS_TYPE
#define _ELM_INTERFACE_ATSPI_COMPONENT_EO_CLASS_TYPE

typedef Eo Elm_Interface_Atspi_Component;

#endif

#ifndef _ELM_INTERFACE_ATSPI_COMPONENT_EO_TYPES
#define _ELM_INTERFACE_ATSPI_COMPONENT_EO_TYPES


#endif

/**
 *
 * Sets size of accessible widget.
 *
 * @param[in] obj The elm interface atspi component * @param[in] w No description supplied.
 * @param[in] h No description supplied.
 */
//EAPI Eina_Bool elm_atspi_component_size_set(Elm_Interface_Atspi_Component *obj, int w, int h);

/**
 *
 * Gets size of accessible widget.
 *
 * @param[in] obj The elm interface atspi component * @param[out] w No description supplied.
 * @param[out] h No description supplied.
 */
//EAPI void elm_atspi_component_size_get(const Elm_Interface_Atspi_Component *obj, int *w, int *h);

/**
 *
 * Sets evas layer of accessible widget.
 *
 * @param[in] obj The elm interface atspi component */
//EAPI int elm_atspi_component_layer_get(const Elm_Interface_Atspi_Component *obj);

/**
 *
 * Gets alpha of accessible widget.
 *
 * @param[in] obj The elm interface atspi component */
//EAPI double elm_atspi_component_alpha_get(const Elm_Interface_Atspi_Component *obj);

/**
 *
 * Gets the depth at which the component is shown in relation to
 * other components in the same container.
 *
 * @param[in] obj The elm interface atspi component */
//EAPI int elm_atspi_component_z_order_get(const Elm_Interface_Atspi_Component *obj);

/**
 *
 * Sets geometry of accessible widget.
 *
 * @param[in] obj The elm interface atspi component * @param[in] screen_coords If true x and y values will be relative
to screen origin, otherwise relative to
canvas
 * @param[in] x No description supplied.
 * @param[in] y No description supplied.
 * @param[in] w No description supplied.
 * @param[in] h No description supplied.
 */
//EAPI Eina_Bool elm_atspi_component_extents_set(Elm_Interface_Atspi_Component *obj, Eina_Bool screen_coords, int x, int y, int w, int h);

/**
 *
 * Gets geometry of accessible widget.
 *
 * @param[in] obj The elm interface atspi component * @param[in] screen_coords If true x and y values will be relative
to screen origin, otherwise relative to
canvas
 * @param[out] x No description supplied.
 * @param[out] y No description supplied.
 * @param[out] w No description supplied.
 * @param[out] h No description supplied.
 */
//EAPI void elm_atspi_component_extents_get(const Elm_Interface_Atspi_Component *obj, Eina_Bool screen_coords, int *x, int *y, int *w, int *h);

/**
 *
 * Sets position of accessible widget.
 *
 * @param[in] obj The elm interface atspi component * @param[in] screen_coords If true x and y values will be relative
to screen origin, otherwise relative to
canvas
 * @param[in] x No description supplied.
 * @param[in] y No description supplied.
 */
//EAPI Eina_Bool elm_atspi_component_position_set(Elm_Interface_Atspi_Component *obj, Eina_Bool screen_coords, int x, int y);

/**
 *
 * Gets position of accessible widget.
 *
 * @param[in] obj The elm interface atspi component * @param[in] screen_coords If true x and y values will be relative
to screen origin, otherwise relative to
canvas
 * @param[out] x No description supplied.
 * @param[out] y No description supplied.
 */
//EAPI void elm_atspi_component_position_get(const Elm_Interface_Atspi_Component *obj, Eina_Bool screen_coords, int *x, int *y);

/**
 *
 * No description supplied.
 *
 * @param[in] obj The elm interface atspi component * @param[in] index No description supplied.
 */
//EAPI void elm_atspi_component_highlight_index_set(Elm_Interface_Atspi_Component *obj, int index);

/**
 *
 * No description supplied.
 *
 * @param[in] obj The elm interface atspi component */
//EAPI int elm_atspi_component_highlight_index_get(const Elm_Interface_Atspi_Component *obj);

/**
 *
 * No description supplied.
 *
 * @param[in] obj The elm interface atspi component * @param[in] screen_coords If true x and y values will be relative
to screen origin, otherwise relative to
canvas
 * @param[in] x No description supplied.
 * @param[in] y No description supplied.
 */
//EAPI Eina_Bool elm_atspi_component_contains(Elm_Interface_Atspi_Component *obj, Eina_Bool screen_coords, int x, int y);

/**
 *
 * Focuses accessible widget.
 *
 * @return true if focus grab focus has successed, false otherwise.
 * 
 *
 * @param[in] obj The elm interface atspi component */
//EAPI Eina_Bool elm_atspi_component_focus_grab(Elm_Interface_Atspi_Component *obj);

/**
 *
 * Highlights accessible widget.
 *
 * @return true if highlight grab has successed, false otherwise.
 * 
 *
 * @param[in] obj The elm interface atspi component */
//EAPI Eina_Bool elm_atspi_component_highlight_grab(Elm_Interface_Atspi_Component *obj);

/**
 *
 * Clears highlight of accessible widget.
 *
 * @return true if clear has successed, false otherwise.
 * 
 *
 * @param[in] obj The elm interface atspi component */
//EAPI Eina_Bool elm_atspi_component_highlight_clear(Elm_Interface_Atspi_Component *obj);

/**
 *
 * Gets top component object occupying space at given coordinates.
 * 
 *
 * @param[in] obj The elm interface atspi component * @param[in] screen_coords If true x and y values will be relative
to screen origin, otherwise relative to
canvas
 * @param[in] x No description supplied.
 * @param[in] y No description supplied.
 */
//EAPI Eo *elm_atspi_component_accessible_at_point_get(Elm_Interface_Atspi_Component *obj, Eina_Bool screen_coords, int x, int y);

#endif
