#ifndef _ELM_PANEL_EO_LEGACY_H_
#define _ELM_PANEL_EO_LEGACY_H_

#ifndef _ELM_PANEL_EO_CLASS_TYPE
#define _ELM_PANEL_EO_CLASS_TYPE

typedef Eo Elm_Panel;

#endif

#ifndef _ELM_PANEL_EO_TYPES
#define _ELM_PANEL_EO_TYPES


#endif

/**
 *
 * @brief Sets the orientation of the panel
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @remark Sets from where the panel will (dis)appear.
 *
 * @ingroup Panel
 *
 * @param[in] obj The elm panel object
 * @param[in] orient The panel orientation. Can be one of the following:
@li #ELM_PANEL_ORIENT_TOP
@li #ELM_PANEL_ORIENT_LEFT
@li #ELM_PANEL_ORIENT_RIGHT
 */
EAPI void elm_panel_orient_set(Elm_Panel *obj, Elm_Panel_Orient orient);

/**
 *
 * @brief Get the orientation of the panel.
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @return The Elm_Panel_Orient, or #ELM_PANEL_ORIENT_LEFT on failure.
 *
 * @ingroup Panel
 *
 * @param[in] obj The elm panel object
 */
EAPI Elm_Panel_Orient elm_panel_orient_get(const Elm_Panel *obj);

/**
 *
 * @brief Set the state of the panel.
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @ingroup Panel
 *
 * @param[in] obj The elm panel object
 * @param[in] hidden If true, the panel will run the animation to disappear.
 */
EAPI void elm_panel_hidden_set(Elm_Panel *obj, Eina_Bool hidden);

/**
 *
 * @brief Get the state of the panel.
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @return EINA_TRUE if it is hidden state
 *
 * @ingroup Panel
 *
 * @param[in] obj The elm panel object
 */
EAPI Eina_Bool elm_panel_hidden_get(const Elm_Panel *obj);

/**
 *
 * @brief Set the scrollability of the panel.
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @ingroup Panel
 *
 * @param[in] obj The elm panel object
 * @param[in] scrollable No description supplied.
 */
EAPI void elm_panel_scrollable_set(Elm_Panel *obj, Eina_Bool scrollable);

/**
 *
 * @internal
 *
 * @brief Get the state of the scrollability.
 *
 * @return EINA_TRUE if it is scrollable
 *
 * @ingroup Panel
 * @since 1.12
 *
 * @param[in] obj The elm panel object
 */
//EAPI Eina_Bool elm_panel_scrollable_get(const Elm_Panel *obj);

/**
 *
 * @internal
 *
 * @brief Set the size of the scrollable panel.
 *
 * @ingroup Panel
 *
 * @param[in] obj The elm panel object
 * @param[in] ratio No description supplied.
 */
//EAPI void elm_panel_scrollable_content_size_set(Elm_Panel *obj, double ratio);

/**
 *
 * @brief Toggle the hidden state of the panel from code
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @ingroup Panel
 * 
 *
 * @param[in] obj The elm panel object
 */
EAPI void elm_panel_toggle(Elm_Panel *obj);

#endif
