#ifndef _EFL_VG_BASE_EO_LEGACY_H_
#define _EFL_VG_BASE_EO_LEGACY_H_

#ifndef _EFL_VG_BASE_EO_CLASS_TYPE
#define _EFL_VG_BASE_EO_CLASS_TYPE

typedef Eo Efl_VG_Base;

#endif

#ifndef _EFL_VG_BASE_EO_TYPES
#define _EFL_VG_BASE_EO_TYPES


#endif

/**
 *
 * Give the bounding box in screen coordinate as being drawn.
 * It will start as the control box until it is refined once the shape
 * is computed.
 * @since 1.14
 * 
 *
 * @param[in] obj The base object
 * @param[out] r bounding box to be returned
 */
//EAPI void evas_vg_node_bounds_get(Efl_VG_Base *obj, Eina_Rectangle *r);

/**
 *
 * Sets the transformation matrix to be used for this node object.
 * @note Pass @c NULL to cancel the applied transformation.
 * @since 1.14
 *
 * @param[in] obj The base object
 * @param[in] m transformation matrix
 */
//EAPI void evas_vg_node_transformation_set(Efl_VG_Base *obj, const Eina_Matrix3 *m);

/**
 *
 * Gets the transformation matrix used for this node object.
 * @since 1.14
 *
 * @param[in] obj The base object
 */
//EAPI const Eina_Matrix3 *evas_vg_node_transformation_get(const Efl_VG_Base *obj);

/**
 *
 * Sets the origin position of this node object. This origin position
 * affects to node transformation
 * @since 1.14
 *
 * @param[in] obj The base object
 * @param[in] x No description supplied.
 * @param[in] y No description supplied.
 */
//EAPI void evas_vg_node_origin_set(Efl_VG_Base *obj, double x, double y);

/**
 *
 * Gets the origin position of this node object.
 * @since 1.14
 *
 * @param[in] obj The base object
 * @param[out] x No description supplied.
 * @param[out] y No description supplied.
 */
//EAPI void evas_vg_node_origin_get(const Efl_VG_Base *obj, double *x, double *y);

/**
 *
 * No description supplied.
 *
 * @param[in] obj The base object
 * @param[in] m No description supplied.
 */
//EAPI void evas_vg_node_mask_set(Efl_VG_Base *obj, Efl_VG *m);

/**
 *
 * No description supplied.
 *
 * @param[in] obj The base object
 */
//EAPI Efl_VG *evas_vg_node_mask_get(const Efl_VG_Base *obj);

#endif
