#ifndef _EVAS_COMMON_INTERFACE_EO_LEGACY_H_
#define _EVAS_COMMON_INTERFACE_EO_LEGACY_H_

#ifndef _EVAS_COMMON_INTERFACE_EO_CLASS_TYPE
#define _EVAS_COMMON_INTERFACE_EO_CLASS_TYPE

typedef Eo Evas_Common_Interface;

#endif

#ifndef _EVAS_COMMON_INTERFACE_EO_TYPES
#define _EVAS_COMMON_INTERFACE_EO_TYPES


#endif

/**
 *
 * @brief   Gets the Evas canvas that the given object lives on.
 *
 * @details This function is most useful at code contexts where you need to
 * operate on the canvas but have only the object pointer.
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @param[in]   obj  The given Evas object
 * @return  A pointer to the canvas where the object is on
 *
 * @ingroup Evas_Object_Group_Basic
 *
 * @param[in] obj The common interface */
EAPI Evas *evas_object_evas_get(const Evas_Common_Interface *obj);

#endif
