#ifndef _ELM_INDEX_ITEM_EO_H_
#define _ELM_INDEX_ITEM_EO_H_

#ifndef _ELM_INDEX_ITEM_EO_CLASS_TYPE
#define _ELM_INDEX_ITEM_EO_CLASS_TYPE

typedef Eo Elm_Index_Item;

#endif

#ifndef _ELM_INDEX_ITEM_EO_TYPES
#define _ELM_INDEX_ITEM_EO_TYPES


#endif
#define ELM_INDEX_ITEM_CLASS elm_index_item_class_get()

const Eo_Class *elm_index_item_class_get(void) EINA_CONST;

/**
 *
 * @brief Set the selected state of an item.
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @remark This sets the selected state of the given item @p it.
 * @c EINA_TRUE for selected, @c EINA_FALSE for not selected.
 *
 * @remark If a new item is selected the previously selected will be unselected.
 * Previously selected item can be get with function
 * elm_index_selected_item_get().
 *
 * @remark Selected items will be highlighted.
 *
 * @see elm_index_selected_item_get()
 *
 * @ingroup Index
 *
 * @param[in] selected EINA_TRUE if selected EINA_FALSE otherwise
 *
 */
EOAPI void  elm_obj_index_item_selected_set(Eina_Bool selected);

/**
 *
 * @internal
 *
 * Sets the priority of an item.
 *
 * The priority is @c -1 by default, which means that the item doesn't belong to a group.
 * The value of the priority starts from @c 0.
 *
 * In elm_index_level_go, the items are sorted in ascending order according to priority.
 * Items of the same priority make a group and the primary group is shown by default.
 *
 * @see elm_index_item_priority_get()
 *
 * @ingroup Index
 *
 * @param[in] priority The priority
 *
 */
EOAPI void  elm_obj_index_item_priority_set(int priority);

/**
 *
 * @brief Get the letter (string) set on a given index widget item.
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @return The letter string set on @p item
 *
 * @ingroup Index
 * 
 *
 *
 */
EOAPI const char * elm_obj_index_item_letter_get(void);


#endif
