#ifndef _EFL_VG_BASE_EO_H_
#define _EFL_VG_BASE_EO_H_

#ifndef _EFL_VG_BASE_EO_CLASS_TYPE
#define _EFL_VG_BASE_EO_CLASS_TYPE

typedef Eo Efl_VG_Base;

#endif

#ifndef _EFL_VG_BASE_EO_TYPES
#define _EFL_VG_BASE_EO_TYPES


#endif
#define EFL_VG_BASE_CLASS efl_vg_base_class_get()

const Eo_Class *efl_vg_base_class_get(void) EINA_CONST;

/**
 *
 * Give the bounding box in screen coordinate as being drawn.
 * It will start as the control box until it is refined once the shape
 * is computed.
 * @since 1.14
 * 
 *
 * @param[out] r bounding box to be returned
 *
 */
EOAPI void  efl_vg_bounds_get(Eina_Rectangle *r);

/**
 *
 * Sets the transformation matrix to be used for this node object.
 * @note Pass @c NULL to cancel the applied transformation.
 * @since 1.14
 *
 * @param[in] m transformation matrix
 *
 */
EOAPI void  efl_vg_transformation_set(const Eina_Matrix3 *m);

/**
 *
 * Gets the transformation matrix used for this node object.
 * @since 1.14
 *
 *
 */
EOAPI const Eina_Matrix3 * efl_vg_transformation_get(void);

/**
 *
 * Sets the origin position of this node object. This origin position
 * affects to node transformation
 * @since 1.14
 *
 * @param[in] x No description supplied.
 * @param[in] y No description supplied.
 *
 */
EOAPI void  efl_vg_origin_set(double x, double y);

/**
 *
 * Gets the origin position of this node object.
 * @since 1.14
 *
 * @param[out] x No description supplied.
 * @param[out] y No description supplied.
 *
 */
EOAPI void  efl_vg_origin_get(double *x, double *y);

/**
 *
 * No description supplied.
 *
 * @param[in] m No description supplied.
 *
 */
EOAPI void  efl_vg_mask_set(Efl_VG *m);

/**
 *
 * No description supplied.
 *
 *
 */
EOAPI Efl_VG * efl_vg_mask_get(void);


#endif
