#include "$(appName).h"

static bool
view1_back(ui_view *view, void *user_data)
{
	/* Page back is requested. */

	return true;
}

static bool
view1_menu(ui_view *view, void *user_data)
{
	/* Page menu is requested. */
	//ui_menu *menu = ui_view_get_menu(view);

	return true;

}

static bool
view1_rotate(ui_view *view, void *user_data)
{
	/* Page is rotated. */

	if (ui_view_get_orientation_mode(view) == UI_VIEW_ORIENTATION_MODE_PORTRAIT) {
		/* Portrait mode. */
	} else {
		/* Landscape mode. */
	}

	return true;
}

static bool
view1_destroy(ui_view *view, void *user_data)
{
	/* This page is destroyed. Free page resources here. */

	return true;
}

static bool
view1_unload(ui_view *view, void *user_data)
{
	/* Hook to take necessary actions when page is unloaded. */

	return true;
}

static bool
view1_load(ui_view *view, void *user_data)
{
	/* Hook to take necessary actions when page is loaded.
		Create page contents here. */

	Eo *content = NULL;
	Eo *base = NULL;
	int ret;

	//Get a base object from view.
	base = ui_view_get_base(view);

	//Create and set a main content.
	content = elm_label_add(base);
	if (!content) return false;

	elm_object_text_set(content, "<align=center>Hello Tizen</align>");
	evas_object_size_hint_weight_set(content, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);

	//Set Main Content
	ret = ui_view_set_content(view, content);
	if (ret != UI_VIEWMGR_ERROR_NONE) {
		dlog_print(DLOG_ERROR, LOG_TAG, "ui_view_set_content() is failed. err = %d", ret);
		ui_view_destroy(view);
		return false;
	}

	return true;
}

void
create_view1()
{
	int ret = 0;
	ui_view *view = NULL;
	int i;

	ui_view_event_type_e events[6] = {
		UI_VIEW_EVENT_LOAD,
		UI_VIEW_EVENT_UNLOAD,
		UI_VIEW_EVENT_DESTROY,
		UI_VIEW_EVENT_ROTATE,
		UI_VIEW_EVENT_MENU,
		UI_VIEW_EVENT_BACK
	};

	ui_view_event_cb event_cbs[6] = {
		view1_load,
		view1_unload,
		view1_destroy,
		view1_rotate,
		view1_menu,
		view1_back
	};

	//Create a view.
	view = ui_view_create("view1");
	if (!view) {
		dlog_print(DLOG_ERROR, LOG_TAG, "failed to create a view");
		return;
	}

	//Set view event callbacks.
	for (i = 0; i < 6; i++)	{
		ret = ui_view_set_event_cb(view, events[i], event_cbs[i], NULL);
		if (ret != UI_VIEWMGR_ERROR_NONE) {
			dlog_print(DLOG_ERROR, LOG_TAG, "ui_view_set_event_cb() idx = %d is failed. err = %d", i, ret);
			ui_view_destroy(view);
			return;
		}
	}

	//Push a view.
	ret = ui_viewmgr_push_view(view);
	if (ret != UI_VIEWMGR_ERROR_NONE) {
		dlog_print(DLOG_ERROR, LOG_TAG, "ui_viewmgr_push_view() is failed. err = %d", ret);
		ui_view_destroy(view);
	}
}
