#ifndef _EEXT_FLOATINGBUTTON_EO_H_
#define _EEXT_FLOATINGBUTTON_EO_H_

#ifndef _EEXT_FLOATINGBUTTON_EO_CLASS_TYPE
#define _EEXT_FLOATINGBUTTON_EO_CLASS_TYPE

typedef Eo Eext_Floatingbutton;

#endif

#ifndef _EEXT_FLOATINGBUTTON_EO_TYPES
#define _EEXT_FLOATINGBUTTON_EO_TYPES

/** Positions where floatingbutton can be placed on
 *
 * @ingroup Eext_Floatingbutton
 */
typedef enum
{
  EEXT_FLOATINGBUTTON_LEFT_OUT = 0, /**< hides in the left, but only shows small
                                     * handler */
  EEXT_FLOATINGBUTTON_LEFT, /**< shows all of buttons, but lies on the left */
  EEXT_FLOATINGBUTTON_CENTER, /**< shows all of buttons, but lies on the center
                               */
  EEXT_FLOATINGBUTTON_RIGHT, /**< shows all of buttons, but lies on the right */
  EEXT_FLOATINGBUTTON_RIGHT_OUT, /**< hides in the right, but only shows small
                                  * handler */
  EEXT_FLOATINGBUTTON_LAST /**< indicates the last, do not use this */
} Eext_Floatingbutton_Pos;

/** Modes that change available positions for floatingbutton
 *
 * @ingroup Eext_Floatingbutton
 */
typedef enum
{
  EEXT_FLOATINGBUTTON_MODE_DEFAULT = 0, /**< allows all positions */
  EEXT_FLOATINGBUTTON_MODE_BOTH_SIDES, /**< allows LEFT and RIGHT positions only
                                        */
  EEXT_FLOATINGBUTTON_MODE_LAST /**< indicates the last, do not use this */
} Eext_Floatingbutton_Mode;


#endif
#define EEXT_FLOATINGBUTTON_CLASS eext_floatingbutton_class_get()

EAPI const Eo_Class *eext_floatingbutton_class_get(void) EINA_CONST;

/**
 * @brief Sets the floatingbutton position.
 *
 * The floatingbutton can be moved among predefined positions (LEFT_OUT, LEFT,
 * CENTER, RIGHT, RIGHT_OUT), eext_floatingbutton_pos_set() moves
 * floatingbutton to a given position immediately (without animation).
 *
 * return @c EINA_TRUE on success, @c EINA_FALSE otherwise.
 *
 * @if MOBILE @since_tizen 2.4 @endif
 *
 * @param[in] pos The floatingbutton position
 *
 * @ingroup Eext_Floatingbutton
 */
EOAPI Eina_Bool  eext_obj_floatingbutton_pos_set(Eext_Floatingbutton_Pos pos);

/**
 * @brief Gets the floatingbutton position.
 *
 * return Floatingbutton position with Eext_Floatingbutton_Pos enumeration.
 *
 * see @ref eext_obj_floatingbutton_pos_set().
 *
 * @if MOBILE @since_tizen 2.4 @endif
 *
 * @return The floatingbutton position
 *
 * @ingroup Eext_Floatingbutton
 */
EOAPI Eext_Floatingbutton_Pos  eext_obj_floatingbutton_pos_get(void);

/**
 * @brief Sets whether floatingbutton can be moved or not.
 *
 * By default, floatingbutton is movable by user interaction.
 *
 * @if MOBILE @since_tizen 2.4 @endif
 *
 * @param[in] block The floatingbutton movability
 *
 * @ingroup Eext_Floatingbutton
 */
EOAPI void  eext_obj_floatingbutton_movement_block_set(Eina_Bool block);

/**
 * @brief Gets movability for a given floatingbutton widget.
 *
 * return @c EINA_TRUE, if obj is set to be unmovable, @c EINA_FALSE, if it's
 * movable.
 *
 * see @ref eext_obj_floatingbutton_movement_block_set().
 *
 * @if MOBILE @since_tizen 2.4 @endif
 *
 * @return The floatingbutton movability
 *
 * @ingroup Eext_Floatingbutton
 */
EOAPI Eina_Bool  eext_obj_floatingbutton_movement_block_get(void);

/**
 * @brief Sets floatingbutton mode.
 *
 * Positions where floatingbutton can stop are restrained by mode.
 *
 * @if MOBILE @since_tizen 2.4 @endif
 *
 * @param[in] mode Floatingbutton mode
 *
 * @ingroup Eext_Floatingbutton
 */
EOAPI void  eext_obj_floatingbutton_mode_set(Eext_Floatingbutton_Mode mode);

/**
 * @brief Gets floatingbutton mode.
 *
 * see @ref eext_obj_floatingbutton_mode_set().
 *
 * @if MOBILE @since_tizen 2.4 @endif
 *
 * @return Floatingbutton mode
 *
 * @ingroup Eext_Floatingbutton
 */
EOAPI Eext_Floatingbutton_Mode  eext_obj_floatingbutton_mode_get(void);

/**
 * @brief Sets the floatingbutton position with animation.
 *
 * Move floatingbutton similar to eext_floatingbutton_pos_set(), but with
 * animation.
 *
 * return @c EINA_TRUE on success, @c EINA_FALSE otherwise.
 *
 * see @ref eext_obj_floatingbutton_pos_set().
 *
 * @if MOBILE @since_tizen 2.4 @endif
 *
 * @param[in] pos The floatingbutton position
 *
 * @ingroup Eext_Floatingbutton
 */
EOAPI Eina_Bool  eext_obj_floatingbutton_pos_bring_in(const Eext_Floatingbutton_Pos pos);


#endif
