#include "$(appName).h"

static bool
app_create(void *user_data, void *event_info)
{
	/* Hook to take necessary actions before main event loop starts.
		Initialize Application base resources.
		If this function returns true, the main loop of application starts. */

	create_view1();

	return true;
}

static bool
app_control(void *user_data, void *event_info)
{
	//app_control_h app_control = (app_control_h) event_info;

	/* Handle the launch request. */

	return true;
}

static bool
app_terminate(void *data, void *event_info)
{
	/* Release all application base resources. */

	return true;
}

int
main(int argc, char *argv[])
{
	int ret;
	/* Application event callbacks. */
	ui_application_event_s events[] = {
		{UI_APPLICATION_EVENT_CREATE, app_create},
		{UI_APPLICATION_EVENT_TERMINATE, app_terminate},
		{UI_APPLICATION_EVENT_CONTROL, app_control},
	};

	//Initialize ui_app.
	ret =  ui_application_init();
	if (ret != UI_VIEWMGR_ERROR_NONE) {
		dlog_print(DLOG_ERROR, LOG_TAG, "ui_app_init() is failed, ret = %d", ret);
		return ret;
	}

	//Run ui_app. It runs application mainloop.
	ret = ui_application_run(argc, argv, events, 3, NULL);
	if (ret != UI_VIEWMGR_ERROR_NONE) {
		dlog_print(DLOG_ERROR, LOG_TAG, "ui_app_run() is failed, ret = %d", ret);
		return ret;
	}

	return 0;
}
