/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.nfc.ui;

import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import org.json.simple.JSONObject;
import org.tizen.ecp.nfc.ui.NFCController;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.ECPFXMLLoader;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.popup.ECPPopupPane;

public class NFCPane
extends ECPPopupPane {
    static final URL NFC_CSS = NFCPane.class.getResource("/org/tizen/ecp/nfc/ui/nfc.css");
    private NFCController controller;
    Logger logger = LogUtil.getECPLogger(NFCPane.class).getLogger();

    public void onCreate() {
        EventMgr.getInstance().AddLsn("nfc", (ILsn)this);
    }

    public void onShow() {
        MessageSender.getInstance().sendDeviceReq("nfc", 15, 0);
    }

    public Pane create() {
        AnchorPane anchorPane;
        URL uRL = ((Object)((Object)this)).getClass().getResource("/org/tizen/ecp/nfc/ui/nfcPopup.fxml");
        ECPFXMLLoader eCPFXMLLoader = new ECPFXMLLoader(uRL, new Object[0]);
        try {
            anchorPane = (AnchorPane)eCPFXMLLoader.load();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.controller = (NFCController)eCPFXMLLoader.getController();
        anchorPane.getStylesheets().add((Object)NFC_CSS.toExternalForm());
        return anchorPane;
    }

    public void OnEventProc(String string, JSONObject jSONObject) {
        this.controller.handleEventProc(string, jSONObject);
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
        this.controller.handleStatusEventProcPB(generatedMessage);
    }
}

