/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sensor.axis.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.StringProperty;
import javafx.event.EventHandler;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javax.swing.Timer;
import org.tizen.ecp.sensor.axis.gui.CANVAS_MODE;
import org.tizen.ecp.sensor.axis.gui.FXMLSensorGuiController;
import org.tizen.ecp.sensor.axis.gui.Magnetic;
import org.tizen.ecp.sensor.axis.gui.Vector;
import org.tizen.ecp.sock.IConnection;
import org.tizen.ecp.sock.SocketClient;

public class MobileCanvas
implements IConnection {
    double read_accelx;
    double read_accely;
    double read_accelz;
    double read_yaw;
    double read_pitch;
    double read_roll;
    long accel_update_duration;
    long accel_next_update;
    long orientation_update_duration;
    long orientation_next_update;
    long user_settings_duration;
    long user_settings_next_update;
    double partial_accelx;
    double partial_accely;
    double partial_accelz;
    int partial_accel_n;
    boolean average_accel;
    double partial_yaw;
    double partial_pitch;
    double partial_roll;
    int partial_orientation_n;
    boolean average_orientation;
    double accelx;
    double accely;
    double accelz;
    double yaw;
    double pitch;
    double roll;
    DoubleProperty yawDegree;
    DoubleProperty pitchDegree;
    DoubleProperty rollDegree;
    StringProperty accelerationData;
    StringProperty magneticData;
    StringProperty gyroData;
    int movex;
    int movez;
    double vx;
    double vz;
    double ax;
    double az;
    double Fx;
    double Fz;
    double accx;
    double accz;
    double k;
    double m;
    double gamma;
    double dt;
    double meterperpixel;
    double g;
    double ginverse;
    int mousedownx;
    int mousedowny;
    int mousedownyaw;
    int mousedownpitch;
    int mousedownroll;
    int mousedownmovex;
    int mousedownmovez;
    boolean gyroStart;
    double old_gyroYaw;
    double old_gyroPitch;
    double old_gyroRoll;
    int gyroYawCount;
    int gyroPitchCount;
    int gyroRollCount;
    private double old_gyro_rollDegree = 0.0;
    private double old_gyro_pitchDegree = 0.0;
    private double old_gyro_yawDegree = 0.0;
    private double[] gyro_axisX;
    private double[] gyro_axisY;
    private double[] gyro_axisZ;
    double gyroYaw;
    double gyroPitch;
    double gyroRoll;
    private boolean phone_pos_conv = false;
    private boolean is_Axis = false;
    private Canvas canvas;
    private Timer timer;
    private Timer geomagneticTimer;
    private Timer gyroTimer;
    private boolean connected = false;
    private CANVAS_MODE mode = CANVAS_MODE.YAW_PITCH;
    static final double sx = 21.0;
    static final double sy = 56.0;
    static final double sz = 7.0;
    static final double dx = 16.799999999999997;
    static final double dy1 = 46.199999999999996;
    static final double dy2 = -21.0;
    static final double xAxisLen = -35.0;
    static final double yAxisLen = -75.0;
    static final double zAxisLen = -25.0;
    double[][] phone = new double[][]{{21.0, 56.0, -7.0}, {-21.0, 56.0, -7.0}, {-21.0, 56.0, -7.0}, {-21.0, -56.0, -7.0}, {-21.0, -56.0, -7.0}, {21.0, -56.0, -7.0}, {21.0, -56.0, -7.0}, {21.0, 56.0, -7.0}, {21.0, 56.0, 7.0}, {-21.0, 56.0, 7.0}, {-21.0, 56.0, 7.0}, {-21.0, -56.0, 7.0}, {-21.0, -56.0, 7.0}, {21.0, -56.0, 7.0}, {21.0, -56.0, 7.0}, {21.0, 56.0, 7.0}, {21.0, 56.0, -7.0}, {21.0, 56.0, 7.0}, {-21.0, 56.0, -7.0}, {-21.0, 56.0, 7.0}, {-21.0, -56.0, -7.0}, {-21.0, -56.0, 7.0}, {21.0, -56.0, -7.0}, {21.0, -56.0, 7.0}, {16.799999999999997, 46.199999999999996, 7.0}, {-16.799999999999997, 46.199999999999996, 7.0}, {-16.799999999999997, 46.199999999999996, 7.0}, {-16.799999999999997, -21.0, 7.0}, {-16.799999999999997, -21.0, 7.0}, {16.799999999999997, -21.0, 7.0}, {16.799999999999997, -21.0, 7.0}, {16.799999999999997, 46.199999999999996, 7.0}, {-35.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, -75.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, -25.0}, {0.0, 0.0, 0.0}};

    public void init_values() {
        double[] dArray = new double[]{1.0, 0.0, 0.0};
        double[] dArray2 = new double[]{0.0, 0.0, 1.0};
        double[] dArray3 = new double[]{0.0, -1.0, 0.0};
        this.setGyroAxisX(dArray);
        this.setGyroAxisY(dArray2);
        this.setGyroAxisZ(dArray3);
        this.repaint();
        this.rollDegree.set(0.0);
        this.pitchDegree.set(0.0);
        this.yawDegree.set(0.0);
        this.old_gyro_rollDegree = 0.0;
        this.old_gyro_pitchDegree = 0.0;
        this.old_gyro_yawDegree = 0.0;
        Magnetic magnetic = Magnetic.getInstance();
        magnetic.setAzimuth(0);
        magnetic.setPitch(-90);
        magnetic.setRoll(0);
        this.partial_accelx = 0.0;
        this.partial_accely = 0.0;
        this.partial_accelz = 0.0;
        this.partial_accel_n = 0;
        this.partial_yaw = 0.0;
        this.partial_pitch = 0.0;
        this.partial_roll = 0.0;
        this.partial_orientation_n = 0;
    }

    public MobileCanvas(FXMLSensorGuiController fXMLSensorGuiController) {
        this.canvas = fXMLSensorGuiController.getCanvas();
        SocketClient.getInstance().registerDisconnectListener((IConnection)this);
        this.yawDegree = fXMLSensorGuiController.getyawDegreeProperty();
        this.pitchDegree = fXMLSensorGuiController.getPitchDegreeProperty();
        this.rollDegree = fXMLSensorGuiController.getRollDegreeProperty();
        this.accelerationData = fXMLSensorGuiController.getAceelProperty();
        this.magneticData = fXMLSensorGuiController.getMagneticProperty();
        this.gyroData = fXMLSensorGuiController.getGyroProperty();
        this.gyroYawCount = 0;
        this.gyroPitchCount = 0;
        this.gyroRollCount = 0;
        this.gyroStart = false;
        this.gyro_axisX = (double[])Vector.getAxisX().clone();
        this.gyro_axisY = (double[])Vector.getAxisY().clone();
        this.gyro_axisZ = (double[])Vector.getAxisZ().clone();
        this.movex = 0;
        this.movez = 0;
        this.Fx = 0.0;
        this.Fz = 0.0;
        this.accx = 0.0;
        this.accz = 0.0;
        this.k = 500.0;
        this.m = 1.0;
        this.gamma = 50.0;
        this.dt = 0.1;
        this.meterperpixel = 3.333333333333333E-4;
        this.g = -9.80665;
        this.ginverse = 1.0 / this.g;
        this.user_settings_duration = 500L;
        this.user_settings_next_update = System.currentTimeMillis();
        this.canvas.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                MobileCanvas.this.mousedownx = (int)mouseEvent.getX();
                MobileCanvas.this.mousedowny = (int)mouseEvent.getY();
                MobileCanvas.this.mousedownmovex = MobileCanvas.this.movex;
                MobileCanvas.this.mousedownmovez = MobileCanvas.this.movez;
            }
        });
        this.canvas.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                MobileCanvas.this.phone_pos_conv = true;
            }
        });
        this.canvas.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (MobileCanvas.this.mode == CANVAS_MODE.YAW_PITCH) {
                    int n = (int)((double)MobileCanvas.this.mousedownyaw - (mouseEvent.getX() - (double)MobileCanvas.this.mousedownx));
                    while (n > 180) {
                        n -= 360;
                        ++MobileCanvas.this.gyroYawCount;
                    }
                    while (n < -180) {
                        n += 360;
                        --MobileCanvas.this.gyroYawCount;
                    }
                    MobileCanvas.this.yawDegree.set((double)n);
                    int n2 = (int)((double)MobileCanvas.this.mousedownpitch - (mouseEvent.getY() - (double)MobileCanvas.this.mousedowny));
                    while (n2 > 270) {
                        n2 -= 360;
                        ++MobileCanvas.this.gyroPitchCount;
                    }
                    while (n2 < -90) {
                        n2 += 360;
                        --MobileCanvas.this.gyroPitchCount;
                    }
                    MobileCanvas.this.pitchDegree.set((double)n2);
                } else if (MobileCanvas.this.mode == CANVAS_MODE.ROLL_PITCH) {
                    int n = (int)((double)MobileCanvas.this.mousedownroll + (mouseEvent.getX() - (double)MobileCanvas.this.mousedownx));
                    while (n > 180) {
                        n -= 360;
                        ++MobileCanvas.this.gyroRollCount;
                    }
                    while (n < -180) {
                        n += 360;
                        --MobileCanvas.this.gyroRollCount;
                    }
                    MobileCanvas.this.rollDegree.set((double)n);
                    int n3 = (int)((double)MobileCanvas.this.mousedownpitch - (mouseEvent.getY() - (double)MobileCanvas.this.mousedowny));
                    while (n3 > 270) {
                        n3 -= 360;
                        ++MobileCanvas.this.gyroPitchCount;
                    }
                    while (n3 < -90) {
                        n3 += 360;
                        --MobileCanvas.this.gyroPitchCount;
                    }
                    MobileCanvas.this.pitchDegree.set((double)n3);
                } else if (MobileCanvas.this.mode == CANVAS_MODE.MOVE) {
                    int n;
                    int n4;
                    MobileCanvas.this.movex = n4 = (int)((double)MobileCanvas.this.mousedownmovex + (mouseEvent.getX() - (double)MobileCanvas.this.mousedownx));
                    MobileCanvas.this.movez = n = (int)((double)MobileCanvas.this.mousedownmovez - (mouseEvent.getY() - (double)MobileCanvas.this.mousedowny));
                }
                MobileCanvas.this.repaint();
            }
        });
        int n = 200;
        this.timer = new Timer(n, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MobileCanvas.this.updateSensorPhysics();
                MobileCanvas.this.updateSensorReadoutValues();
                MobileCanvas.this.updateUserSettings();
            }
        });
        this.geomagneticTimer = new Timer(n, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Magnetic magnetic = Magnetic.getInstance();
                magnetic.updateSensorPhysics(MobileCanvas.this.rollDegree.get(), MobileCanvas.this.pitchDegree.get(), MobileCanvas.this.yawDegree.get());
                magnetic.updateSensorReadoutValues();
                magnetic.setTilt(MobileCanvas.this.read_accelx, MobileCanvas.this.read_accely, MobileCanvas.this.read_accelz);
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                d = MobileCanvas.this.setRange(magnetic.getReadCompassX());
                d2 = MobileCanvas.this.setRange(magnetic.getReadCompassY());
                d3 = MobileCanvas.this.setRange(magnetic.getReadCompassZ());
                DecimalFormat decimalFormat = new DecimalFormat("#0.00");
                String string = decimalFormat.format(d) + ", " + decimalFormat.format(d2) + ", " + decimalFormat.format(d3);
                MobileCanvas.this.magneticData.set((Object)string);
            }
        });
        this.gyroTimer = new Timer(n, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MobileCanvas.this.updateSensorGyro();
            }
        });
        this.timer.setCoalesce(true);
        this.geomagneticTimer.setCoalesce(true);
        this.gyroTimer.setCoalesce(true);
    }

    private void updateSensorGyro() {
        if (!this.gyroStart) {
            this.old_gyroYaw = this.yawDegree.get();
            this.old_gyroPitch = this.pitchDegree.get();
            this.old_gyroRoll = this.rollDegree.get();
            this.gyroStart = true;
            return;
        }
        this.gyroRoll = (double)(this.gyroRollCount * 360) + this.rollDegree.get() - this.old_gyroRoll;
        this.gyroPitch = (double)(this.gyroPitchCount * 360) + this.pitchDegree.get() - this.old_gyroPitch;
        this.gyroYaw = (double)(this.gyroYawCount * 360) + this.yawDegree.get() - this.old_gyroYaw;
        this.gyroYawCount = 0;
        this.gyroPitchCount = 0;
        this.gyroRollCount = 0;
        this.old_gyroRoll = this.rollDegree.get();
        this.old_gyroPitch = this.pitchDegree.get();
        this.old_gyroYaw = this.yawDegree.get();
        this.gyroRoll = Math.min(573.0, Math.max(-573.0, this.gyroRoll));
        this.gyroPitch = Math.min(573.0, Math.max(-573.0, this.gyroPitch));
        this.gyroYaw = Math.min(573.0, Math.max(-573.0, this.gyroYaw));
        DecimalFormat decimalFormat = new DecimalFormat("#0.00");
        String string = decimalFormat.format(this.gyroPitch) + ", " + decimalFormat.format(this.gyroRoll) + ", " + decimalFormat.format(this.gyroYaw);
        this.gyroData.set((Object)string);
    }

    public void updateSensorPhysics() {
        this.dt = 0.01;
        this.g = -9.80665;
        if (this.g != 0.0) {
            this.ginverse = 1.0 / this.g;
        }
        this.k = 500.0;
        this.gamma = 50.0;
        this.Fx = this.k * ((double)this.movex - this.accx);
        this.Fz = this.k * ((double)this.movez - this.accz);
        this.ax = this.Fx / this.m;
        this.az = this.Fz / this.m;
        this.vx += this.ax * this.dt;
        this.vz += this.az * this.dt;
        this.accx += this.vx * this.dt;
        this.accz += this.vz * this.dt;
        this.accx += this.gamma * ((double)this.movex - this.accx) * this.dt;
        this.accz += this.gamma * ((double)this.movez - this.accz) * this.dt;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = -9.80665;
        Vector vector = new Vector(-this.ax * this.meterperpixel + d, d2, -this.az * this.meterperpixel + d3);
        vector.reverserollpitchyaw();
        this.accelx = vector.x;
        this.accely = vector.y;
        this.accelz = vector.z;
        double d4 = this.g * 10.0;
        if (d4 > 0.0) {
            if (this.accelx > d4) {
                this.accelx = d4;
            }
            if (this.accelx < -d4) {
                this.accelx = -d4;
            }
            if (this.accely > d4) {
                this.accely = d4;
            }
            if (this.accely < -d4) {
                this.accely = -d4;
            }
            if (this.accelz > d4) {
                this.accelz = d4;
            }
            if (this.accelz < -d4) {
                this.accelz = -d4;
            }
        }
        this.yaw = this.yawDegree.get();
        this.pitch = this.pitchDegree.get();
        this.roll = this.rollDegree.get();
        this.repaint();
    }

    public void updateSensorReadoutValues() {
        long l = System.currentTimeMillis();
        if (this.average_accel) {
            this.partial_accelx += this.accelx;
            this.partial_accely += this.accely;
            this.partial_accelz += this.accelz;
            ++this.partial_accel_n;
        }
        if (this.average_orientation) {
            this.partial_yaw += this.yaw;
            this.partial_pitch += this.pitch;
            this.partial_roll += this.roll;
            ++this.partial_orientation_n;
        }
        if (l >= this.accel_next_update) {
            this.accel_next_update += this.accel_update_duration;
            if (this.accel_next_update < l) {
                this.accel_next_update = l;
            }
            if (this.average_accel) {
                this.read_accelx = this.partial_accelx / (double)this.partial_accel_n;
                this.read_accely = this.partial_accely / (double)this.partial_accel_n;
                this.read_accelz = this.partial_accelz / (double)this.partial_accel_n;
                this.partial_accelx = 0.0;
                this.partial_accely = 0.0;
                this.partial_accelz = 0.0;
                this.partial_accel_n = 0;
            } else {
                this.read_accelx = this.accelx;
                this.read_accely = this.accely;
                this.read_accelz = this.accelz;
            }
            if (this.read_accelx / this.g > 2.0) {
                this.read_accelx = 2.0 * this.g;
            } else if (this.read_accelx / this.g < -2.0) {
                this.read_accelx = -2.0 * this.g;
            }
            if (this.read_accely / this.g > 2.0) {
                this.read_accely = 2.0 * this.g;
            } else if (this.read_accely / this.g < -2.0) {
                this.read_accely = -2.0 * this.g;
            }
            if (this.read_accelz / this.g > 2.0) {
                this.read_accelz = 2.0 * this.g;
            } else if (this.read_accelz / this.g < -2.0) {
                this.read_accelz = -2.0 * this.g;
            }
        }
        if (l >= this.orientation_next_update) {
            this.orientation_next_update += this.orientation_update_duration;
            if (this.orientation_next_update < l) {
                this.orientation_next_update = l;
            }
            if (this.average_orientation) {
                this.read_yaw = this.partial_yaw / (double)this.partial_orientation_n;
                this.read_pitch = this.partial_pitch / (double)this.partial_orientation_n;
                this.read_roll = this.partial_roll / (double)this.partial_orientation_n;
                this.partial_yaw = 0.0;
                this.partial_pitch = 0.0;
                this.partial_roll = 0.0;
                this.partial_orientation_n = 0;
            } else {
                this.read_yaw = this.yaw;
                this.read_pitch = this.pitch;
                this.read_roll = this.roll;
            }
            if (this.read_pitch < -90.0) {
                this.read_pitch = -180.0 - this.read_pitch;
                this.read_yaw += 180.0;
                this.read_roll += 180.0;
            } else if (this.read_pitch > 90.0) {
                this.read_pitch = 180.0 - this.read_pitch;
                this.read_yaw += 180.0;
                this.read_roll += 180.0;
            }
            if (this.read_yaw < 0.0) {
                this.read_yaw += 360.0;
            }
            if (this.read_yaw >= 360.0) {
                this.read_yaw -= 360.0;
            }
            if (this.read_roll >= 180.0) {
                this.read_roll -= 360.0;
            }
        }
        double d = this.setRange(this.read_accelx / this.g);
        double d2 = this.setRange(this.read_accely / this.g);
        double d3 = this.setRange(this.read_accelz / this.g);
        DecimalFormat decimalFormat = new DecimalFormat("#0.00");
        String string = decimalFormat.format(d) + ", " + decimalFormat.format(d2) + ", " + decimalFormat.format(d3);
        this.accelerationData.set((Object)string);
    }

    private double setRange(double d) {
        if (d > -0.01 && d < 0.01) {
            return 0.0;
        }
        return d;
    }

    public void updateUserSettings() {
        long l = System.currentTimeMillis();
        if (l >= this.user_settings_next_update) {
            this.user_settings_next_update += this.user_settings_duration;
            if (this.user_settings_next_update < l) {
                this.user_settings_next_update = System.currentTimeMillis();
            }
            this.average_accel = true;
            double d = 50.0;
            this.accel_update_duration = d != 0.0 ? (long)(1000.0 / d) : 0L;
            this.average_orientation = true;
            d = 50.0;
            this.orientation_update_duration = d != 0.0 ? (long)(1000.0 / d) : 0L;
        }
    }

    public void repaint() {
        Platform.runLater((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                GraphicsContext graphicsContext = MobileCanvas.this.canvas.getGraphicsContext2D();
                graphicsContext.clearRect(0.0, 0.0, 198.0, 192.0);
                double d = 100.0;
                double d2 = 100.0;
                double d3 = -150.0;
                double d4 = MobileCanvas.this.old_gyro_rollDegree - MobileCanvas.this.rollDegree.get();
                double d5 = MobileCanvas.this.old_gyro_pitchDegree - MobileCanvas.this.pitchDegree.get();
                double d6 = MobileCanvas.this.old_gyro_yawDegree - MobileCanvas.this.yawDegree.get();
                int n = MobileCanvas.this.phone.length;
                if (!MobileCanvas.this.is_Axis) {
                    n = 32;
                }
                for (int i = 0; i < n; i += 2) {
                    if (i == 0) {
                        graphicsContext.setStroke((Paint)Color.RED);
                    }
                    if (i == 24) {
                        graphicsContext.setStroke((Paint)Color.BLUE);
                    }
                    if (i == 32) {
                        graphicsContext.setStroke((Paint)Color.BLACK);
                    }
                    Vector vector = new Vector(MobileCanvas.this.phone[i]);
                    Vector vector2 = new Vector(MobileCanvas.this.phone[i + 1]);
                    if (i == 0) {
                        Vector vector3 = Vector.obj;
                        synchronized (vector3) {
                            vector.setAxisX(MobileCanvas.this.gyro_axisX);
                            vector.setAxisY(MobileCanvas.this.gyro_axisY);
                            vector.setAxisZ(MobileCanvas.this.gyro_axisZ);
                            vector.rollpitchyaw(d4, d5, d6);
                        }
                    }
                    vector.setPosition();
                    vector2.setPosition();
                    if (MobileCanvas.this.phone_pos_conv && i == n - 2) {
                        MobileCanvas.this.phone_pos_conv = false;
                        MobileCanvas.access$902(MobileCanvas.this, (double[])Vector.getAxisX().clone());
                        MobileCanvas.access$1002(MobileCanvas.this, (double[])Vector.getAxisY().clone());
                        MobileCanvas.access$1102(MobileCanvas.this, (double[])Vector.getAxisZ().clone());
                        MobileCanvas.this.old_gyro_rollDegree = MobileCanvas.this.rollDegree.get();
                        MobileCanvas.this.old_gyro_pitchDegree = MobileCanvas.this.pitchDegree.get();
                        MobileCanvas.this.old_gyro_yawDegree = MobileCanvas.this.yawDegree.get();
                    }
                    graphicsContext.strokeLine(d + (vector.x + (double)MobileCanvas.this.movex) * d3 / (d3 - vector.y), d2 - (vector.z + (double)MobileCanvas.this.movez) * d3 / (d3 - vector.y), d + (vector2.x + (double)MobileCanvas.this.movex) * d3 / (d3 - vector2.y), d2 - (vector2.z + (double)MobileCanvas.this.movez) * d3 / (d3 - vector2.y));
                    if (i == 32) {
                        graphicsContext.strokeText(" x+", (double)((float)(d + (vector.x + (double)MobileCanvas.this.movex) * d3 / (d3 - vector.y))), (double)((float)(d2 - (vector.z + (double)MobileCanvas.this.movez) * d3 / (d3 - vector.y))));
                    }
                    if (i == 34) {
                        graphicsContext.strokeText(" y+", (double)((float)(d + (vector.x + (double)MobileCanvas.this.movex) * d3 / (d3 - vector.y))), (double)((float)(d2 - (vector.z + (double)MobileCanvas.this.movez) * d3 / (d3 - vector.y))));
                    }
                    if (i != 36) continue;
                    graphicsContext.strokeText(" z+", (double)((float)(d + (vector.x + (double)MobileCanvas.this.movex) * d3 / (d3 - vector.y))), (double)((float)(d2 - (vector.z + (double)MobileCanvas.this.movez) * d3 / (d3 - vector.y))));
                }
            }
        });
    }

    public void accelerometerTimer(boolean bl) {
        if (this.timer != null) {
            if (bl && this.connected) {
                this.timer.start();
            }
            if (!bl) {
                this.timer.stop();
            }
        }
    }

    public void geomagneticTimer(boolean bl) {
        if (this.geomagneticTimer != null) {
            if (bl && this.connected) {
                this.geomagneticTimer.start();
            }
            if (!bl) {
                this.geomagneticTimer.stop();
            }
        }
    }

    public void gyroTimer(boolean bl) {
        if (this.gyroTimer != null) {
            if (bl && this.connected) {
                this.gyroTimer.start();
            }
            if (!bl) {
                this.gyroTimer.stop();
            }
        }
    }

    public void setGyroAxisX(double[] dArray) {
        this.gyro_axisX = (double[])dArray.clone();
    }

    public void setGyroAxisY(double[] dArray) {
        this.gyro_axisY = (double[])dArray.clone();
    }

    public void setGyroAxisZ(double[] dArray) {
        this.gyro_axisZ = (double[])dArray.clone();
    }

    public void setOldGyroRollDegree(double d) {
        this.old_gyro_rollDegree = d;
    }

    public void setOldGyroPitchDegree(double d) {
        this.old_gyro_pitchDegree = d;
    }

    public void setOldGyroYawDegree(double d) {
        this.old_gyro_yawDegree = d;
    }

    public void setMode(CANVAS_MODE cANVAS_MODE) {
        this.mode = cANVAS_MODE;
    }

    public void setWithAxis(boolean bl) {
        this.is_Axis = bl;
    }

    public void connect() {
        this.connected = true;
        this.accelerometerTimer(true);
        this.geomagneticTimer(true);
        this.gyroTimer(true);
    }

    public void disconnect() {
        this.connected = false;
        this.accelerometerTimer(false);
        this.geomagneticTimer(false);
        this.gyroTimer(false);
    }

    public void run() {
        this.connect();
        this.init_values();
        this.repaint();
    }

    public void disconnected() {
    }

    public void guestOn() {
        this.accelerometerTimer(true);
        this.geomagneticTimer(true);
        this.gyroTimer(true);
    }

    public void guestOff() {
        this.accelerometerTimer(false);
        this.geomagneticTimer(false);
        this.gyroTimer(false);
    }

    public void guestOffMessage() {
    }

    static /* synthetic */ double[] access$902(MobileCanvas mobileCanvas, double[] dArray) {
        mobileCanvas.gyro_axisX = dArray;
        return dArray;
    }

    static /* synthetic */ double[] access$1002(MobileCanvas mobileCanvas, double[] dArray) {
        mobileCanvas.gyro_axisY = dArray;
        return dArray;
    }

    static /* synthetic */ double[] access$1102(MobileCanvas mobileCanvas, double[] dArray) {
        mobileCanvas.gyro_axisZ = dArray;
        return dArray;
    }
}

