/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.location.model;

public class GeoLocation {
    private double latitude;
    private double NMEAlatitude;
    private Directions northSouth;
    private double longitude;
    private double NMEAlongitude;
    private Directions eastWest;
    private double altitude;
    private double accuracy;
    private String strLatitude;
    private String strLongitude;
    private String strAltitude;
    private String strAccuracy;

    public GeoLocation(double d, double d2) {
        this.setLatitude(d);
        this.setLongitude(d2);
    }

    public GeoLocation(String string, String string2) {
        this.strLatitude = string;
        this.strLongitude = string2;
        this.strAltitude = "0.0";
        this.strAccuracy = "0.0";
    }

    public GeoLocation(String string, String string2, String string3, String string4) {
        this.strLatitude = string;
        this.strLongitude = string2;
        this.strAltitude = string3;
        this.strAccuracy = string4;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getAltitude() {
        return this.altitude;
    }

    public double getAccuracy() {
        return this.accuracy;
    }

    public String getStrLatitude() {
        return this.strLatitude;
    }

    public String getStrLongitude() {
        return this.strLongitude;
    }

    public String getStrAltitude() {
        return this.strAltitude;
    }

    public String getStrAccuracy() {
        return this.strAccuracy;
    }

    public String getNorthSouth() {
        return this.northSouth == Directions.NORTH ? "N" : "S";
    }

    public String getEastWest() {
        return this.eastWest == Directions.EAST ? "E" : "W";
    }

    public double getNMEAlatitude() {
        return this.NMEAlatitude;
    }

    public double getNMEAlongitude() {
        return this.NMEAlongitude;
    }

    public void setLatitude(double d) {
        this.latitude = d;
        if (d < 0.0) {
            this.setNorthSouth(Directions.SOUTH);
        } else {
            this.setNorthSouth(Directions.NORTH);
        }
        this.setNMEAlatitude(Math.abs(d));
    }

    public void setLongitude(double d) {
        this.longitude = d;
        if (d < 0.0) {
            this.setEastWest(Directions.WEST);
        } else {
            this.setEastWest(Directions.EAST);
        }
        this.setNMEAlongitude(Math.abs(d));
    }

    private void setNorthSouth(Directions directions) {
        this.northSouth = directions;
    }

    private void setEastWest(Directions directions) {
        this.eastWest = directions;
    }

    private void setNMEAlatitude(double d) {
        int n = (int)d;
        double d2 = (d - (double)n) * 60.0;
        this.NMEAlatitude = (double)(n * 100) + d2;
    }

    private void setNMEAlongitude(double d) {
        int n = (int)d;
        double d2 = (d - (double)n) * 60.0;
        this.NMEAlongitude = (double)(n * 100) + d2;
    }

    public static enum Directions {
        NORTH,
        SOUTH,
        EAST,
        WEST;

    }
}

