/**
 * @internal
 * @defgroup Elm_Separator Separator
 * @ingroup Elementary
 *
 * @image html separator_inheritance_tree.png
 * @image latex separator_inheritance_tree.eps
 *
 * @brief Separator is a very thin object used to separate other objects.
 *
 * A separator can be vertical or horizontal.
 *
 * This widget inherits from the @ref Elm_Layout one, so that all the
 * functions acting on it also work for separator objects.
 *
 * This widget emits the signals coming from @ref Elm_Layout.
 *
 * @ref tutorial_separator is a good example of how to use a separator.
 * @{
 */

#ifdef EFL_EO_API_SUPPORT
#include "elm_separator_eo.h"
#endif
#ifndef EFL_NOLEGACY_API_SUPPORT
#include "elm_separator_legacy.h"
#endif
/**
 * @}
 */
