#ifndef _EFL_UI_TEXTPATH_EO_LEGACY_H_
#define _EFL_UI_TEXTPATH_EO_LEGACY_H_

#ifndef _EFL_UI_TEXTPATH_EO_CLASS_TYPE
#define _EFL_UI_TEXTPATH_EO_CLASS_TYPE

typedef Eo Efl_Ui_Textpath;

#endif

#ifndef _EFL_UI_TEXTPATH_EO_TYPES
#define _EFL_UI_TEXTPATH_EO_TYPES

typedef enum
{
  EFL_UI_TEXTPATH_DIRECTION_CW = 0,
  EFL_UI_TEXTPATH_DIRECTION_CCW
} Efl_Ui_Textpath_Direction;


#endif
/** Efl Ui Textpath class
 *
 * @ingroup Efl_Ui_Textpath
 */

/**
 * @brief The ability to fit the text within the path. Set it to EINA_TRUE to
 * let text occupy only portion same as its size. Otherwise, text will occupied
 * the whole path. By default, it is EINA_TRUE.
 *
 * @param[in] obj The object.
 * @param[in] autofit
 *
 * @ingroup Efl_Ui_Textpath
 */
EAPI void elm_textpath_autofit_set(Efl_Ui_Textpath *obj, Eina_Bool autofit);

/** The ability to fit the text within the path. Set it to EINA_TRUE to let
 * text occupy only portion same as its size. Otherwise, text will occupied the
 * whole path. By default, it is EINA_TRUE.
 *
 * @ingroup Efl_Ui_Textpath
 */
EAPI Eina_Bool elm_textpath_autofit_get(const Efl_Ui_Textpath *obj);

/**
 * @brief The number of slices. The larger the number of slice_num is, The
 * better the text follows the path.
 *
 * @param[in] obj The object.
 * @param[in] slice_no
 *
 * @ingroup Efl_Ui_Textpath
 */
EAPI void elm_textpath_slice_number_set(Efl_Ui_Textpath *obj, int slice_no);

/** The number of slices. The larger the number of slice_num is, The better the
 * text follows the path.
 *
 * @ingroup Efl_Ui_Textpath
 */
EAPI int elm_textpath_slice_number_get(const Efl_Ui_Textpath *obj);

/**
 * @brief Control the ellipsis behavior of the textpath.
 *
 * @param[in] obj The object.
 * @param[in] ellipsis To ellipsis text or not
 *
 * @ingroup Efl_Ui_Textpath
 */
EAPI void elm_textpath_ellipsis_set(Efl_Ui_Textpath *obj, Eina_Bool ellipsis);

/**
 * @brief Control the ellipsis behavior of the textpath.
 *
 * @param[in] obj The object.
 *
 * @return To ellipsis text or not
 *
 * @ingroup Efl_Ui_Textpath
 */
EAPI Eina_Bool elm_textpath_ellipsis_get(const Efl_Ui_Textpath *obj);

/**
 * @brief Set a circle with given center, radius, and start angle.
 *
 * @param[in] obj The object.
 * @param[in] y
 * @param[in] radius
 * @param[in] start_angle
 * @param[in] direction
 *
 * @ingroup Efl_Ui_Textpath
 */
EAPI void elm_textpath_circle_set(Efl_Ui_Textpath *obj, double x, double y, double radius, double start_angle, Efl_Ui_Textpath_Direction direction);

#endif
