#ifndef _ELM_ROUTE_EO_H_
#define _ELM_ROUTE_EO_H_

#ifndef _ELM_ROUTE_EO_CLASS_TYPE
#define _ELM_ROUTE_EO_CLASS_TYPE

typedef Eo Elm_Route;

#endif

#ifndef _ELM_ROUTE_EO_TYPES
#define _ELM_ROUTE_EO_TYPES


#endif
#define ELM_ROUTE_CLASS elm_route_class_get()

EAPI const Eo_Class *elm_route_class_get(void) EINA_CONST;

/**
 * @internal
 *
 * @brief No description supplied by the EAPI.
 *
 * @param[in] obj The object.
 * @param[in] emap
 *
 * @ingroup Elm_Route
 */
EOAPI void  elm_obj_route_emap_set(void *emap);

/**
 * @internal
 *
 * @brief Get the minimum and maximum values along the
 * longitude.
 *
 * @note If only one value is needed, the other pointer can be passed as null.
 *
 * @param[in] obj The object.
 * @param[out] min Pointer to store the minimum value.
 * @param[out] max Pointer to store the maximum value.
 *
 * @ingroup Elm_Route
 */
EOAPI void  elm_obj_route_longitude_min_max_get(double *min, double *max);

/**
 * @internal
 *
 * @brief Get the minimum and maximum values along the
 * latitude.
 *
 * @note If only one value is needed, the other pointer can be passed as null.
 *
 * @param[in] obj The object.
 * @param[out] min Pointer to store the minimum value.
 * @param[out] max Pointer to store the maximum value.
 *
 * @ingroup Elm_Route
 */
EOAPI void  elm_obj_route_latitude_min_max_get(double *min, double *max);


#endif
