/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.linux.util;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativecommon.build.exception.SBIException;
import org.tizen.nativeplatform.PlatformConfigurationManager;
import org.tizen.nativeplatform.types.PkgTypes;
import org.tizen.nativeplatform.util.CommonBuildCommandUtil;
import org.tizen.nativeplatform.util.IBuildCommandUtil;
import org.tizen.nativeplatform.util.PlatformDirUtil;

public class BuildCommandUtil
implements IBuildCommandUtil {
    public static int LIMIT_COMMAND_LENGTH = 800;
    protected IConfiguration config;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public BuildCommandUtil() {
    }

    public BuildCommandUtil(IConfiguration config) {
        this.setConfiguration(config);
    }

    public String getRootstrapPath() {
        SmartBuildInterface sbi;
        String targetID;
        block4: {
            try {
                String path;
                targetID = PlatformConfigurationManager.getBuildTargetName((IConfiguration)this.config);
                if (targetID == null) {
                    targetID = PlatformConfigurationManager.getDefaultBuildTargetName((IConfiguration)this.config);
                }
                if ((path = (sbi = SmartBuildInterface.getInstance()).getRootstrapPath(targetID)) != null) break block4;
                return "";
            }
            catch (SBIException e) {
                e.printStackTrace();
                return "/";
            }
        }
        return sbi.getRootstrapPath(targetID);
    }

    public void setConfiguration(IConfiguration config) {
        this.config = config;
    }

    public Process createProcess(String command, String workingDir, Map<String, String> newEnv, boolean includeStdErr) throws InterruptedException {
        return CommonBuildCommandUtil.createProcess((String)command, (String)workingDir, newEnv, (boolean)includeStdErr);
    }

    public String makeTempDirectory() {
        File temp;
        try {
            temp = File.createTempFile("temp", Long.toString(System.nanoTime()));
            if (!temp.delete()) {
                throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
            }
            if (!temp.mkdir()) {
                throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return temp.getPath();
    }

    public String getCachingDir(IProject project) {
        return PlatformDirUtil.getCachingDir((IProject)project);
    }

    public String getCachingDir() {
        return PlatformDirUtil.getCachingDir();
    }

    public String getWorkingDir() {
        return PlatformDirUtil.getWorkingDir();
    }

    public String getCoredumpDir() {
        return PlatformDirUtil.getCoredumpDir();
    }

    public boolean clearCachingDir() {
        return PlatformDirUtil.clearCachingDir();
    }

    public boolean clearWorkingDir() {
        return PlatformDirUtil.clearWorkingDir();
    }

    public boolean clearCoredumpDir() {
        return PlatformDirUtil.clearCoredumpDir();
    }

    public void clearPlatformTempDir() {
        PlatformDirUtil.clearPlatformTempDir();
    }

    public PkgTypes getPkgType() {
        return PkgTypes.RPM;
    }

    public boolean existsLocalfile(String path) {
        return new File(path).exists();
    }

    public String[] getRemoteEnvironment() {
        return null;
    }

    public String[] getRemoteCommands(String workingDir, String command) {
        return null;
    }

    public String[] getRemoteCommands(String workingDir, List<String> command) {
        return null;
    }
}

