/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.delegate;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.IProcessInfo;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.utils.PathUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.widgets.Shell;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativecommon.launch.LaunchUtils;
import org.tizen.nativecommon.launch.TizenLaunchMessages;
import org.tizen.nativeplatform.PlatformConfigurationManager;
import org.tizen.nativeplatform.launcher.delegate.AttachLaunchConfigurationProcessor;
import org.tizen.nativeplatform.launcher.delegate.ILaunchConfigurationProcessor;
import org.tizen.nativeplatform.launcher.delegate.PlatformLaunchDelegate;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.util.ProcessSelector;
import org.tizen.sdblib.IDevice;

public class PlatformLaunchDelegateForAttach
extends PlatformLaunchDelegate {
    protected Integer pid = -1;

    @Override
    protected ILaunchConfigurationProcessor getConfigurationProcessor(Shell shell, ILaunchConfiguration launchConfig, IProject project, String mode, PkgCommandTarget target, IProgressMonitor monitor) {
        return new AttachLaunchConfigurationProcessor(shell, launchConfig, project, mode, target, monitor);
    }

    @Override
    protected void launchApplicationForDebug(ILaunch launch, ILaunchConfiguration config, IBinaryParser.IBinaryObject exeFile, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            this.resetGdbserverPortAttr(config);
            if (!LaunchUtils.setAvailableGdbServerPort((ILaunch)launch, (ILaunchConfiguration)config, (IDevice)this.currentDevice)) {
                return;
            }
            monitor.beginTask("", 2);
            monitor.subTask(TizenLaunchMessages.LAUNCH_APPLICATION);
            this.launchApplicationWithGDBServer(launch, config, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.launchApplicationWithGDBClient(launch, config, exeFile, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            monitor.done();
        }
    }

    @Override
    protected void setDebugConfigAttributes(ILaunchConfiguration config) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
        this.pid = wc.getAttribute("org.tizen.platform.launch.PROCESS_ID_ATTR", -1);
    }

    @Override
    protected void processPreDebug(ILaunchConfiguration config) throws CoreException {
        this.setSharedlibrarySearchPath(config);
    }

    protected boolean setConfigurationAndInstallPackages(ILaunchConfiguration launchConfig, IProject project, String mode) throws CoreException {
        return true;
    }

    protected void setOptionAttributes(ILaunchConfigurationWorkingCopy wc, String programPath, String procName, int pid, boolean reinstallOp, boolean selectPkgOp) {
        if (programPath != null) {
            wc.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", programPath);
        }
        wc.setAttribute("org.tizen.platform.launch.PROCESS_NAME_ATTR", procName);
        wc.setAttribute("org.tizen.platform.launch.PROCESS_ID_ATTR", pid);
        wc.setAttribute("org.tizen.platform.launch.REINSTALL_OP_ATTR", reinstallOp);
        try {
            wc.doSave();
        }
        catch (CoreException e) {
            CDebugUIPlugin.log((Throwable)e);
            e.printStackTrace();
        }
    }

    private void setSharedlibrarySearchPath(ILaunchConfiguration config) throws CoreException {
        Path debugLibPath;
        Path programPath;
        List soLibPath = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_SOLIB_PATH, new ArrayList(1));
        List soLibList = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_AUTO_SOLIB_LIST, new ArrayList(1));
        ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
        IProject proj = ProjectUtil.getProject((ILaunchConfiguration)config);
        String appPath = "";
        String binaryPath = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "");
        if (!binaryPath.isEmpty()) {
            appPath = new Path(binaryPath).removeLastSegments(1).toOSString();
        } else {
            this.newCoreException(TizenLaunchMessages.CANNOT_LAUNCH_APPLICATION_WITH_GDBSERVER, null);
        }
        IConfiguration buildConfig = ProjectUtil.getDefaultConfiguration((IProject)proj);
        String path = PlatformConfigurationManager.getRootstrapPath((IConfiguration)buildConfig);
        String rootstrapPath = SmartBuildInterface.getInstance().getPlatformRootstrapPath(path);
        Path debugProjPath = new Path(String.valueOf(rootstrapPath) + File.separatorChar + "usr" + File.separatorChar + "lib" + File.separatorChar + "debug" + File.separatorChar + appPath);
        if (this.canAddLibrarySearchPath(config, (IPath)debugProjPath)) {
            soLibPath.add(debugProjPath.toOSString());
        }
        if (this.canAddLibraryPath(config, (IPath)(programPath = new Path(String.valueOf(rootstrapPath) + File.separatorChar + "usr" + File.separatorChar + "lib" + File.separatorChar + "debug" + File.separatorChar + binaryPath + ".debug")))) {
            soLibList.add(programPath.toOSString());
        }
        ArrayList<String> aa = new ArrayList<String>();
        aa.add(debugProjPath.append("taskmgr.debug").toOSString());
        Path debugBinPath = new Path(String.valueOf(rootstrapPath) + File.separatorChar + "usr" + File.separatorChar + "lib" + File.separatorChar + "debug" + File.separatorChar + "usr" + File.separatorChar + "bin");
        if (this.canAddLibrarySearchPath(config, (IPath)debugBinPath)) {
            soLibPath.add(debugBinPath.toOSString());
        }
        if (this.canAddLibrarySearchPath(config, (IPath)(debugLibPath = new Path(String.valueOf(rootstrapPath) + File.separatorChar + "usr" + File.separatorChar + "lib" + File.separatorChar + "debug" + File.separatorChar + "usr" + File.separatorChar + "lib")))) {
            soLibPath.add(debugLibPath.toOSString());
        }
        if (soLibPath.size() > 0) {
            wc.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_SOLIB_PATH, soLibPath);
        }
        wc.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_AUTO_SOLIB_LIST, soLibList);
        wc.doSave();
    }

    protected boolean canAddLibrarySearchPath(ILaunchConfiguration config, IPath searchPath) throws CoreException {
        List values = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_SOLIB_PATH, Collections.EMPTY_LIST);
        Iterator it = values.iterator();
        boolean ret = true;
        while (it.hasNext()) {
            Path oldPath = new Path((String)it.next());
            if (!PathUtil.equalPath((IPath)oldPath, (IPath)searchPath)) continue;
            ret = false;
            break;
        }
        return ret;
    }

    protected boolean canAddLibraryPath(ILaunchConfiguration config, IPath searchPath) throws CoreException {
        List values = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_AUTO_SOLIB_LIST, Collections.EMPTY_LIST);
        Iterator it = values.iterator();
        boolean ret = true;
        while (it.hasNext()) {
            Path oldPath = new Path((String)it.next());
            if (!PathUtil.equalPath((IPath)oldPath, (IPath)searchPath)) continue;
            ret = false;
            break;
        }
        return ret;
    }

    @Override
    protected void checkChangedConfiguration(ILaunchConfiguration config, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", 1);
        monitor.subTask("Setting attach process...");
        try {
            this.setAttachProcess(config);
        }
        finally {
            monitor.done();
        }
    }

    @Override
    protected String getGdbserverRunCommand(ILaunchConfiguration config) throws CoreException, Exception {
        String gdbserverPort = config.getAttribute("org.eclipse.cdt.dsf.gdb.PORT", "26102");
        String commandArguments = ":" + gdbserverPort + " --attach " + this.pid;
        String gdbserverCmd = String.valueOf(TizenPlatformConstants.GDBSERVER_PLATFORM_CMD) + " " + commandArguments;
        String envCmd = this.getEnvironments(config);
        String command = String.valueOf(envCmd) + gdbserverCmd;
        return command;
    }

    private void setAttachProcess(ILaunchConfiguration config) throws CoreException {
        ProcessSelector selector = new ProcessSelector(this.currentDevice);
        String processName = config.getAttribute("org.tizen.platform.launch.PROCESS_NAME_ATTR", "");
        IProcessInfo procInfo = selector.getProcess(this.shell, processName);
        if (procInfo == null) {
            this.newCoreException("Canceled", null);
        }
        String programPath = procInfo.getName().trim();
        int pid = procInfo.getPid();
        ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
        wc.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", programPath);
        wc.setAttribute("org.tizen.platform.launch.PROCESS_ID_ATTR", pid);
        wc.doSave();
    }

    @Override
    protected File getGDBClientArgument(IBinaryParser.IBinaryObject exeFile) {
        return null;
    }
}

