/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.rootstrap.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.tizen.common.ui.view.console.ConsoleManager;
import org.tizen.common.util.DialogUtil;
import org.tizen.nativeplatform.command.launcher.HostCommandLauncher;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.repo.commander.RepoManager;
import org.tizen.nativeplatform.repo.model.Repository;
import org.tizen.nativeplatform.rootstrap.IRootstrapManager;
import org.tizen.nativeplatform.rootstrap.RootstrapInstances;
import org.tizen.nativeplatform.rootstrap.wizard.RootstrapSettingPage3;
import org.tizen.nativeplatform.rootstrap.wizard.RootstrapWizardData;
import org.tizen.nativeplatform.util.GBSArchitectureChecker;

public class RootstrapGenWizard2
extends Wizard
implements IPageChangingListener,
IPageChangedListener {
    protected IProject project;
    protected IConfiguration config;
    protected PlatformRootstrap generatedRootstrap;
    protected Shell shell;
    private RootstrapSettingPage3 page = null;
    private static final String SETTING_PAGE = "setting_page";
    private final String BUNDLE_NAME = String.valueOf(RootstrapGenWizard2.class.getPackage().getName()) + ".RootstrapWizardUIMessages";
    private ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);

    public RootstrapGenWizard2(Shell shell) {
        this.shell = shell;
        RootstrapWizardData.clearData();
    }

    public boolean performCancel() {
        RootstrapWizardData.getConsoleMgr().removeConsole();
        return super.performCancel();
    }

    public boolean performFinish() {
        String rootstrapName = RootstrapWizardData.getRootstrapName();
        String arch = GBSArchitectureChecker.changeToSupportedArchitecture((String)RootstrapWizardData.getRootstrapArch());
        List<String> repositoryURLs = RootstrapWizardData.getRepositories();
        List repoURLs = RepoManager.createRepoList(repositoryURLs);
        boolean immediateGen = RootstrapWizardData.isGenImmediately();
        Path buildConfFile = new Path(RootstrapWizardData.getConfFilePath());
        boolean result = this.genRootstrap(rootstrapName, arch, repoURLs, immediateGen, (IPath)buildConfFile);
        return result;
    }

    private boolean genRootstrap(final String name, final String arch, final List<Repository> repoURLs, final boolean immediateGen, final IPath buildConfFile) {
        ConsoleManager consoleManager;
        IWizardContainer container = this.getContainer();
        try {
            try {
                container.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(RootstrapGenWizard2.this.resources.getString("Wizard.Msg.Gen"), -1);
                        HostCommandLauncher.addConsoleListener((ConsoleManager)RootstrapWizardData.getConsoleMgr());
                        IRootstrapManager iRootstrapManager = RootstrapInstances.getRootstrapManager();
                        if (iRootstrapManager != null) {
                            RootstrapGenWizard2.this.generatedRootstrap = iRootstrapManager.generateRootstrap(name, arch, "1.0", repoURLs, immediateGen, buildConfFile, monitor);
                            if (RootstrapGenWizard2.this.generatedRootstrap == null) {
                                throw new InterruptedException(RootstrapGenWizard2.this.resources.getString("Wizard.Error.CheckLog"));
                            }
                            iRootstrapManager.afterGenRootstrap(RootstrapGenWizard2.this.generatedRootstrap, immediateGen, monitor);
                        }
                    }
                });
            }
            catch (Exception e) {
                DialogUtil.openErrorDialog((String)(String.valueOf(this.resources.getString("Wizard.Error.Gen")) + "\n" + e.getMessage()));
                IRootstrapManager iRootstrapManager = RootstrapInstances.getRootstrapManager();
                if (iRootstrapManager != null) {
                    iRootstrapManager.removeLatestTempDirForRootstrap();
                }
                HostCommandLauncher.removeConsoleListener((ConsoleManager)RootstrapWizardData.getConsoleMgr());
                return false;
            }
        }
        finally {
            IRootstrapManager iRootstrapManager = RootstrapInstances.getRootstrapManager();
            if (iRootstrapManager != null) {
                iRootstrapManager.removeLatestTempDirForRootstrap();
            }
            HostCommandLauncher.removeConsoleListener((ConsoleManager)RootstrapWizardData.getConsoleMgr());
        }
        IRootstrapManager iRootstrapManager = RootstrapInstances.getRootstrapManager();
        if (iRootstrapManager != null) {
            iRootstrapManager.addRootstrap(this.generatedRootstrap);
        }
        if ((consoleManager = RootstrapWizardData.getConsoleMgr()) != null) {
            consoleManager.removeConsole();
        }
        return true;
    }

    public void addPages() {
        this.page = new RootstrapSettingPage3(this, SETTING_PAGE, this.shell, this.project, this.config);
        this.addPage((IWizardPage)this.page);
        WizardDialog dialog = (WizardDialog)this.getContainer();
        dialog.addPageChangedListener((IPageChangedListener)this);
        dialog.addPageChangingListener((IPageChangingListener)this);
    }

    public boolean needsProgressMonitor() {
        return true;
    }

    public boolean canFinish() {
        return this.page.canFinish();
    }

    public void pageChanged(PageChangedEvent event) {
    }

    public void handlePageChanging(PageChangingEvent event) {
    }
}

