/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.rootstrap.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tizen.nativeplatform.rootstrap.util.ZypperRepo;

public class DeviceRepoManager {
    private static Map<String, List<ZypperRepo>> data = new HashMap<String, List<ZypperRepo>>();

    public static void clear() {
        data.clear();
    }

    public static void put(String key, List<ZypperRepo> value) {
        data.put(key, value);
    }

    public static String[] getDeviceNames() {
        Set<String> keys = data.keySet();
        return keys.toArray(new String[0]);
    }

    public static String[] getRepos(String key) {
        ArrayList<String> result = new ArrayList<String>();
        if (data.containsKey(key)) {
            List<ZypperRepo> value = data.get(key);
            for (ZypperRepo repo : value) {
                String url = repo.getBaseURL();
                result.add(url);
            }
        }
        return result.toArray(new String[0]);
    }

    public static String[] getRepos(String key, String arch) {
        ArrayList<String> result = new ArrayList<String>();
        if (data.containsKey(key)) {
            List<ZypperRepo> value = data.get(key);
            for (ZypperRepo repo : value) {
                if (!repo.getArch().equals(arch)) continue;
                String url = repo.getBaseURL();
                result.add(url);
            }
        }
        return result.toArray(new String[0]);
    }

    public static String[] getArchs(String key) {
        HashSet<String> archs = new HashSet<String>();
        if (data.containsKey(key)) {
            List<ZypperRepo> value = data.get(key);
            for (ZypperRepo repo : value) {
                String arch = repo.getArch();
                archs.add(arch);
            }
        }
        return archs.toArray(new String[0]);
    }
}

